/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.domain.persistence.KomgaUserRepository;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.interfaces.api.rest.dto.JsonFeedDto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/announcements"}, produces={"application/json"})
@Tag(name="Announcements")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\"\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u000e\b\u0001\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015H\u0017J\n\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r\u0012\u000b\u0012\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\r0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gotson/komga/interfaces/api/rest/AnnouncementController;", "", "userRepository", "Lorg/gotson/komga/domain/persistence/KomgaUserRepository;", "webClientBuilder", "Lorg/springframework/web/reactive/function/client/WebClient$Builder;", "<init>", "(Lorg/gotson/komga/domain/persistence/KomgaUserRepository;Lorg/springframework/web/reactive/function/client/WebClient$Builder;)V", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/gotson/komga/interfaces/api/rest/dto/JsonFeedDto;", "getAnnouncements", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "markAnnouncementsRead", "", "announcementIds", "", "fetchWebsiteAnnouncements", "komga"})
@SourceDebugExtension(value={"SMAP\nAnnouncementController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnouncementController.kt\norg/gotson/komga/interfaces/api/rest/AnnouncementController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1563#2:77\n1634#2,3:78\n*S KotlinDebug\n*F\n+ 1 AnnouncementController.kt\norg/gotson/komga/interfaces/api/rest/AnnouncementController\n*L\n51#1:77\n51#1:78,3\n*E\n"})
public class AnnouncementController {
    @NotNull
    private final KomgaUserRepository userRepository;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final Cache<String, JsonFeedDto> cache;

    public AnnouncementController(@NotNull KomgaUserRepository userRepository, @NotNull WebClient.Builder webClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        Intrinsics.checkNotNullParameter((Object)webClientBuilder, (String)"webClientBuilder");
        this.userRepository = userRepository;
        WebClient webClient = webClientBuilder.baseUrl("https://komga.org/blog/feed.json").build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        this.webClient = webClient;
        Cache cache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping
    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Retrieve announcements")
    @NotNull
    public JsonFeedDto getAnnouncements(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        JsonFeedDto jsonFeedDto;
        block4: {
            block3: {
                Collection<JsonFeedDto.ItemDto> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                JsonFeedDto jsonFeedDto2 = (JsonFeedDto)this.cache.get((Object)"announcements", arg_0 -> AnnouncementController.getAnnouncements$lambda$1(arg_0 -> AnnouncementController.getAnnouncements$lambda$0(this, arg_0), arg_0));
                if (jsonFeedDto2 == null) break block3;
                JsonFeedDto feed = jsonFeedDto2;
                boolean bl = false;
                Set read = this.userRepository.findAnnouncementIdsReadByUserId(principal.getUser().getId());
                Iterable iterable = feed.getItems();
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                JsonFeedDto jsonFeedDto3 = feed;
                boolean $i$f$map = false;
                void var14_13 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void item;
                    JsonFeedDto.ItemDto itemDto = (JsonFeedDto.ItemDto)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(JsonFeedDto.ItemDto.copy$default((JsonFeedDto.ItemDto)item, null, null, null, null, null, null, null, null, (JsonFeedDto.KomgaExtensionDto)new JsonFeedDto.KomgaExtensionDto(read.contains(item.getId())), (int)255, null));
                }
                collection = (List)destination$iv$iv;
                jsonFeedDto = JsonFeedDto.copy$default((JsonFeedDto)jsonFeedDto3, string4, string3, string2, string, (List)collection, (int)15, null);
                if (jsonFeedDto != null) break block4;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return jsonFeedDto;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PutMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Mark announcements as read")
    public void markAnnouncementsRead(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @RequestBody @NotNull Set<String> announcementIds) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter(announcementIds, (String)"announcementIds");
        this.userRepository.saveAnnouncementIdsRead(principal.getUser(), announcementIds);
    }

    @Nullable
    public JsonFeedDto fetchWebsiteAnnouncements() {
        ResponseEntity response2;
        ResponseEntity responseEntity = response2 = (ResponseEntity)this.webClient.get().retrieve().toEntity(JsonFeedDto.class).block();
        return responseEntity != null ? (JsonFeedDto)responseEntity.getBody() : null;
    }

    private static final JsonFeedDto getAnnouncements$lambda$0(AnnouncementController this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.fetchWebsiteAnnouncements();
    }

    private static final JsonFeedDto getAnnouncements$lambda$1(Function1 $tmp0, Object p0) {
        return (JsonFeedDto)$tmp0.invoke(p0);
    }
}

