/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.application.tasks.TaskEmitter;
import org.gotson.komga.domain.model.BookPageNumbered;
import org.gotson.komga.domain.model.PageHashKnown;
import org.gotson.komga.domain.model.PageHashMatch;
import org.gotson.komga.domain.model.PageHashUnknown;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.persistence.PageHashRepository;
import org.gotson.komga.domain.service.PageHashLifecycle;
import org.gotson.komga.infrastructure.openapi.PageableAsQueryParam;
import org.gotson.komga.infrastructure.web.UtilsKt;
import org.gotson.komga.interfaces.api.rest.dto.PageHashCreationDto;
import org.gotson.komga.interfaces.api.rest.dto.PageHashKnownDto;
import org.gotson.komga.interfaces.api.rest.dto.PageHashKnownDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.PageHashMatchDto;
import org.gotson.komga.interfaces.api.rest.dto.PageHashMatchDtoKt;
import org.gotson.komga.interfaces.api.rest.dto.PageHashUnknownDto;
import org.gotson.komga.interfaces.api.rest.dto.PageHashUnknownDtoKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/page-hashes"}, produces={"application/json"})
@PreAuthorize(value="hasRole('ADMIN')")
@Tag(name="Duplicate Pages")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0010\b\u0001\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0012\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000b2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J)\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\n\b\u0003\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0017\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\u0014\u001a\u00020!H\u0017J\u0012\u0010\"\u001a\u00020 2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u001c\u0010#\u001a\u00020 2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010$\u001a\u00020\u0019H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/gotson/komga/interfaces/api/rest/PageHashController;", "", "pageHashRepository", "Lorg/gotson/komga/domain/persistence/PageHashRepository;", "pageHashLifecycle", "Lorg/gotson/komga/domain/service/PageHashLifecycle;", "taskEmitter", "Lorg/gotson/komga/application/tasks/TaskEmitter;", "<init>", "(Lorg/gotson/komga/domain/persistence/PageHashRepository;Lorg/gotson/komga/domain/service/PageHashLifecycle;Lorg/gotson/komga/application/tasks/TaskEmitter;)V", "getKnownPageHashes", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/interfaces/api/rest/dto/PageHashKnownDto;", "actions", "", "Lorg/gotson/komga/domain/model/PageHashKnown$Action;", "page", "Lorg/springframework/data/domain/Pageable;", "getKnownPageHashThumbnail", "", "pageHash", "", "getUnknownPageHashes", "Lorg/gotson/komga/interfaces/api/rest/dto/PageHashUnknownDto;", "getPageHashMatches", "Lorg/gotson/komga/interfaces/api/rest/dto/PageHashMatchDto;", "getUnknownPageHashThumbnail", "Lorg/springframework/http/ResponseEntity;", "resize", "", "(Ljava/lang/String;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "createOrUpdateKnownPageHash", "", "Lorg/gotson/komga/interfaces/api/rest/dto/PageHashCreationDto;", "deleteDuplicatePagesByPageHash", "deleteSingleMatchByPageHash", "matchDto", "komga"})
@SourceDebugExtension(value={"SMAP\nPageHashController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageHashController.kt\norg/gotson/komga/interfaces/api/rest/PageHashController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,169:1\n1504#2:170\n1534#2,3:171\n1537#2,3:181\n382#3,7:174\n*S KotlinDebug\n*F\n+ 1 PageHashController.kt\norg/gotson/komga/interfaces/api/rest/PageHashController\n*L\n129#1:170\n129#1:171,3\n129#1:181,3\n129#1:174,7\n*E\n"})
public class PageHashController {
    @NotNull
    private final PageHashRepository pageHashRepository;
    @NotNull
    private final PageHashLifecycle pageHashLifecycle;
    @NotNull
    private final TaskEmitter taskEmitter;

    public PageHashController(@NotNull PageHashRepository pageHashRepository, @NotNull PageHashLifecycle pageHashLifecycle, @NotNull TaskEmitter taskEmitter) {
        Intrinsics.checkNotNullParameter((Object)pageHashRepository, (String)"pageHashRepository");
        Intrinsics.checkNotNullParameter((Object)pageHashLifecycle, (String)"pageHashLifecycle");
        Intrinsics.checkNotNullParameter((Object)taskEmitter, (String)"taskEmitter");
        this.pageHashRepository = pageHashRepository;
        this.pageHashLifecycle = pageHashLifecycle;
        this.taskEmitter = taskEmitter;
    }

    @Operation(summary="List known duplicates")
    @GetMapping
    @PageableAsQueryParam
    @NotNull
    public Page<PageHashKnownDto> getKnownPageHashes(@RequestParam(name="action", required=false) @Nullable List<? extends PageHashKnown.Action> actions, @Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Page page2 = this.pageHashRepository.findAllKnown(actions, page).map(arg_0 -> PageHashController.getKnownPageHashes$lambda$1(PageHashController::getKnownPageHashes$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    @Operation(summary="Get known duplicate image thumbnail")
    @GetMapping(value={"/{pageHash}/thumbnail"}, produces={"image/jpeg"})
    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @NotNull
    public byte[] getKnownPageHashThumbnail(@PathVariable @NotNull String pageHash) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        byte[] byArray = this.pageHashRepository.getKnownThumbnail(pageHash);
        if (byArray == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return byArray;
    }

    @Operation(summary="List unknown duplicates")
    @GetMapping(value={"/unknown"})
    @PageableAsQueryParam
    @NotNull
    public Page<PageHashUnknownDto> getUnknownPageHashes(@Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Page page2 = this.pageHashRepository.findAllUnknown(page).map(arg_0 -> PageHashController.getUnknownPageHashes$lambda$3(PageHashController::getUnknownPageHashes$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    @Operation(summary="List duplicate matches")
    @GetMapping(value={"{pageHash}"})
    @PageableAsQueryParam
    @NotNull
    public Page<PageHashMatchDto> getPageHashMatches(@PathVariable @NotNull String pageHash, @Parameter(hidden=true) @NotNull Pageable page) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Page page2 = this.pageHashRepository.findMatchesByHash(pageHash, page).map(arg_0 -> PageHashController.getPageHashMatches$lambda$5(PageHashController::getPageHashMatches$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    @Operation(summary="Get unknown duplicate image thumbnail")
    @GetMapping(value={"unknown/{pageHash}/thumbnail"}, produces={"image/jpeg"})
    @ApiResponse(content={@Content(schema=@Schema(format="binary", type="string"))})
    @NotNull
    public ResponseEntity<byte[]> getUnknownPageHashThumbnail(@PathVariable @NotNull String pageHash, @RequestParam(value="resize") @Nullable Integer resize) {
        TypedBytes typedBytes;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
                typedBytes = this.pageHashLifecycle.getPage(pageHash, resize);
                if (typedBytes == null) break block2;
                TypedBytes it = typedBytes;
                boolean bl = false;
                ResponseEntity responseEntity = ResponseEntity.ok().contentType(UtilsKt.getMediaTypeOrDefault((String)it.getMediaType())).body((Object)it.getBytes());
                typedBytes = responseEntity;
                if (responseEntity != null) break block3;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return typedBytes;
    }

    public static /* synthetic */ ResponseEntity getUnknownPageHashThumbnail$default(PageHashController pageHashController, String string, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUnknownPageHashThumbnail");
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        return pageHashController.getUnknownPageHashThumbnail(string, n);
    }

    @Operation(summary="Mark duplicate page as known")
    @PutMapping
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void createOrUpdateKnownPageHash(@Valid @RequestBody @NotNull PageHashCreationDto pageHash) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        try {
            this.pageHashLifecycle.createOrUpdate(new PageHashKnown(pageHash.getHash(), pageHash.getSize(), pageHash.getAction(), 0, 0, null, null, 120, null));
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Operation(summary="Delete all duplicate pages by hash")
    @PostMapping(value={"{pageHash}/delete-all"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteDuplicatePagesByPageHash(@PathVariable @NotNull String pageHash) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        Pageable pageable = Pageable.unpaged();
        Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged(...)");
        Iterable $this$groupBy$iv = (Iterable)this.pageHashRepository.findMatchesByHash(pageHash, pageable);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            PageHashMatch it = (PageHashMatch)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getBookId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            it = (PageHashMatch)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            list.add(new BookPageNumbered(it.getFileName(), it.getMediaType(), null, pageHash, Long.valueOf(it.getFileSize()), it.getPageNumber(), 4, null));
        }
        Map toRemove = destination$iv$iv;
        TaskEmitter.removeDuplicatePages$default((TaskEmitter)this.taskEmitter, (Map)toRemove, (int)0, (int)2, null);
    }

    @Operation(summary="Delete specific duplicate page")
    @PostMapping(value={"{pageHash}/delete-match"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void deleteSingleMatchByPageHash(@PathVariable @NotNull String pageHash, @RequestBody @NotNull PageHashMatchDto matchDto) {
        Intrinsics.checkNotNullParameter((Object)pageHash, (String)"pageHash");
        Intrinsics.checkNotNullParameter((Object)matchDto, (String)"matchDto");
        Pair toRemove = new Pair((Object)matchDto.getBookId(), (Object)CollectionsKt.listOf((Object)new BookPageNumbered(matchDto.getFileName(), matchDto.getMediaType(), null, pageHash, Long.valueOf(matchDto.getFileSize()), matchDto.getPageNumber(), 4, null)));
        TaskEmitter.removeDuplicatePages$default((TaskEmitter)this.taskEmitter, (String)((String)toRemove.getFirst()), (Collection)((Collection)toRemove.getSecond()), (int)0, (int)4, null);
    }

    private static final PageHashKnownDto getKnownPageHashes$lambda$0(PageHashKnown it) {
        Intrinsics.checkNotNull((Object)it);
        return PageHashKnownDtoKt.toDto((PageHashKnown)it);
    }

    private static final PageHashKnownDto getKnownPageHashes$lambda$1(Function1 $tmp0, Object p0) {
        return (PageHashKnownDto)$tmp0.invoke(p0);
    }

    private static final PageHashUnknownDto getUnknownPageHashes$lambda$2(PageHashUnknown it) {
        Intrinsics.checkNotNull((Object)it);
        return PageHashUnknownDtoKt.toDto((PageHashUnknown)it);
    }

    private static final PageHashUnknownDto getUnknownPageHashes$lambda$3(Function1 $tmp0, Object p0) {
        return (PageHashUnknownDto)$tmp0.invoke(p0);
    }

    private static final PageHashMatchDto getPageHashMatches$lambda$4(PageHashMatch it) {
        Intrinsics.checkNotNull((Object)it);
        return PageHashMatchDtoKt.toDto((PageHashMatch)it);
    }

    private static final PageHashMatchDto getPageHashMatches$lambda$5(Function1 $tmp0, Object p0) {
        return (PageHashMatchDto)$tmp0.invoke(p0);
    }
}

