/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.scheduler;

import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.domain.persistence.AuthenticationActivityRepository;
import org.gotson.komga.interfaces.scheduler.AuthenticationActivityCleanupControllerKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Profile(value={"!test"})
@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gotson/komga/interfaces/scheduler/AuthenticationActivityCleanupController;", "", "authenticationActivityRepository", "Lorg/gotson/komga/domain/persistence/AuthenticationActivityRepository;", "<init>", "(Lorg/gotson/komga/domain/persistence/AuthenticationActivityRepository;)V", "cleanup", "", "komga"})
public class AuthenticationActivityCleanupController {
    @NotNull
    private final AuthenticationActivityRepository authenticationActivityRepository;

    public AuthenticationActivityCleanupController(@NotNull AuthenticationActivityRepository authenticationActivityRepository) {
        Intrinsics.checkNotNullParameter((Object)authenticationActivityRepository, (String)"authenticationActivityRepository");
        this.authenticationActivityRepository = authenticationActivityRepository;
    }

    @Scheduled(fixedRate=86400000L)
    public void cleanup() {
        LocalDateTime olderThan = LocalDateTime.now(ZoneId.of("Z")).minusMonths(1L);
        AuthenticationActivityCleanupControllerKt.access$getLogger$p().info(() -> AuthenticationActivityCleanupController.cleanup$lambda$0(olderThan));
        Intrinsics.checkNotNull((Object)olderThan);
        this.authenticationActivityRepository.deleteOlderThan(olderThan);
    }

    private static final Object cleanup$lambda$0(LocalDateTime $olderThan) {
        return "Remove authentication activity older than " + $olderThan + " (UTC)";
    }
}

