/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookConversionException;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.BookPageKt;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.HistoricalEvent;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MediaNotReadyException;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.MediaUnsupportedException;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.HistoricalEventRepository;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.domain.service.BookConverterKt;
import org.gotson.komga.domain.service.FileSystemScanner;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001eH\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/gotson/komga/domain/service/BookConverter;", "", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "fileSystemScanner", "Lorg/gotson/komga/domain/service/FileSystemScanner;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "transactionTemplate", "Lorg/springframework/transaction/support/TransactionTemplate;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "historicalEventRepository", "Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;", "<init>", "(Lorg/gotson/komga/domain/service/BookAnalyzer;Lorg/gotson/komga/domain/service/FileSystemScanner;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/springframework/transaction/support/TransactionTemplate;Lorg/springframework/context/ApplicationEventPublisher;Lorg/gotson/komga/domain/persistence/HistoricalEventRepository;)V", "convertibleTypes", "", "", "mediaTypeToExtension", "", "failedConversions", "", "skippedRepairs", "getConvertibleBooks", "", "Lorg/gotson/komga/domain/model/Book;", "library", "Lorg/gotson/komga/domain/model/Library;", "convertToCbz", "", "book", "getMismatchedExtensionBooks", "repairExtension", "komga"})
@SourceDebugExtension(value={"SMAP\nBookConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookConverter.kt\norg/gotson/komga/domain/service/BookConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,221:1\n1193#2,2:222\n1267#2,4:224\n1563#2:229\n1634#2,3:230\n1563#2:233\n1634#2,3:234\n1869#2,2:237\n1563#2:239\n1634#2,3:240\n1563#2:243\n1634#2,3:244\n1563#2:247\n1634#2,3:248\n1563#2:251\n1634#2,3:252\n1#3:228\n77#4:255\n97#4,5:256\n*S KotlinDebug\n*F\n+ 1 BookConverter.kt\norg/gotson/komga/domain/service/BookConverter\n*L\n56#1:222,2\n56#1:224,4\n105#1:229\n105#1:230,3\n106#1:233\n106#1:234,3\n107#1:237,2\n136#1:239\n136#1:240,3\n137#1:243\n137#1:244,3\n141#1:247\n141#1:248,3\n142#1:251\n142#1:252,3\n168#1:255\n168#1:256,5\n*E\n"})
public class BookConverter {
    @NotNull
    private final BookAnalyzer bookAnalyzer;
    @NotNull
    private final FileSystemScanner fileSystemScanner;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final LibraryRepository libraryRepository;
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final HistoricalEventRepository historicalEventRepository;
    @NotNull
    private final List<String> convertibleTypes;
    @NotNull
    private final Map<String, String> mediaTypeToExtension;
    @NotNull
    private final List<String> failedConversions;
    @NotNull
    private final List<String> skippedRepairs;

    /*
     * WARNING - void declaration
     */
    public BookConverter(@NotNull BookAnalyzer bookAnalyzer, @NotNull FileSystemScanner fileSystemScanner, @NotNull BookRepository bookRepository, @NotNull MediaRepository mediaRepository, @NotNull LibraryRepository libraryRepository, @NotNull TransactionTemplate transactionTemplate, @NotNull ApplicationEventPublisher eventPublisher, @NotNull HistoricalEventRepository historicalEventRepository) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        Intrinsics.checkNotNullParameter((Object)fileSystemScanner, (String)"fileSystemScanner");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)transactionTemplate, (String)"transactionTemplate");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)historicalEventRepository, (String)"historicalEventRepository");
        this.bookAnalyzer = bookAnalyzer;
        this.fileSystemScanner = fileSystemScanner;
        this.bookRepository = bookRepository;
        this.mediaRepository = mediaRepository;
        this.libraryRepository = libraryRepository;
        this.transactionTemplate = transactionTemplate;
        this.eventPublisher = eventPublisher;
        this.historicalEventRepository = historicalEventRepository;
        Object object = new String[]{MediaType.RAR_4.getType(), MediaType.RAR_5.getType()};
        this.convertibleTypes = CollectionsKt.listOf((Object[])object);
        object = new MediaType[]{MediaType.RAR_4, MediaType.RAR_5, MediaType.ZIP, MediaType.PDF, MediaType.EPUB};
        object = CollectionsKt.listOf((Object[])object);
        BookConverter bookConverter = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var12_13 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            MediaType it = (MediaType)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getType(), (Object)it.getFileExtension());
            map.put(pair.getFirst(), pair.getSecond());
        }
        bookConverter.mediaTypeToExtension = destination$iv$iv;
        this.failedConversions = new ArrayList();
        this.skippedRepairs = new ArrayList();
    }

    @NotNull
    public Collection<Book> getConvertibleBooks(@NotNull Library library) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (library.getConvertToCbz()) {
            Collection collection2;
            Collection it = collection2 = this.bookRepository.findAllByLibraryIdAndMediaTypes(library.getId(), (Collection)this.convertibleTypes);
            boolean bl = false;
            BookConverterKt.access$getLogger$p().info(() -> BookConverter.getConvertibleBooks$lambda$2$lambda$1(it));
            collection = collection2;
        } else {
            BookConverterKt.access$getLogger$p().info(BookConverter::getConvertibleBooks$lambda$3);
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void convertToCbz(@NotNull Book book) {
        void $this$forEach$iv;
        Object zipStream;
        Object scannedBook;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        if (!this.libraryRepository.findById(book.getLibraryId()).getConvertToCbz()) {
            BookConverterKt.access$getLogger$p().info(BookConverter::convertToCbz$lambda$4);
            return;
        }
        if (this.failedConversions.contains(book.getId())) {
            BookConverterKt.access$getLogger$p().info(BookConverter::convertToCbz$lambda$5);
            return;
        }
        Book book2 = this.fileSystemScanner.scanFile(book.getPath());
        if (book2 != null) {
            scannedBook = book2;
            boolean bl = false;
            if (LanguageUtilsKt.notEquals$default((LocalDateTime)scannedBook.getFileLastModified(), (LocalDateTime)book.getFileLastModified(), null, (int)2, null)) {
                BookConverterKt.access$getLogger$p().info(BookConverter::convertToCbz$lambda$7$lambda$6);
                return;
            }
        } else {
            throw new FileNotFoundException("File not found: " + book.getPath());
        }
        Media media = this.mediaRepository.findById(book.getId());
        if (!CollectionsKt.contains((Iterable)this.convertibleTypes, (Object)media.getMediaType())) {
            throw new MediaUnsupportedException(media.getMediaType() + " cannot be converted. Must be one of " + this.convertibleTypes, null, 2, null);
        }
        if (media.getStatus() != Media.Status.READY) {
            throw new MediaNotReadyException();
        }
        String destinationFilename = PathsKt.getNameWithoutExtension((Path)book.getPath()) + ".cbz";
        Path destinationPath = book.getPath().getParent().resolve(destinationFilename);
        Intrinsics.checkNotNull((Object)destinationPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(destinationPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new FileAlreadyExistsException("Destination file already exists: " + destinationPath);
        }
        BookConverterKt.access$getLogger$p().info(() -> BookConverter.convertToCbz$lambda$8(destinationPath));
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(destinationPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        scannedBook = (Closeable)new ZipArchiveOutputStream(outputStream);
        Throwable bl = null;
        try {
            MediaFile it;
            Iterable<String> iterable;
            Object item$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            zipStream = (ZipArchiveOutputStream)scannedBook;
            boolean bl2 = false;
            zipStream.setMethod(8);
            zipStream.setLevel(0);
            Iterable iterable2 = media.getPages();
            boolean $i$f$map = false;
            void var11_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                BookPage bookPage = (BookPage)item$iv$iv;
                iterable = destination$iv$iv;
                boolean bl3 = false;
                iterable.add(it.getFileName());
            }
            $this$map$iv = media.getFiles();
            iterable = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                it = (MediaFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.getFileName());
            }
            $this$map$iv = CollectionsKt.union(iterable, (Iterable)((List)destination$iv$iv));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String entry = (String)element$iv;
                boolean bl5 = false;
                zipStream.putArchiveEntry(new ZipArchiveEntry(entry));
                zipStream.write(this.bookAnalyzer.getFileContent(new BookWithMedia(book, media), entry));
                zipStream.closeArchiveEntry();
            }
            zipStream = Unit.INSTANCE;
        }
        catch (Throwable bl2) {
            bl = bl2;
            throw bl2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)scannedBook, (Throwable)bl);
        }
        bl = this.fileSystemScanner.scanFile(destinationPath);
        if (bl == null || (zipStream = Book.copy$default((Book)bl, null, null, null, (long)0L, null, null, (int)0, (String)book.getId(), (String)book.getSeriesId(), (String)book.getLibraryId(), null, (boolean)false, null, null, (int)15487, null)) == null) {
            throw new IllegalStateException("Newly converted book could not be scanned: " + destinationFilename);
        }
        ZipArchiveOutputStream convertedBook = zipStream;
        Media convertedMedia = this.bookAnalyzer.analyze((Book)convertedBook, this.libraryRepository.findById(book.getLibraryId()).getAnalyzeDimensions());
        try {
            Collection collection;
            BookPage it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            if (convertedMedia.getStatus() != Media.Status.READY) {
                throw new BookConversionException("Converted file could not be analyzed, aborting conversion");
            }
            if (!Intrinsics.areEqual((Object)convertedMedia.getMediaType(), (Object)MediaType.ZIP.getType())) {
                throw new BookConversionException("Converted file is not a zip file, aborting conversion");
            }
            zipStream = convertedMedia.getPages();
            boolean $i$f$map = false;
            $this$forEach$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                BookPage bl5 = (BookPage)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl6 = false;
                collection2.add(TuplesKt.to((Object)FilenameUtils.getName((String)it.getFileName()), (Object)it.getMediaType()));
            }
            $this$map$iv = media.getPages();
            collection2 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (BookPage)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                collection.add(TuplesKt.to((Object)FilenameUtils.getName((String)it.getFileName()), (Object)it.getMediaType()));
            }
            if (!collection2.containsAll((List)destination$iv$iv)) {
                throw new BookConversionException("Converted file does not contain all pages from existing file, aborting conversion");
            }
            $this$map$iv = convertedMedia.getFiles();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (MediaFile)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl8 = false;
                collection2.add(FilenameUtils.getName((String)it.getFileName()));
            }
            $this$map$iv = media.getFiles();
            collection2 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (MediaFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                collection.add(FilenameUtils.getName((String)it.getFileName()));
            }
            if (!collection2.containsAll((List)destination$iv$iv)) {
                throw new BookConversionException("Converted file does not contain all files from existing file, aborting conversion");
            }
        }
        catch (BookConversionException e) {
            Files.deleteIfExists(destinationPath);
            ((Collection)this.failedConversions).add(book.getId());
            throw e;
        }
        if (Files.deleteIfExists(book.getPath())) {
            BookConverterKt.access$getLogger$p().info(() -> BookConverter.convertToCbz$lambda$17(book));
            this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.BookFileDeleted(book, "File was deleted after conversion to CBZ"));
        }
        Media mediaWithHashes = Media.copy$default((Media)convertedMedia, null, null, (List)BookPageKt.restoreHashFrom((Collection)convertedMedia.getPages(), (Collection)media.getPages()), (int)0, null, null, null, null, (boolean)false, (boolean)false, null, null, (int)4091, null);
        this.transactionTemplate.executeWithoutResult(arg_0 -> BookConverter.convertToCbz$lambda$18(this, (Book)convertedBook, mediaWithHashes, arg_0));
        this.historicalEventRepository.insert((HistoricalEvent)new HistoricalEvent.BookConverted((Book)convertedBook, book));
        this.eventPublisher.publishEvent((Object)new DomainEvent.BookUpdated((Book)convertedBook));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Book> getMismatchedExtensionBooks(@NotNull Library library) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Map $this$flatMap$iv = this.mediaTypeToExtension;
        boolean $i$f$flatMap = false;
        Map map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String mediaType = (String)entry.getKey();
            String extension = (String)entry.getValue();
            Iterable list$iv$iv = this.bookRepository.findAllByLibraryIdAndMismatchedExtension(library.getId(), mediaType, extension);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void repairExtension(@NotNull Book book) {
        Book book2;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        if (!this.libraryRepository.findById(book.getLibraryId()).getRepairExtensions()) {
            BookConverterKt.access$getLogger$p().info(BookConverter::repairExtension$lambda$20);
            return;
        }
        if (this.skippedRepairs.contains(book.getId())) {
            BookConverterKt.access$getLogger$p().info(BookConverter::repairExtension$lambda$21);
            return;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(book.getPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new FileNotFoundException("File not found: " + book.getPath());
        }
        Media media = this.mediaRepository.findById(book.getId());
        if (!CollectionsKt.contains((Iterable)this.mediaTypeToExtension.keySet(), (Object)media.getMediaType())) {
            throw new MediaUnsupportedException(media.getMediaType() + " cannot be repaired. Must be one of " + this.mediaTypeToExtension.keySet(), null, 2, null);
        }
        String string = PathsKt.getExtension((Path)book.getPath()).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string, (Object)"epub") && Intrinsics.areEqual((Object)media.getMediaType(), (Object)MediaType.ZIP.getType())) {
            ((Collection)this.skippedRepairs).add(book.getId());
            BookConverterKt.access$getLogger$p().info(() -> BookConverter.repairExtension$lambda$22(book));
            return;
        }
        String actualExtension = PathsKt.getExtension((Path)book.getPath());
        String correctExtension = (String)this.mediaTypeToExtension.get(media.getMediaType());
        if (Intrinsics.areEqual((Object)correctExtension, (Object)actualExtension)) {
            BookConverterKt.access$getLogger$p().info(() -> BookConverter.repairExtension$lambda$23(media, actualExtension));
            ((Collection)this.skippedRepairs).add(book.getId());
        }
        String destinationFilename = PathsKt.getNameWithoutExtension((Path)book.getPath()) + "." + correctExtension;
        Path destinationPath = book.getPath().getParent().resolve(destinationFilename);
        Intrinsics.checkNotNull((Object)destinationPath);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.exists(destinationPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            throw new FileAlreadyExistsException("Destination file already exists: " + destinationPath);
        }
        BookConverterKt.access$getLogger$p().info(() -> BookConverter.repairExtension$lambda$24(book, destinationPath));
        Path path = book.getPath();
        Path path2 = destinationPath;
        CopyOption[] copyOptionArray = new CopyOption[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
        path2 = this.fileSystemScanner.scanFile(destinationPath);
        if (path2 == null || (book2 = Book.copy$default((Book)path2, null, null, null, (long)0L, null, null, (int)0, (String)book.getId(), (String)book.getSeriesId(), (String)book.getLibraryId(), null, (boolean)false, null, null, (int)15487, null)) == null) {
            throw new IllegalStateException("Repaired book could not be scanned: " + destinationFilename);
        }
        Book repairedBook = book2;
        this.bookRepository.update(repairedBook);
    }

    private static final Object getConvertibleBooks$lambda$2$lambda$1(Collection $it) {
        return "Found " + $it.size() + " books to convert";
    }

    private static final Object getConvertibleBooks$lambda$3() {
        return "CBZ conversion is not enabled, skipping";
    }

    private static final Object convertToCbz$lambda$4() {
        return "Book conversion is disabled for the library, it may have changed since the task was submitted, skipping";
    }

    private static final Object convertToCbz$lambda$5() {
        return "Book conversion already failed before, skipping";
    }

    private static final Object convertToCbz$lambda$7$lambda$6() {
        return "Book has changed on disk, skipping";
    }

    private static final Object convertToCbz$lambda$8(Path $destinationPath) {
        return "Copying archive content to " + $destinationPath;
    }

    private static final Object convertToCbz$lambda$17(Book $book) {
        return "Deleted old file: " + $book.getPath();
    }

    private static final void convertToCbz$lambda$18(BookConverter this$0, Book $convertedBook, Media $mediaWithHashes, TransactionStatus it) {
        this$0.bookRepository.update($convertedBook);
        this$0.mediaRepository.update($mediaWithHashes);
    }

    private static final Object repairExtension$lambda$20() {
        return "Repair extensions is disabled for the library, it may have changed since the task was submitted, skipping";
    }

    private static final Object repairExtension$lambda$21() {
        return "Extension repair has already been skipped before, skipping";
    }

    private static final Object repairExtension$lambda$22(Book $book) {
        return "EPUB file detected as zip should not be repaired, skipping: " + $book.getPath();
    }

    private static final Object repairExtension$lambda$23(Media $media, String $actualExtension) {
        return "MediaType (" + $media.getMediaType() + ") and extension (" + $actualExtension + ") already match, skipping";
    }

    private static final Object repairExtension$lambda$24(Book $book, Path $destinationPath) {
        return "Renaming " + $book.getPath() + " to " + $destinationPath;
    }
}

