/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.coobird.thumbnailator.Thumbnails;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.image.ImageConverterKt;
import org.gotson.komga.infrastructure.image.ImageType;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0012J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\nH\u0016J \u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J*\u0010*\u001a\f\u0012\u0006\b\u0001\u0012\u00020,\u0018\u00010+2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0012J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020)H\u0012J\u0010\u0010/\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020)H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR)\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\rR)\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000f\u001a\u0004\b\u0014\u0010\rR)\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/gotson/komga/infrastructure/image/ImageConverter;", "", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "<init>", "(Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;)V", "supportedReadFormats", "", "", "kotlin.jvm.PlatformType", "getSupportedReadFormats", "()Ljava/util/List;", "supportedReadFormats$delegate", "Lkotlin/Lazy;", "supportedReadMediaTypes", "getSupportedReadMediaTypes", "supportedReadMediaTypes$delegate", "supportedWriteFormats", "getSupportedWriteFormats", "supportedWriteFormats$delegate", "supportedWriteMediaTypes", "getSupportedWriteMediaTypes", "supportedWriteMediaTypes$delegate", "chooseWebpReader", "", "supportsTransparency", "canConvertMediaType", "", "from", "to", "convertImage", "", "imageBytes", "format", "resizeImageToByteArray", "Lorg/gotson/komga/infrastructure/image/ImageType;", "size", "", "resizeImageToBufferedImage", "Ljava/awt/image/BufferedImage;", "resizeImageBuilder", "Lnet/coobird/thumbnailator/Thumbnails$Builder;", "Ljava/io/InputStream;", "containsAlphaChannel", "image", "containsTransparency", "komga"})
@SourceDebugExtension(value={"SMAP\nImageConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageConverter.kt\norg/gotson/komga/infrastructure/image/ImageConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n295#2,2:153\n1869#2,2:155\n1563#2:157\n1634#2,3:158\n*S KotlinDebug\n*F\n+ 1 ImageConverter.kt\norg/gotson/komga/infrastructure/image/ImageConverter\n*L\n52#1:153,2\n53#1:155,2\n51#1:157\n51#1:158,3\n*E\n"})
public class ImageConverter {
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final Lazy supportedReadFormats$delegate;
    @NotNull
    private final Lazy supportedReadMediaTypes$delegate;
    @NotNull
    private final Lazy supportedWriteFormats$delegate;
    @NotNull
    private final Lazy supportedWriteMediaTypes$delegate;
    @NotNull
    private final List<String> supportsTransparency;

    public ImageConverter(@NotNull ImageAnalyzer imageAnalyzer, @NotNull ContentDetector contentDetector) {
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        this.imageAnalyzer = imageAnalyzer;
        this.contentDetector = contentDetector;
        this.supportedReadFormats$delegate = LazyKt.lazy(ImageConverter::supportedReadFormats_delegate$lambda$0);
        this.supportedReadMediaTypes$delegate = LazyKt.lazy(ImageConverter::supportedReadMediaTypes_delegate$lambda$1);
        this.supportedWriteFormats$delegate = LazyKt.lazy(ImageConverter::supportedWriteFormats_delegate$lambda$2);
        this.supportedWriteMediaTypes$delegate = LazyKt.lazy(ImageConverter::supportedWriteMediaTypes_delegate$lambda$3);
        this.chooseWebpReader();
        ImageConverterKt.access$getLogger$p().info(() -> ImageConverter._init_$lambda$4(this));
        ImageConverterKt.access$getLogger$p().info(() -> ImageConverter._init_$lambda$5(this));
        ImageConverterKt.access$getLogger$p().info(() -> ImageConverter._init_$lambda$6(this));
        ImageConverterKt.access$getLogger$p().info(() -> ImageConverter._init_$lambda$7(this));
        this.supportsTransparency = CollectionsKt.listOf((Object)"png");
    }

    @NotNull
    public List<String> getSupportedReadFormats() {
        Lazy lazy = this.supportedReadFormats$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public List<String> getSupportedReadMediaTypes() {
        Lazy lazy = this.supportedReadMediaTypes$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public List<String> getSupportedWriteFormats() {
        Lazy lazy = this.supportedWriteFormats$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public List<String> getSupportedWriteMediaTypes() {
        Lazy lazy = this.supportedWriteMediaTypes$delegate;
        return (List)lazy.getValue();
    }

    private void chooseWebpReader() {
        block4: {
            Object v1;
            List providers;
            block3: {
                Iterator<ImageReaderSpi> iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, ImageConverter::chooseWebpReader$lambda$8, false);
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"getServiceProviders(...)");
                providers = SequencesKt.toList((Sequence)SequencesKt.asSequence(iterator));
                if (providers.size() <= 1) break block4;
                ImageConverterKt.access$getLogger$p().debug(() -> ImageConverter.chooseWebpReader$lambda$10(providers));
                Iterable $this$firstOrNull$iv = providers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ImageReaderSpi it = (ImageReaderSpi)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getClass().getCanonicalName(), (Object)"com.github.gotson.nightmonkeys.webp.imageio.plugins.WebpImageReaderSpi")) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            ImageReaderSpi imageReaderSpi = v1;
            if (imageReaderSpi != null) {
                ImageReaderSpi nightMonkeys = imageReaderSpi;
                boolean bl = false;
                Iterable $this$forEach$iv = CollectionsKt.minus((Iterable)providers, (Object)nightMonkeys);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ImageReaderSpi it = (ImageReaderSpi)element$iv;
                    boolean bl2 = false;
                    ImageConverterKt.access$getLogger$p().debug(() -> ImageConverter.chooseWebpReader$lambda$14$lambda$13$lambda$12(it));
                    IIORegistry.getDefaultInstance().deregisterServiceProvider(it);
                }
            }
        }
    }

    public boolean canConvertMediaType(@NotNull String from, @NotNull String to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.getSupportedReadMediaTypes().contains(from) && this.getSupportedWriteMediaTypes().contains(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public byte[] convertImage(@NotNull byte[] imageBytes, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        var3_3 = new ByteArrayOutputStream();
        var4_4 = null;
        try {
            baos = (ByteArrayOutputStream)var3_3;
            $i$a$-use-ImageConverter$convertImage$1 = false;
            image = ImageIO.read(new ByteArrayInputStream(imageBytes));
            if (this.supportsTransparency.contains(format)) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)image);
            if (this.containsAlphaChannel(image)) {
                if (this.containsTransparency(image)) {
                    ImageConverterKt.access$getLogger$p().info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, convertImage$lambda$18$lambda$15(), ()Ljava/lang/Object;)());
                } else {
                    ImageConverterKt.access$getLogger$p().info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, convertImage$lambda$18$lambda$16(), ()Ljava/lang/Object;)());
                }
                it = var8_10 = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                $i$a$-also-ImageConverter$convertImage$1$result$3 = false;
                it.createGraphics().drawImage(image, 0, 0, Color.WHITE, null);
                v0 = var8_10;
            } else lbl-1000:
            // 2 sources

            {
                v0 = image;
            }
            result = v0;
            ImageIO.write((RenderedImage)result, format, baos);
            var5_5 = baos.toByteArray();
        }
        catch (Throwable var6_7) {
            var4_4 = var6_7;
            throw var6_7;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var3_3, (Throwable)var4_4);
        }
        Intrinsics.checkNotNullExpressionValue((Object)var5_5, (String)"use(...)");
        return var5_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] resizeImageToByteArray(@NotNull byte[] imageBytes, @NotNull ImageType format, int size) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Thumbnails.Builder builder = this.resizeImageBuilder(imageBytes, format, size);
        if (builder == null) {
            return imageBytes;
        }
        Thumbnails.Builder builder2 = builder;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            builder2.toOutputStream((OutputStream)it);
            byArray = it.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    @NotNull
    public BufferedImage resizeImageToBufferedImage(@NotNull byte[] imageBytes, @NotNull ImageType format, int size) {
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Thumbnails.Builder builder = this.resizeImageBuilder(imageBytes, format, size);
        if (builder == null) {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
            return bufferedImage;
        }
        Thumbnails.Builder builder2 = builder;
        BufferedImage bufferedImage = builder2.asBufferedImage();
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"asBufferedImage(...)");
        return bufferedImage;
    }

    private Thumbnails.Builder<? extends InputStream> resizeImageBuilder(byte[] imageBytes, ImageType format, int size) {
        Integer longestEdge;
        Integer n;
        Dimension dimension = this.imageAnalyzer.getDimension((InputStream)new ByteArrayInputStream(imageBytes));
        if (dimension != null) {
            Dimension it = dimension;
            boolean bl = false;
            String mediaType = this.contentDetector.detectMediaType((InputStream)new ByteArrayInputStream(imageBytes));
            int longestEdge2 = Math.max(it.getHeight(), it.getWidth());
            if (Intrinsics.areEqual((Object)mediaType, (Object)format.getMediaType()) && longestEdge2 <= size) {
                return null;
            }
            n = longestEdge2;
        } else {
            n = null;
        }
        Integer n2 = longestEdge = n;
        int resizeTo = n2 != null ? Math.min(n2, size) : size;
        InputStream[] inputStreamArray = new InputStream[]{new ByteArrayInputStream(imageBytes)};
        return Thumbnails.of((InputStream[])inputStreamArray).size(resizeTo, resizeTo).imageType(2).outputFormat(format.getImageIOFormat());
    }

    private boolean containsAlphaChannel(BufferedImage image) {
        return image.getColorModel().hasAlpha();
    }

    private boolean containsTransparency(BufferedImage image) {
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = image.getHeight();
            for (int y = 0; y < n2; ++y) {
                int pixel = image.getRGB(x, y);
                if (pixel >> 24 != 0) continue;
                return true;
            }
        }
        return false;
    }

    private static final List supportedReadFormats_delegate$lambda$0() {
        String[] stringArray = ImageIO.getReaderFormatNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getReaderFormatNames(...)");
        return ArraysKt.toList((Object[])stringArray);
    }

    private static final List supportedReadMediaTypes_delegate$lambda$1() {
        String[] stringArray = ImageIO.getReaderMIMETypes();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getReaderMIMETypes(...)");
        return ArraysKt.toList((Object[])stringArray);
    }

    private static final List supportedWriteFormats_delegate$lambda$2() {
        String[] stringArray = ImageIO.getWriterFormatNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getWriterFormatNames(...)");
        return ArraysKt.toList((Object[])stringArray);
    }

    private static final List supportedWriteMediaTypes_delegate$lambda$3() {
        String[] stringArray = ImageIO.getWriterMIMETypes();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getWriterMIMETypes(...)");
        return ArraysKt.toList((Object[])stringArray);
    }

    private static final Object _init_$lambda$4(ImageConverter this$0) {
        return "Supported read formats: " + this$0.getSupportedReadFormats();
    }

    private static final Object _init_$lambda$5(ImageConverter this$0) {
        return "Supported read mediaTypes: " + this$0.getSupportedReadMediaTypes();
    }

    private static final Object _init_$lambda$6(ImageConverter this$0) {
        return "Supported write formats: " + this$0.getSupportedWriteFormats();
    }

    private static final Object _init_$lambda$7(ImageConverter this$0) {
        return "Supported write mediaTypes: " + this$0.getSupportedWriteMediaTypes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean chooseWebpReader$lambda$8(Object it) {
        if (!(it instanceof ImageReaderSpi)) return false;
        String[] stringArray = ((ImageReaderSpi)it).getMIMETypes();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getMIMETypes(...)");
        if (!ArraysKt.contains((Object[])stringArray, (Object)"image/webp")) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object chooseWebpReader$lambda$10(List $providers) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $providers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ImageReaderSpi imageReaderSpi = (ImageReaderSpi)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getClass().getCanonicalName());
        }
        return "WebP reader providers: " + (List)destination$iv$iv;
    }

    private static final Object chooseWebpReader$lambda$14$lambda$13$lambda$12(ImageReaderSpi $it) {
        return "Deregister provider: " + $it.getClass().getCanonicalName();
    }

    private static final Object convertImage$lambda$18$lambda$15() {
        return "Image contains alpha channel but is not opaque, visual artifacts may appear";
    }

    private static final Object convertImage$lambda$18$lambda$16() {
        return "Image contains alpha channel but is opaque, conversion should not generate any visual artifacts";
    }
}

