/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.kobo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.gotson.komga.domain.model.KomgaSyncToken;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.kobo.KoboProxy$proxyCurrentRequest$;
import org.gotson.komga.infrastructure.kobo.KoboProxyKt;
import org.gotson.komga.infrastructure.kobo.KomgaSyncTokenGenerator;
import org.gotson.komga.infrastructure.web.UtilsKt;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.ReactorClientHttpRequestFactoryBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0012J\b\u0010\u0015\u001a\u00020\u0013H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u001a\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001e\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lorg/gotson/komga/infrastructure/kobo/KoboProxy;", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "komgaSyncTokenGenerator", "Lorg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator;", "komgaSettingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "<init>", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/gotson/komga/infrastructure/kobo/KomgaSyncTokenGenerator;Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;)V", "koboApiClient", "Lorg/springframework/web/client/RestClient;", "pathRegex", "Lkotlin/text/Regex;", "headersOutInclude", "", "", "headersOutExclude", "isKoboHeader", "", "headerName", "isEnabled", "proxyCurrentRequest", "Lorg/springframework/http/ResponseEntity;", "Lcom/fasterxml/jackson/databind/JsonNode;", "body", "includeSyncToken", "imageHostUrl", "getImageHostUrl", "()Ljava/lang/String;", "nativeKoboResources", "getNativeKoboResources", "()Lcom/fasterxml/jackson/databind/JsonNode;", "nativeKoboResources$delegate", "Lkotlin/Lazy;", "komga"})
@SourceDebugExtension(value={"SMAP\nKoboProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoboProxy.kt\norg/gotson/komga/infrastructure/kobo/KoboProxy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n1#2:344\n63#3:345\n488#4,7:346\n827#5:353\n855#5,2:354\n774#5:356\n865#5,2:357\n1869#5,2:359\n*S KotlinDebug\n*F\n+ 1 KoboProxy.kt\norg/gotson/komga/infrastructure/kobo/KoboProxy\n*L\n121#1:345\n127#1:346,7\n103#1:353\n103#1:354,2\n104#1:356\n104#1:357,2\n105#1:359,2\n*E\n"})
public class KoboProxy {
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final KomgaSyncTokenGenerator komgaSyncTokenGenerator;
    @NotNull
    private final KomgaSettingsProvider komgaSettingsProvider;
    @NotNull
    private final RestClient koboApiClient;
    @NotNull
    private final Regex pathRegex;
    @NotNull
    private final Set<String> headersOutInclude;
    @NotNull
    private final Set<String> headersOutExclude;
    @NotNull
    private final String imageHostUrl;
    @NotNull
    private final Lazy nativeKoboResources$delegate;

    /*
     * WARNING - void declaration
     */
    public KoboProxy(@NotNull ObjectMapper objectMapper, @NotNull KomgaSyncTokenGenerator komgaSyncTokenGenerator, @NotNull KomgaSettingsProvider komgaSettingsProvider) {
        void $this$koboApiClient_u24lambda_u240;
        DefaultUriBuilderFactory defaultUriBuilderFactory;
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)komgaSyncTokenGenerator, (String)"komgaSyncTokenGenerator");
        Intrinsics.checkNotNullParameter((Object)komgaSettingsProvider, (String)"komgaSettingsProvider");
        this.objectMapper = objectMapper;
        this.komgaSyncTokenGenerator = komgaSyncTokenGenerator;
        this.komgaSettingsProvider = komgaSettingsProvider;
        DefaultUriBuilderFactory defaultUriBuilderFactory2 = defaultUriBuilderFactory = new DefaultUriBuilderFactory("https://storeapi.kobo.com");
        RestClient.Builder builder = RestClient.builder();
        KoboProxy koboProxy = this;
        boolean bl = false;
        $this$koboApiClient_u24lambda_u240.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.NONE);
        Unit unit = Unit.INSTANCE;
        RestClient.Builder builder2 = builder.uriBuilderFactory((UriBuilderFactory)defaultUriBuilderFactory);
        ReactorClientHttpRequestFactoryBuilder reactorClientHttpRequestFactoryBuilder = ClientHttpRequestFactoryBuilder.reactor();
        ClientHttpRequestFactorySettings clientHttpRequestFactorySettings = ClientHttpRequestFactorySettings.defaults();
        long l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        ClientHttpRequestFactorySettings clientHttpRequestFactorySettings2 = clientHttpRequestFactorySettings.withReadTimeout(duration);
        l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
        n = Duration.getNanosecondsComponent-impl((long)l);
        l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration2 = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"toComponents-impl(...)");
        RestClient restClient = builder2.requestFactory(reactorClientHttpRequestFactoryBuilder.build(clientHttpRequestFactorySettings2.withConnectTimeout(duration2))).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        koboProxy.koboApiClient = restClient;
        this.pathRegex = new Regex("/kobo/[-\\w]*(.*)");
        Object[] objectArray = new String[]{"Authorization", "User-Agent", "Accept", "Accept-Language", "Content-Type"};
        this.headersOutInclude = SetsKt.setOf((Object[])objectArray);
        this.headersOutExclude = SetsKt.setOf((Object)"x-kobo-synctoken");
        this.imageHostUrl = "https://cdn.kobo.com/book-images/{ImageId}/{Width}/{Height}/false/image.jpg";
        this.nativeKoboResources$delegate = LazyKt.lazy(() -> KoboProxy.nativeKoboResources_delegate$lambda$16(this));
    }

    private boolean isKoboHeader(String headerName) {
        return StringsKt.startsWith((String)headerName, (String)"x-kobo-", (boolean)true);
    }

    public boolean isEnabled() {
        return this.komgaSettingsProvider.getKoboProxy();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ResponseEntity<JsonNode> proxyCurrentRequest(@Nullable Object body, boolean includeSyncToken) {
        Map map;
        void $this$filterKeys$iv;
        void $this$toEntity$iv;
        if (!this.komgaSettingsProvider.getKoboProxy()) {
            throw new IllegalStateException("kobo proxying is disabled");
        }
        HttpServletRequest request = UtilsKt.getCurrentRequest();
        String string = request.getRequestURI();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
        MatchResult matchResult = Regex.find$default((Regex)this.pathRegex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
            throw new IllegalStateException("Could not get path from current request");
        }
        String path = (String)matchResult.getMatch().getGroupValues().get(1);
        KomgaSyncToken syncToken = includeSyncToken ? this.komgaSyncTokenGenerator.fromRequestHeaders(request) : null;
        RestClient.RequestHeadersSpec requestHeadersSpec = ((RestClient.RequestBodySpec)this.koboApiClient.method(HttpMethod.valueOf((String)request.getMethod())).uri(arg_0 -> KoboProxy.proxyCurrentRequest$lambda$3(path, request, arg_0))).headers(arg_0 -> KoboProxy.proxyCurrentRequest$lambda$8(request, includeSyncToken, syncToken, this, arg_0));
        RestClient.RequestBodySpec $this$proxyCurrentRequest_u24lambda_u249 = (RestClient.RequestBodySpec)requestHeadersSpec;
        boolean bl = false;
        if (body != null) {
            $this$proxyCurrentRequest_u24lambda_u249.body(body);
        }
        RestClient.ResponseSpec responseSpec = ((RestClient.RequestBodySpec)requestHeadersSpec).retrieve().onStatus(HttpStatusCode::isError, KoboProxy::proxyCurrentRequest$lambda$12);
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"onStatus(...)");
        RestClient.ResponseSpec responseSpec2 = responseSpec;
        boolean $i$f$toEntity22 = false;
        ResponseEntity responseEntity = $this$toEntity$iv.toEntity((ParameterizedTypeReference)new proxyCurrentRequest$$inlined$toEntity$1());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"toEntity");
        ResponseEntity response2 = responseEntity;
        KoboProxyKt.access$getLogger$p().debug(() -> KoboProxy.proxyCurrentRequest$lambda$13(response2));
        HttpHeaders httpHeaders = response2.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"getHeaders(...)");
        Map $i$f$toEntity22 = (Map)httpHeaders;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this.isKoboHeader(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$proxyCurrentRequest_u24lambda_u2415 = map = MapsKt.toMutableMap((Map)result$iv);
        boolean bl3 = false;
        if (LanguageUtilsKt.contains((Iterable)$this$proxyCurrentRequest_u24lambda_u2415.keySet(), (String)"x-kobo-synctoken", (boolean)true)) {
            String koboSyncToken;
            List list = (List)$this$proxyCurrentRequest_u24lambda_u2415.get("x-kobo-synctoken");
            String string2 = koboSyncToken = list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
            if (koboSyncToken != null && includeSyncToken && syncToken != null) {
                KomgaSyncToken komgaSyncToken = KomgaSyncToken.copy$default((KomgaSyncToken)syncToken, (int)0, (String)koboSyncToken, null, null, (int)13, null);
                $this$proxyCurrentRequest_u24lambda_u2415.put("x-kobo-synctoken", CollectionsKt.listOf((Object)this.komgaSyncTokenGenerator.toBase64(komgaSyncToken)));
            }
        }
        Map headersToReturn = map;
        return new ResponseEntity(response2.getBody(), (MultiValueMap)new LinkedMultiValueMap(headersToReturn), response2.getStatusCode());
    }

    public static /* synthetic */ ResponseEntity proxyCurrentRequest$default(KoboProxy koboProxy, Object object, boolean bl, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: proxyCurrentRequest");
        }
        if ((n & 1) != 0) {
            object = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return koboProxy.proxyCurrentRequest(object, bl);
    }

    @NotNull
    public String getImageHostUrl() {
        return this.imageHostUrl;
    }

    @NotNull
    public JsonNode getNativeKoboResources() {
        Lazy lazy = this.nativeKoboResources$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (JsonNode)object;
    }

    private static final Object proxyCurrentRequest$lambda$3$lambda$2$lambda$1(URI $it) {
        return "Proxy URL: " + $it;
    }

    private static final URI proxyCurrentRequest$lambda$3(String $path, HttpServletRequest $request, UriBuilder uriBuilder) {
        URI uRI;
        URI it = uRI = uriBuilder.path($path).query($request.getQueryString()).build(new Object[0]);
        boolean bl = false;
        KoboProxyKt.access$getLogger$p().debug(() -> KoboProxy.proxyCurrentRequest$lambda$3$lambda$2$lambda$1(it));
        return uRI;
    }

    private static final Object proxyCurrentRequest$lambda$8$lambda$7(HttpHeaders $headersOut) {
        return "Headers out: " + $headersOut;
    }

    /*
     * WARNING - void declaration
     */
    private static final void proxyCurrentRequest$lambda$8(HttpServletRequest $request, boolean $includeSyncToken, KomgaSyncToken $syncToken, KoboProxy this$0, HttpHeaders headersOut) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Enumeration enumeration = $request.getHeaderNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getHeaderNames(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable iterable = arrayList;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = this$0.headersOutExclude;
            Intrinsics.checkNotNull((Object)it);
            if (LanguageUtilsKt.contains((Iterable)iterable2, (String)it, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable iterable3 = this$0.headersOutInclude;
            Intrinsics.checkNotNull((Object)it);
            if (!(LanguageUtilsKt.contains((Iterable)iterable3, (String)it, (boolean)true) || this$0.isKoboHeader(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            String it2;
            block10: {
                block9: {
                    it2 = (String)element$iv;
                    boolean bl = false;
                    object = $request.getHeaders(it2);
                    if (object == null) break block9;
                    ArrayList arrayList2 = Collections.list(object);
                    Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"list(...)");
                    object = arrayList2;
                    if (object != null) break block10;
                }
                object = CollectionsKt.emptyList();
            }
            headersOut.addAll(it2, (List)object);
        }
        if ($includeSyncToken) {
            if ($syncToken != null && !StringsKt.isBlank((CharSequence)$syncToken.getRawKoboSyncToken())) {
                headersOut.add("x-kobo-synctoken", $syncToken.getRawKoboSyncToken());
            } else {
                throw new IllegalStateException("request must include sync token, but no raw Kobo sync token found");
            }
        }
        KoboProxyKt.access$getLogger$p().debug(() -> KoboProxy.proxyCurrentRequest$lambda$8$lambda$7(headersOut));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object proxyCurrentRequest$lambda$12$lambda$11(ClientHttpResponse $response) {
        HttpStatusCode httpStatusCode = $response.getStatusCode();
        InputStream inputStream = $response.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getBody(...)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        HttpStatusCode httpStatusCode2 = httpStatusCode;
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return "Kobo response: " + httpStatusCode2 + ": " + object2;
    }

    private static final void proxyCurrentRequest$lambda$12(HttpRequest httpRequest, ClientHttpResponse response2) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        KoboProxyKt.access$getLogger$p().debug(() -> KoboProxy.proxyCurrentRequest$lambda$12$lambda$11(response2));
        throw new ResponseStatusException(response2.getStatusCode(), response2.getStatusText());
    }

    private static final Object proxyCurrentRequest$lambda$13(ResponseEntity $response) {
        return "Kobo response: " + $response;
    }

    private static final JsonNode nativeKoboResources_delegate$lambda$16(KoboProxy this$0) {
        return this$0.objectMapper.readTree("{\n  \"account_page\": \"https://www.kobo.com/account/settings\",\n  \"account_page_rakuten\": \"https://my.rakuten.co.jp/\",\n  \"add_device\": \"https://storeapi.kobo.com/v1/user/add-device\",\n  \"add_entitlement\": \"https://storeapi.kobo.com/v1/library/{RevisionIds}\",\n  \"affiliaterequest\": \"https://storeapi.kobo.com/v1/affiliate\",\n  \"assets\": \"https://storeapi.kobo.com/v1/assets\",\n  \"audiobook\": \"https://storeapi.kobo.com/v1/products/audiobooks/{ProductId}\",\n  \"audiobook_detail_page\": \"https://www.kobo.com/{region}/{language}/audiobook/{slug}\",\n  \"audiobook_get_credits\": \"https://www.kobo.com/{region}/{language}/audiobooks/plans\",\n  \"audiobook_landing_page\": \"https://www.kobo.com/{region}/{language}/audiobooks\",\n  \"audiobook_preview\": \"https://storeapi.kobo.com/v1/products/audiobooks/{Id}/preview\",\n  \"audiobook_purchase_withcredit\": \"https://storeapi.kobo.com/v1/store/audiobook/{Id}\",\n  \"audiobook_subscription_management\": \"https://www.kobo.com/{region}/{language}/account/subscriptions\",\n  \"audiobook_subscription_orange_deal_inclusion_url\": \"https://authorize.kobo.com/inclusion\",\n  \"audiobook_subscription_purchase\": \"https://www.kobo.com/{region}/{language}/checkoutoption/21C6D938-934B-4A91-B979-E14D70B2F280\",\n  \"audiobook_subscription_tiers\": \"https://www.kobo.com/{region}/{language}/checkoutoption/21C6D938-934B-4A91-B979-E14D70B2F280\",\n  \"authorproduct_recommendations\": \"https://storeapi.kobo.com/v1/products/books/authors/recommendations\",\n  \"autocomplete\": \"https://storeapi.kobo.com/v1/products/autocomplete\",\n  \"bam\": \"https://storeapi.kobo.com/v2/activity/bam/success\",\n  \"blackstone_header\": {\n    \"key\": \"x-amz-request-payer\",\n    \"value\": \"requester\"\n  },\n  \"book\": \"https://storeapi.kobo.com/v1/products/books/{ProductId}\",\n  \"book_detail_page\": \"https://www.kobo.com/{region}/{language}/ebook/{slug}\",\n  \"book_detail_page_rakuten\": \"http://books.rakuten.co.jp/rk/{crossrevisionid}\",\n  \"book_landing_page\": \"https://www.kobo.com/ebooks\",\n  \"book_subscription\": \"https://storeapi.kobo.com/v1/products/books/subscriptions\",\n  \"browse_history\": \"https://storeapi.kobo.com/v1/user/browsehistory\",\n  \"categories\": \"https://storeapi.kobo.com/v1/categories\",\n  \"categories_page\": \"https://www.kobo.com/ebooks/categories\",\n  \"categoriesv2\": \"https://storeapi.kobo.com/api/v2/Categories/Top\",\n  \"category\": \"https://storeapi.kobo.com/v1/categories/{CategoryId}\",\n  \"category_featured_lists\": \"https://storeapi.kobo.com/v1/categories/{CategoryId}/featured\",\n  \"category_products\": \"https://storeapi.kobo.com/v1/categories/{CategoryId}/products\",\n  \"checkout_borrowed_book\": \"https://storeapi.kobo.com/v1/library/borrow\",\n  \"client_authd_referral\": \"https://authorize.kobo.com/api/AuthenticatedReferral/client/v1/getLink\",\n  \"configuration_data\": \"https://storeapi.kobo.com/v1/configuration\",\n  \"content_access_book\": \"https://storeapi.kobo.com/v1/products/books/{ProductId}/access\",\n  \"contributorsv2\": \"https://storeapi.kobo.com/v2/contributors/author\",\n  \"customer_care_live_chat\": \"https://v2.zopim.com/widget/livechat.html?key=Y6gwUmnu4OATxN3Tli4Av9bYN319BTdO\",\n  \"daily_deal\": \"https://storeapi.kobo.com/v1/products/dailydeal\",\n  \"deals\": \"https://storeapi.kobo.com/v1/deals\",\n  \"delete_entitlement\": \"https://storeapi.kobo.com/v1/library/{Ids}\",\n  \"delete_tag\": \"https://storeapi.kobo.com/v1/library/tags/{TagId}\",\n  \"delete_tag_items\": \"https://storeapi.kobo.com/v1/library/tags/{TagId}/items/delete\",\n  \"device_auth\": \"https://storeapi.kobo.com/v1/auth/device\",\n  \"device_refresh\": \"https://storeapi.kobo.com/v1/auth/refresh\",\n  \"dictionary_host\": \"https://ereaderfiles.kobo.com\",\n  \"discovery_host\": \"https://discovery.kobobooks.com\",\n  \"display_accessibility_enabled\": \"False\",\n  \"display_parental_controls_enabled\": \"True\",\n  \"dropbox_link_account_poll\": \"https://authorize.kobo.com/{region}/{language}/LinkDropbox\",\n  \"dropbox_link_account_start\": \"https://authorize.kobo.com/LinkDropbox/start\",\n  \"ereaderdevices\": \"https://storeapi.kobo.com/v2/products/EReaderDeviceFeeds\",\n  \"eula_page\": \"https://www.kobo.com/termsofuse?style=onestore\",\n  \"exchange_auth\": \"https://storeapi.kobo.com/v1/auth/exchange\",\n  \"external_book\": \"https://storeapi.kobo.com/v1/products/books/external/{Ids}\",\n  \"facebook_sso_page\": \"https://authorize.kobo.com/signin/provider/Facebook/login?returnUrl=https://kobo.com/\",\n  \"featured_list\": \"https://storeapi.kobo.com/v1/products/featured/{FeaturedListId}\",\n  \"featured_lists\": \"https://storeapi.kobo.com/v1/products/featured\",\n  \"featuredlist2\": \"https://storeapi.kobo.com/v2/products/list/featured\",\n  \"fixed_layout_page_cache_enabled\": \"True\",\n  \"free_books_page\": {\n    \"EN\": \"https://www.kobo.com/{region}/{language}/p/free-ebooks\",\n    \"FR\": \"https://www.kobo.com/{region}/{language}/p/livres-gratuits\",\n    \"IT\": \"https://www.kobo.com/{region}/{language}/p/libri-gratuiti\",\n    \"NL\": \"https://www.kobo.com/{region}/{language}/List/bekijk-het-overzicht-van-gratis-ebooks/QpkkVWnUw8sxmgjSlCbJRg\",\n    \"PT\": \"https://www.kobo.com/{region}/{language}/p/livros-gratis\"\n  },\n  \"fte_feedback\": \"https://storeapi.kobo.com/v1/products/ftefeedback\",\n  \"funnel_metrics\": \"https://storeapi.kobo.com/v1/funnelmetrics\",\n  \"geography_data\": \"https://storeapi.kobo.com/v2/configuration/geography/country\",\n  \"get_download_keys\": \"https://storeapi.kobo.com/v1/library/downloadkeys\",\n  \"get_download_link\": \"https://storeapi.kobo.com/v1/library/downloadlink\",\n  \"get_tests_request\": \"https://storeapi.kobo.com/v1/analytics/gettests\",\n  \"giftcard_epd_redeem_url\": \"https://www.kobo.com/{storefront}/{language}/redeem-ereader\",\n  \"giftcard_redeem_url\": \"https://www.kobo.com/{storefront}/{language}/redeem\",\n  \"googledrive_link_account_start\": \"https://authorize.kobo.com/{region}/{language}/linkcloudstorage/provider/google_drive\",\n  \"gpb_flow_enabled\": \"False\",\n  \"help_page\": \"https://www.kobo.com/help\",\n  \"image_host\": \"//cdn.kobo.com/book-images/\",\n  \"image_url_quality_template\": \"https://cdn.kobo.com/book-images/{ImageId}/{Width}/{Height}/{Quality}/{IsGreyscale}/image.jpg\",\n  \"image_url_template\": \"https://cdn.kobo.com/book-images/{ImageId}/{Width}/{Height}/false/image.jpg\",\n  \"instapaper_enabled\": \"True\",\n  \"instapaper_env_url\": \"https://www.instapaper.com/api/kobo\",\n  \"instapaper_link_account_start\": \"https://authorize.kobo.com/{region}/{language}/linkinstapaper\",\n  \"kobo_audiobooks_credit_redemption\": \"True\",\n  \"kobo_audiobooks_enabled\": \"True\",\n  \"kobo_audiobooks_orange_deal_enabled\": \"True\",\n  \"kobo_audiobooks_subscriptions_enabled\": \"True\",\n  \"kobo_display_price\": \"True\",\n  \"kobo_dropbox_link_account_enabled\": \"True\",\n  \"kobo_google_tax\": \"False\",\n  \"kobo_googledrive_link_account_enabled\": \"True\",\n  \"kobo_nativeborrow_enabled\": \"False\",\n  \"kobo_onedrive_link_account_enabled\": \"False\",\n  \"kobo_onestorelibrary_enabled\": \"False\",\n  \"kobo_privacyCentre_url\": \"https://www.kobo.com/privacy\",\n  \"kobo_redeem_enabled\": \"True\",\n  \"kobo_shelfie_enabled\": \"False\",\n  \"kobo_subscriptions_enabled\": \"True\",\n  \"kobo_superpoints_enabled\": \"False\",\n  \"kobo_wishlist_enabled\": \"True\",\n  \"library_book\": \"https://storeapi.kobo.com/v1/user/library/books/{LibraryItemId}\",\n  \"library_items\": \"https://storeapi.kobo.com/v1/user/library\",\n  \"library_metadata\": \"https://storeapi.kobo.com/v1/library/{Ids}/metadata\",\n  \"library_prices\": \"https://storeapi.kobo.com/v1/user/library/previews/prices\",\n  \"library_search\": \"https://storeapi.kobo.com/v1/library/search\",\n  \"library_sync\": \"https://storeapi.kobo.com/v1/library/sync\",\n  \"love_dashboard_page\": \"https://www.kobo.com/{region}/{language}/kobosuperpoints\",\n  \"love_points_redemption_page\": \"https://www.kobo.com/{region}/{language}/KoboSuperPointsRedemption?productId={ProductId}\",\n  \"magazine_landing_page\": \"https://www.kobo.com/emagazines\",\n  \"more_sign_in_options\": \"https://authorize.kobo.com/signin?returnUrl=https://kobo.com/#allProviders\",\n  \"morebyauthor\": \"https://storeapi.kobo.com/v2/products/recommendations/morebyauthor\",\n  \"notebooks\": \"https://storeapi.kobo.com/api/internal/notebooks\",\n  \"notifications_registration_issue\": \"https://storeapi.kobo.com/v1/notifications/registration\",\n  \"oauth_host\": \"https://oauth.kobo.com\",\n  \"password_retrieval_page\": \"https://www.kobo.com/passwordretrieval.html\",\n  \"personalizedrecommendations\": \"https://storeapi.kobo.com/v2/users/personalizedrecommendations\",\n  \"pocket_link_account_start\": \"https://authorize.kobo.com/{region}/{language}/linkpocket\",\n  \"post_analytics_event\": \"https://storeapi.kobo.com/v1/analytics/event\",\n  \"ppx_purchasing_url\": \"https://purchasing.kobo.com\",\n  \"privacy_page\": \"https://www.kobo.com/privacypolicy?style=onestore\",\n  \"product_nextread\": \"https://storeapi.kobo.com/v1/products/{ProductIds}/nextread\",\n  \"product_prices\": \"https://storeapi.kobo.com/v1/products/{ProductIds}/prices\",\n  \"product_recommendations\": \"https://storeapi.kobo.com/v1/products/{ProductId}/recommendations\",\n  \"product_reviews\": \"https://storeapi.kobo.com/v1/products/{ProductIds}/reviews\",\n  \"productbyid\": \"https://storeapi.kobo.com/v2/products/itemDetailById/{ProductType}/{Id}\",\n  \"productbyslug\": \"https://storeapi.kobo.com/v2/products/itemDetail/{ProductType}/{Slug}\",\n  \"products\": \"https://storeapi.kobo.com/v1/products\",\n  \"productstatebyid\": \"https://storeapi.kobo.com/v2/products/itemStateById/{ProductType}/{Id}\",\n  \"productstatebyslug\": \"https://storeapi.kobo.com/v2/products/itemState/{ProductType}/{Slug}\",\n  \"productsv2\": \"https://storeapi.kobo.com/v2/products\",\n  \"provider_external_sign_in_page\": \"https://authorize.kobo.com/ExternalSignIn/{providerName}?returnUrl=https://kobo.com/\",\n  \"purchase_buy\": \"https://www.kobo.com/checkoutoption/\",\n  \"purchase_buy_templated\": \"https://www.kobo.com/{region}/{language}/checkoutoption/{ProductId}\",\n  \"quickbuy_checkout\": \"https://storeapi.kobo.com/v1/store/quickbuy/{PurchaseId}/checkout\",\n  \"quickbuy_create\": \"https://storeapi.kobo.com/v1/store/quickbuy/purchase\",\n  \"rakuten_token_exchange\": \"https://storeapi.kobo.com/v1/auth/rakuten_token_exchange\",\n  \"rating\": \"https://storeapi.kobo.com/v1/products/{ProductId}/rating/{Rating}\",\n  \"reading_services_host\": \"https://readingservices.kobo.com\",\n  \"reading_state\": \"https://storeapi.kobo.com/v1/library/{Ids}/state\",\n  \"redeem_interstitial_page\": \"https://www.kobo.com\",\n  \"reflowable_page_cache_enabled\": \"True\",\n  \"registration_page\": \"https://authorize.kobo.com/signup?returnUrl=https://kobo.com/\",\n  \"related\": \"https://storeapi.kobo.com/v2/products/recommendations/related\",\n  \"related_items\": \"https://storeapi.kobo.com/v1/products/{Id}/related\",\n  \"remaining_book_series\": \"https://storeapi.kobo.com/v1/products/books/series/{SeriesId}\",\n  \"rename_tag\": \"https://storeapi.kobo.com/v1/library/tags/{TagId}\",\n  \"review\": \"https://storeapi.kobo.com/v1/products/reviews/{ReviewId}\",\n  \"review_sentiment\": \"https://storeapi.kobo.com/v1/products/reviews/{ReviewId}/sentiment/{Sentiment}\",\n  \"shelfie_recommendations\": \"https://storeapi.kobo.com/v1/user/recommendations/shelfie\",\n  \"sign_in_page\": \"https://auth.kobobooks.com/ActivateOnWeb\",\n  \"social_authorization_host\": \"https://social.kobobooks.com:8443\",\n  \"social_host\": \"https://social.kobobooks.com\",\n  \"store_home\": \"www.kobo.com/{region}/{language}\",\n  \"store_host\": \"www.kobo.com\",\n  \"store_newreleases\": \"https://www.kobo.com/{region}/{language}/List/new-releases/961XUjtsU0qxkFItWOutGA\",\n  \"store_search\": \"https://www.kobo.com/{region}/{language}/Search?Query={query}\",\n  \"store_top50\": \"https://www.kobo.com/{region}/{language}/ebooks/Top\",\n  \"subs_landing_page\": \"https://www.kobo.com/{region}/{language}/plus\",\n  \"subs_management_page\": \"https://www.kobo.com/{region}/{language}/account/subscriptions\",\n  \"subs_purchase_buy_templated\": \"https://www.kobo.com/{region}/{language}/Checkoutoption/{ProductId}/{TierId}\",\n  \"subscription_publisher_price_page\": \"https://www.kobo.com/{region}/{language}/subscriptionpublisherprice\",\n  \"tag_items\": \"https://storeapi.kobo.com/v1/library/tags/{TagId}/Items\",\n  \"tags\": \"https://storeapi.kobo.com/v1/library/tags\",\n  \"taste_profile\": \"https://storeapi.kobo.com/v1/products/tasteprofile\",\n  \"terms_of_sale_page\": \"https://authorize.kobo.com/{region}/{language}/terms/termsofsale\",\n  \"topproducts\": \"https://storeapi.kobo.com/v2/products/list/topproducts\",\n  \"tracking\": \"https://storeapi.kobo.com/v2/tracking/searchperformed\",\n  \"update_accessibility_to_preview\": \"https://storeapi.kobo.com/v1/library/{EntitlementIds}/preview\",\n  \"use_one_store\": \"True\",\n  \"user_currencyconversion\": \"https://storeapi.kobo.com/v1/user/currency/convert\",\n  \"user_loyalty_benefits\": \"https://storeapi.kobo.com/v1/user/loyalty/benefits\",\n  \"user_platform\": \"https://storeapi.kobo.com/v1/user/platform\",\n  \"user_profile\": \"https://storeapi.kobo.com/v1/user/profile\",\n  \"user_ratings\": \"https://storeapi.kobo.com/v1/user/ratings\",\n  \"user_recommendations\": \"https://storeapi.kobo.com/v1/user/recommendations\",\n  \"user_reviews\": \"https://storeapi.kobo.com/v1/user/reviews\",\n  \"user_tasteprofile_complete\": \"https://storeapi.kobo.com/v2/user/tasteprofile/complete\",\n  \"user_tasteprofile_genre\": \"https://storeapi.kobo.com/v2/user/tasteprofile/genre\",\n  \"user_wishlist\": \"https://storeapi.kobo.com/v1/user/wishlist\",\n  \"userguide_host\": \"https://ereaderfiles.kobo.com\",\n  \"wishlist_page\": \"https://www.kobo.com/{region}/{language}/account/wishlist\"\n}");
    }
}

