/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.security;

import java.util.EventObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gotson.komga.domain.model.ApiKey;
import org.gotson.komga.domain.model.AuthenticationActivity;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.persistence.AuthenticationActivityRepository;
import org.gotson.komga.domain.persistence.KomgaUserRepository;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.security.LoginListenerKt;
import org.gotson.komga.infrastructure.security.UserAgentWebAuthenticationDetails;
import org.gotson.komga.infrastructure.security.apikey.ApiKeyAuthenticationToken;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationFailureProviderNotFoundEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0017J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0010H\u0012J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u000f*\u00020\u0010H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gotson/komga/infrastructure/security/LoginListener;", "", "authenticationActivityRepository", "Lorg/gotson/komga/domain/persistence/AuthenticationActivityRepository;", "userRepository", "Lorg/gotson/komga/domain/persistence/KomgaUserRepository;", "<init>", "(Lorg/gotson/komga/domain/persistence/AuthenticationActivityRepository;Lorg/gotson/komga/domain/persistence/KomgaUserRepository;)V", "onSuccess", "", "event", "Lorg/springframework/security/authentication/event/AuthenticationSuccessEvent;", "onFailure", "Lorg/springframework/security/authentication/event/AbstractAuthenticationFailureEvent;", "getIp", "", "Ljava/util/EventObject;", "getUserAgent", "komga"})
public class LoginListener {
    @NotNull
    private final AuthenticationActivityRepository authenticationActivityRepository;
    @NotNull
    private final KomgaUserRepository userRepository;

    public LoginListener(@NotNull AuthenticationActivityRepository authenticationActivityRepository, @NotNull KomgaUserRepository userRepository) {
        Intrinsics.checkNotNullParameter((Object)authenticationActivityRepository, (String)"authenticationActivityRepository");
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        this.authenticationActivityRepository = authenticationActivityRepository;
        this.userRepository = userRepository;
    }

    @EventListener
    public void onSuccess(@NotNull AuthenticationSuccessEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object2 = event.getAuthentication().getPrincipal();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.gotson.komga.infrastructure.security.KomgaPrincipal");
        KomgaPrincipal komgaPrincipal = (KomgaPrincipal)object2;
        KomgaUser user = komgaPrincipal.getUser();
        ApiKey apiKey = komgaPrincipal.getApiKey();
        Object object3 = event.getSource();
        if (object3 instanceof OAuth2LoginAuthenticationToken) {
            Object object4 = event.getSource();
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken");
            object = "OAuth2:" + ((OAuth2LoginAuthenticationToken)object4).getClientRegistration().getClientName();
        } else {
            object = object3 instanceof ApiKeyAuthenticationToken ? "ApiKey" : (object3 instanceof UsernamePasswordAuthenticationToken ? "Password" : (object3 instanceof RememberMeAuthenticationToken ? "RememberMe" : null));
        }
        String source = object;
        ApiKey apiKey2 = apiKey;
        ApiKey apiKey3 = apiKey;
        AuthenticationActivity activity = new AuthenticationActivity(user.getId(), user.getEmail(), apiKey2 != null ? apiKey2.getId() : null, apiKey3 != null ? apiKey3.getComment() : null, this.getIp((EventObject)event), this.getUserAgent((EventObject)event), true, null, null, source, 384, null);
        LoginListenerKt.access$getLogger$p().debug(() -> LoginListener.onSuccess$lambda$0(activity));
        this.authenticationActivityRepository.insert(activity);
    }

    @EventListener
    public void onFailure(@NotNull AbstractAuthenticationFailureEvent event) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof AuthenticationFailureProviderNotFoundEvent) {
            return;
        }
        Object object3 = event.getSource();
        if (object3 instanceof OAuth2LoginAuthenticationToken) {
            Object object4 = event.getSource();
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken");
            object2 = "OAuth2:" + ((OAuth2LoginAuthenticationToken)object4).getClientRegistration().getClientName();
        } else {
            object2 = object3 instanceof ApiKeyAuthenticationToken ? "ApiKey" : (object3 instanceof UsernamePasswordAuthenticationToken ? "Password" : (object3 instanceof RememberMeAuthenticationToken ? "RememberMe" : null));
        }
        String source = object2;
        Authentication authentication = event.getAuthentication();
        String string = authentication != null && (object = authentication.getPrincipal()) != null ? object.toString() : null;
        if (string == null) {
            string = "";
        }
        String principal = string;
        KomgaUser komgaUser = this.userRepository.findByEmailIgnoreCaseOrNull(principal);
        object = komgaUser != null ? komgaUser.getId() : null;
        String string2 = !(event.getSource() instanceof ApiKeyAuthenticationToken) ? principal : null;
        String string3 = event.getSource() instanceof ApiKeyAuthenticationToken ? principal : null;
        String string4 = this.getIp((EventObject)event);
        String string5 = this.getUserAgent((EventObject)event);
        String string6 = event.getException().getMessage();
        AuthenticationActivity activity = new AuthenticationActivity((String)object, string2, null, string3, string4, string5, false, string6, null, source, 260, null);
        LoginListenerKt.access$getLogger$p().debug(() -> LoginListener.onFailure$lambda$1(activity));
        this.authenticationActivityRepository.insert(activity);
    }

    private String getIp(EventObject $this$getIp) {
        Object object;
        try {
            String string;
            object = $this$getIp.getSource();
            if (object instanceof WebAuthenticationDetails) {
                Object object2 = $this$getIp.getSource();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.springframework.security.web.authentication.WebAuthenticationDetails");
                string = ((WebAuthenticationDetails)object2).getRemoteAddress();
            } else if (object instanceof AbstractAuthenticationToken) {
                Object object3 = $this$getIp.getSource();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.springframework.security.authentication.AbstractAuthenticationToken");
                Object object4 = ((AbstractAuthenticationToken)object3).getDetails();
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.springframework.security.web.authentication.WebAuthenticationDetails");
                string = ((WebAuthenticationDetails)object4).getRemoteAddress();
            } else {
                string = null;
            }
            object = string;
        }
        catch (Exception e) {
            object = null;
        }
        return object;
    }

    private String getUserAgent(EventObject $this$getUserAgent) {
        Object object;
        try {
            String string;
            object = $this$getUserAgent.getSource();
            if (object instanceof UserAgentWebAuthenticationDetails) {
                Object object2 = $this$getUserAgent.getSource();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.gotson.komga.infrastructure.security.UserAgentWebAuthenticationDetails");
                string = ((UserAgentWebAuthenticationDetails)object2).getUserAgent();
            } else if (object instanceof AbstractAuthenticationToken) {
                Object object3 = $this$getUserAgent.getSource();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.springframework.security.authentication.AbstractAuthenticationToken");
                Object object4 = ((AbstractAuthenticationToken)object3).getDetails();
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.gotson.komga.infrastructure.security.UserAgentWebAuthenticationDetails");
                string = ((UserAgentWebAuthenticationDetails)object4).getUserAgent();
            } else {
                string = null;
            }
            object = string;
        }
        catch (Exception e) {
            object = null;
        }
        return object;
    }

    private static final Object onSuccess$lambda$0(AuthenticationActivity $activity) {
        return $activity;
    }

    private static final Object onFailure$lambda$1(AuthenticationActivity $activity) {
        return $activity;
    }
}

