/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.security;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.time.Duration;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.hash.Hasher;
import org.gotson.komga.infrastructure.security.OpdsAuthenticationEntryPoint;
import org.gotson.komga.infrastructure.security.TokenEncoder;
import org.gotson.komga.infrastructure.security.apikey.ApiKeyAuthenticationFilter;
import org.gotson.komga.infrastructure.security.apikey.ApiKeyAuthenticationProvider;
import org.gotson.komga.infrastructure.security.apikey.HeaderApiKeyAuthenticationConverter;
import org.gotson.komga.infrastructure.security.apikey.UriRegexApiKeyAuthenticationConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.AuthorizeHttpRequestsDsl;
import org.springframework.security.config.annotation.web.CorsDsl;
import org.springframework.security.config.annotation.web.CsrfDsl;
import org.springframework.security.config.annotation.web.FormLoginDsl;
import org.springframework.security.config.annotation.web.HeadersDsl;
import org.springframework.security.config.annotation.web.HttpBasicDsl;
import org.springframework.security.config.annotation.web.HttpSecurityDsl;
import org.springframework.security.config.annotation.web.HttpSecurityDslKt;
import org.springframework.security.config.annotation.web.LogoutDsl;
import org.springframework.security.config.annotation.web.SessionManagementDsl;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CorsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.config.annotation.web.headers.CacheControlDsl;
import org.springframework.security.config.annotation.web.session.SessionConcurrencyDsl;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity(prePostEnabled=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0089\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\t\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0017J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0017J\u0010\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0017J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0016J\b\u0010,\u001a\u00020*H\u0016J\b\u0010\u0006\u001a\u00020-H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/gotson/komga/infrastructure/security/SecurityConfiguration;", "", "komgaSettingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "komgaUserDetailsService", "Lorg/springframework/security/core/userdetails/UserDetailsService;", "apiKeyAuthenticationProvider", "Lorg/gotson/komga/infrastructure/security/apikey/ApiKeyAuthenticationProvider;", "oauth2UserService", "Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserService;", "Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserRequest;", "Lorg/springframework/security/oauth2/core/user/OAuth2User;", "oidcUserService", "Lorg/springframework/security/oauth2/client/oidc/userinfo/OidcUserRequest;", "Lorg/springframework/security/oauth2/core/oidc/user/OidcUser;", "sessionCookieName", "", "userAgentWebAuthenticationDetailsSource", "Lorg/springframework/security/web/authentication/WebAuthenticationDetailsSource;", "theSessionRegistry", "Lorg/springframework/security/core/session/SessionRegistry;", "opdsAuthenticationEntryPoint", "Lorg/gotson/komga/infrastructure/security/OpdsAuthenticationEntryPoint;", "authenticationEventPublisher", "Lorg/springframework/security/authentication/AuthenticationEventPublisher;", "tokenEncoder", "Lorg/gotson/komga/infrastructure/security/TokenEncoder;", "hasher", "Lorg/gotson/komga/infrastructure/hash/Hasher;", "clientRegistrationRepository", "Lorg/springframework/security/oauth2/client/registration/InMemoryClientRegistrationRepository;", "<init>", "(Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Lorg/springframework/security/core/userdetails/UserDetailsService;Lorg/gotson/komga/infrastructure/security/apikey/ApiKeyAuthenticationProvider;Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserService;Lorg/springframework/security/oauth2/client/userinfo/OAuth2UserService;Ljava/lang/String;Lorg/springframework/security/web/authentication/WebAuthenticationDetailsSource;Lorg/springframework/security/core/session/SessionRegistry;Lorg/gotson/komga/infrastructure/security/OpdsAuthenticationEntryPoint;Lorg/springframework/security/authentication/AuthenticationEventPublisher;Lorg/gotson/komga/infrastructure/security/TokenEncoder;Lorg/gotson/komga/infrastructure/hash/Hasher;Lorg/springframework/security/oauth2/client/registration/InMemoryClientRegistrationRepository;)V", "oauth2Enabled", "", "filterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "koboFilterChain", "kosyncFilterChain", "koboAuthenticationFilter", "Ljakarta/servlet/Filter;", "kosyncAuthenticationFilter", "restAuthenticationFilter", "Lorg/springframework/security/authentication/AuthenticationManager;", "komga"})
@SourceDebugExtension(value={"SMAP\nSecurityConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecurityConfiguration.kt\norg/gotson/komga/infrastructure/security/SecurityConfiguration\n+ 2 HttpSecurityDsl.kt\norg/springframework/security/config/annotation/web/HttpSecurityDsl\n*L\n1#1,265:1\n1274#2,2:266\n1274#2,2:268\n*S KotlinDebug\n*F\n+ 1 SecurityConfiguration.kt\norg/gotson/komga/infrastructure/security/SecurityConfiguration\n*L\n201#1:266,2\n236#1:268,2\n*E\n"})
public class SecurityConfiguration {
    @NotNull
    private final KomgaSettingsProvider komgaSettingsProvider;
    @NotNull
    private final UserDetailsService komgaUserDetailsService;
    @NotNull
    private final ApiKeyAuthenticationProvider apiKeyAuthenticationProvider;
    @NotNull
    private final OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService;
    @NotNull
    private final OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService;
    @NotNull
    private final String sessionCookieName;
    @NotNull
    private final WebAuthenticationDetailsSource userAgentWebAuthenticationDetailsSource;
    @NotNull
    private final SessionRegistry theSessionRegistry;
    @NotNull
    private final OpdsAuthenticationEntryPoint opdsAuthenticationEntryPoint;
    @NotNull
    private final AuthenticationEventPublisher authenticationEventPublisher;
    @NotNull
    private final TokenEncoder tokenEncoder;
    @NotNull
    private final Hasher hasher;
    private final boolean oauth2Enabled;

    public SecurityConfiguration(@NotNull KomgaSettingsProvider komgaSettingsProvider, @NotNull UserDetailsService komgaUserDetailsService, @NotNull ApiKeyAuthenticationProvider apiKeyAuthenticationProvider, @NotNull OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService, @NotNull OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService, @NotNull String sessionCookieName, @NotNull WebAuthenticationDetailsSource userAgentWebAuthenticationDetailsSource, @NotNull SessionRegistry theSessionRegistry, @NotNull OpdsAuthenticationEntryPoint opdsAuthenticationEntryPoint, @NotNull AuthenticationEventPublisher authenticationEventPublisher, @NotNull TokenEncoder tokenEncoder, @NotNull Hasher hasher, @Nullable InMemoryClientRegistrationRepository clientRegistrationRepository) {
        Intrinsics.checkNotNullParameter((Object)komgaSettingsProvider, (String)"komgaSettingsProvider");
        Intrinsics.checkNotNullParameter((Object)komgaUserDetailsService, (String)"komgaUserDetailsService");
        Intrinsics.checkNotNullParameter((Object)apiKeyAuthenticationProvider, (String)"apiKeyAuthenticationProvider");
        Intrinsics.checkNotNullParameter(oauth2UserService, (String)"oauth2UserService");
        Intrinsics.checkNotNullParameter(oidcUserService, (String)"oidcUserService");
        Intrinsics.checkNotNullParameter((Object)sessionCookieName, (String)"sessionCookieName");
        Intrinsics.checkNotNullParameter((Object)userAgentWebAuthenticationDetailsSource, (String)"userAgentWebAuthenticationDetailsSource");
        Intrinsics.checkNotNullParameter((Object)theSessionRegistry, (String)"theSessionRegistry");
        Intrinsics.checkNotNullParameter((Object)opdsAuthenticationEntryPoint, (String)"opdsAuthenticationEntryPoint");
        Intrinsics.checkNotNullParameter((Object)authenticationEventPublisher, (String)"authenticationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)tokenEncoder, (String)"tokenEncoder");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        this.komgaSettingsProvider = komgaSettingsProvider;
        this.komgaUserDetailsService = komgaUserDetailsService;
        this.apiKeyAuthenticationProvider = apiKeyAuthenticationProvider;
        this.oauth2UserService = oauth2UserService;
        this.oidcUserService = oidcUserService;
        this.sessionCookieName = sessionCookieName;
        this.userAgentWebAuthenticationDetailsSource = userAgentWebAuthenticationDetailsSource;
        this.theSessionRegistry = theSessionRegistry;
        this.opdsAuthenticationEntryPoint = opdsAuthenticationEntryPoint;
        this.authenticationEventPublisher = authenticationEventPublisher;
        this.tokenEncoder = tokenEncoder;
        this.hasher = hasher;
        this.oauth2Enabled = clientRegistrationRepository != null;
    }

    @Order(value=1)
    @Bean
    @NotNull
    public SecurityFilterChain filterChain(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        http.cors(SecurityConfiguration::filterChain$lambda$0).csrf(SecurityConfiguration::filterChain$lambda$1).securityMatchers(SecurityConfiguration::filterChain$lambda$2).authorizeHttpRequests(SecurityConfiguration::filterChain$lambda$3).headers(SecurityConfiguration::filterChain$lambda$6).userDetailsService(this.komgaUserDetailsService).httpBasic(arg_0 -> SecurityConfiguration.filterChain$lambda$7(this, arg_0)).logout(arg_0 -> SecurityConfiguration.filterChain$lambda$8(this, arg_0)).sessionManagement(arg_0 -> SecurityConfiguration.filterChain$lambda$10(this, arg_0)).exceptionHandling(arg_0 -> SecurityConfiguration.filterChain$lambda$11(this, arg_0));
        if (this.oauth2Enabled) {
            http.oauth2Login(arg_0 -> SecurityConfiguration.filterChain$lambda$15(this, arg_0));
        }
        http.rememberMe(arg_0 -> SecurityConfiguration.filterChain$lambda$17(this, arg_0));
        http.addFilterAfter(this.restAuthenticationFilter(), BasicAuthenticationFilter.class);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @Bean
    @NotNull
    public SecurityFilterChain koboFilterChain(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        HttpSecurityDslKt.invoke((HttpSecurity)http, arg_0 -> SecurityConfiguration.koboFilterChain$lambda$26(this, arg_0));
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @Bean
    @NotNull
    public SecurityFilterChain kosyncFilterChain(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        HttpSecurityDslKt.invoke((HttpSecurity)http, arg_0 -> SecurityConfiguration.kosyncFilterChain$lambda$37(this, arg_0));
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @NotNull
    public Filter koboAuthenticationFilter() {
        return (Filter)new ApiKeyAuthenticationFilter(this.apiKeyAuthenticationProvider(), (AuthenticationConverter)new UriRegexApiKeyAuthenticationConverter(new Regex("/kobo/([\\w-]+)"), this.hasher, this.tokenEncoder, (AuthenticationDetailsSource)this.userAgentWebAuthenticationDetailsSource));
    }

    @NotNull
    public Filter kosyncAuthenticationFilter() {
        return (Filter)new ApiKeyAuthenticationFilter(this.apiKeyAuthenticationProvider(), (AuthenticationConverter)new HeaderApiKeyAuthenticationConverter("X-Auth-User", this.hasher, this.tokenEncoder, (AuthenticationDetailsSource)this.userAgentWebAuthenticationDetailsSource));
    }

    @NotNull
    public Filter restAuthenticationFilter() {
        return (Filter)new ApiKeyAuthenticationFilter(this.apiKeyAuthenticationProvider(), (AuthenticationConverter)new HeaderApiKeyAuthenticationConverter("X-API-Key", this.hasher, this.tokenEncoder, (AuthenticationDetailsSource)this.userAgentWebAuthenticationDetailsSource));
    }

    @NotNull
    public AuthenticationManager apiKeyAuthenticationProvider() {
        ProviderManager providerManager = new ProviderManager[]{this.apiKeyAuthenticationProvider};
        ProviderManager $this$apiKeyAuthenticationProvider_u24lambda_u2438 = providerManager = new ProviderManager((AuthenticationProvider[])providerManager);
        boolean bl = false;
        $this$apiKeyAuthenticationProvider_u24lambda_u2438.setAuthenticationEventPublisher(this.authenticationEventPublisher);
        return (AuthenticationManager)providerManager;
    }

    private static final void filterChain$lambda$0(CorsConfigurer it) {
    }

    private static final void filterChain$lambda$1(CsrfConfigurer it) {
        it.disable();
    }

    private static final void filterChain$lambda$2(HttpSecurity.RequestMatcherConfigurer it) {
        String[] stringArray = new String[]{"/api/**", "/opds/**", "/sse/**", "/oauth2/authorization/**", "/login/oauth2/code/**"};
        it.requestMatchers(stringArray);
        stringArray = new RequestMatcher[]{EndpointRequest.toAnyEndpoint()};
        it.requestMatchers((RequestMatcher[])stringArray);
    }

    private static final void filterChain$lambda$3(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        Object[] objectArray = new RequestMatcher[1];
        Class[] classArray = new Class[]{HealthEndpoint.class};
        objectArray[0] = EndpointRequest.to((Class[])classArray);
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(objectArray)).permitAll();
        objectArray = new RequestMatcher[]{EndpointRequest.toAnyEndpoint()};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(objectArray)).hasRole("ADMIN");
        objectArray = new String[]{"/api/v1/claim", "/api/v1/oauth2/providers", "/api/v1/client-settings/global/list", "/api/v1/books/{bookId}/resource/**", "/api/v1/fonts/resource/**", "/opds/v2/auth", "/koreader/users/create"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers((String[])objectArray)).permitAll();
        objectArray = new String[]{"/api/**", "/opds/**", "/sse/**"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers((String[])objectArray)).authenticated();
    }

    private static final void filterChain$lambda$6$lambda$4(HeadersConfigurer.CacheControlConfig it) {
        it.disable();
    }

    private static final void filterChain$lambda$6$lambda$5(HeadersConfigurer.FrameOptionsConfig it) {
        it.sameOrigin();
    }

    private static final void filterChain$lambda$6(HeadersConfigurer headersConfigurer) {
        headersConfigurer.cacheControl(SecurityConfiguration::filterChain$lambda$6$lambda$4);
        headersConfigurer.frameOptions(SecurityConfiguration::filterChain$lambda$6$lambda$5);
    }

    private static final void filterChain$lambda$7(SecurityConfiguration this$0, HttpBasicConfigurer it) {
        it.authenticationDetailsSource((AuthenticationDetailsSource)this$0.userAgentWebAuthenticationDetailsSource);
    }

    private static final void filterChain$lambda$8(SecurityConfiguration this$0, LogoutConfigurer it) {
        it.logoutUrl("/api/logout");
        String[] stringArray = new String[]{this$0.sessionCookieName};
        it.deleteCookies(stringArray);
        it.invalidateHttpSession(true);
    }

    private static final void filterChain$lambda$10$lambda$9(SecurityConfiguration this$0, SessionManagementConfigurer.ConcurrencyControlConfigurer it) {
        it.sessionRegistry(this$0.theSessionRegistry);
        it.maximumSessions(-1);
    }

    private static final void filterChain$lambda$10(SecurityConfiguration this$0, SessionManagementConfigurer session) {
        session.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
        session.sessionConcurrency(arg_0 -> SecurityConfiguration.filterChain$lambda$10$lambda$9(this$0, arg_0));
    }

    private static final void filterChain$lambda$11(SecurityConfiguration this$0, ExceptionHandlingConfigurer it) {
        it.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)this$0.opdsAuthenticationEntryPoint, (RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher("/opds/v2/**"));
    }

    private static final void filterChain$lambda$15$lambda$12(SecurityConfiguration this$0, OAuth2LoginConfigurer.UserInfoEndpointConfig it) {
        it.userService(this$0.oauth2UserService);
        it.oidcUserService(this$0.oidcUserService);
    }

    private static final void filterChain$lambda$15$lambda$13(HttpServletRequest request, HttpServletResponse response2, AuthenticationException exception) {
        String errorMessage = exception instanceof OAuth2AuthenticationException ? ((OAuth2AuthenticationException)exception).getError().getErrorCode() : exception.getMessage();
        String url = "/login?server_redirect=Y&error=" + errorMessage;
        new SimpleUrlAuthenticationFailureHandler(url).onAuthenticationFailure(request, response2, exception);
    }

    private static final void filterChain$lambda$15$lambda$14(OAuth2LoginConfigurer.RedirectionEndpointConfig it) {
    }

    private static final void filterChain$lambda$15(SecurityConfiguration this$0, OAuth2LoginConfigurer oauth2) {
        oauth2.userInfoEndpoint(arg_0 -> SecurityConfiguration.filterChain$lambda$15$lambda$12(this$0, arg_0));
        oauth2.authenticationDetailsSource((AuthenticationDetailsSource)this$0.userAgentWebAuthenticationDetailsSource);
        ((OAuth2LoginConfigurer)oauth2.loginPage("/login").defaultSuccessUrl("/?server_redirect=Y", true)).failureHandler(SecurityConfiguration::filterChain$lambda$15$lambda$13);
        oauth2.redirectionEndpoint(SecurityConfiguration::filterChain$lambda$15$lambda$14);
    }

    /*
     * WARNING - void declaration
     */
    private static final void filterChain$lambda$17(SecurityConfiguration this$0, RememberMeConfigurer it) {
        void $this$filterChain_u24lambda_u2417_u24lambda_u2416;
        TokenBasedRememberMeServices tokenBasedRememberMeServices;
        TokenBasedRememberMeServices tokenBasedRememberMeServices2 = tokenBasedRememberMeServices = new TokenBasedRememberMeServices(this$0.komgaSettingsProvider.getRememberMeKey(), this$0.komgaUserDetailsService);
        RememberMeConfigurer rememberMeConfigurer = it;
        boolean bl = false;
        $this$filterChain_u24lambda_u2417_u24lambda_u2416.setTokenValiditySeconds((int)Duration.getInWholeSeconds-impl((long)this$0.komgaSettingsProvider.getRememberMeDuration-UwyO8pc()));
        $this$filterChain_u24lambda_u2417_u24lambda_u2416.setAuthenticationDetailsSource((AuthenticationDetailsSource)this$0.userAgentWebAuthenticationDetailsSource);
        $this$filterChain_u24lambda_u2417_u24lambda_u2416.setCookieName("komga-remember-me");
        rememberMeConfigurer.rememberMeServices((RememberMeServices)tokenBasedRememberMeServices);
    }

    private static final Unit koboFilterChain$lambda$26$lambda$18(CorsDsl $this$cors) {
        Intrinsics.checkNotNullParameter((Object)$this$cors, (String)"$this$cors");
        return Unit.INSTANCE;
    }

    private static final Unit koboFilterChain$lambda$26$lambda$19(CsrfDsl $this$csrf) {
        Intrinsics.checkNotNullParameter((Object)$this$csrf, (String)"$this$csrf");
        $this$csrf.disable();
        return Unit.INSTANCE;
    }

    private static final Unit koboFilterChain$lambda$26$lambda$20(FormLoginDsl $this$formLogin) {
        Intrinsics.checkNotNullParameter((Object)$this$formLogin, (String)"$this$formLogin");
        $this$formLogin.disable();
        return Unit.INSTANCE;
    }

    private static final Unit koboFilterChain$lambda$26$lambda$21(HttpBasicDsl $this$httpBasic) {
        Intrinsics.checkNotNullParameter((Object)$this$httpBasic, (String)"$this$httpBasic");
        $this$httpBasic.disable();
        return Unit.INSTANCE;
    }

    private static final Unit koboFilterChain$lambda$26$lambda$22(LogoutDsl $this$logout) {
        Intrinsics.checkNotNullParameter((Object)$this$logout, (String)"$this$logout");
        $this$logout.disable();
        return Unit.INSTANCE;
    }

    private static final Unit koboFilterChain$lambda$26$lambda$23(AuthorizeHttpRequestsDsl $this$authorizeHttpRequests) {
        Intrinsics.checkNotNullParameter((Object)$this$authorizeHttpRequests, (String)"$this$authorizeHttpRequests");
        $this$authorizeHttpRequests.authorize($this$authorizeHttpRequests.getAnyRequest(), $this$authorizeHttpRequests.hasRole("KOBO_SYNC"));
        return Unit.INSTANCE;
    }

    private static final Unit koboFilterChain$lambda$26$lambda$25$lambda$24(CacheControlDsl $this$cacheControl) {
        Intrinsics.checkNotNullParameter((Object)$this$cacheControl, (String)"$this$cacheControl");
        $this$cacheControl.disable();
        return Unit.INSTANCE;
    }

    private static final Unit koboFilterChain$lambda$26$lambda$25(HeadersDsl $this$headers) {
        Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
        $this$headers.cacheControl(SecurityConfiguration::koboFilterChain$lambda$26$lambda$25$lambda$24);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit koboFilterChain$lambda$26(SecurityConfiguration this$0, HttpSecurityDsl $this$http) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$http, (String)"$this$http");
        $this$http.cors(SecurityConfiguration::koboFilterChain$lambda$26$lambda$18);
        $this$http.csrf(SecurityConfiguration::koboFilterChain$lambda$26$lambda$19);
        $this$http.formLogin(SecurityConfiguration::koboFilterChain$lambda$26$lambda$20);
        $this$http.httpBasic(SecurityConfiguration::koboFilterChain$lambda$26$lambda$21);
        $this$http.logout(SecurityConfiguration::koboFilterChain$lambda$26$lambda$22);
        String[] stringArray = new String[]{"/kobo/**"};
        $this$http.securityMatcher(stringArray);
        $this$http.authorizeHttpRequests(SecurityConfiguration::koboFilterChain$lambda$26$lambda$23);
        $this$http.headers(SecurityConfiguration::koboFilterChain$lambda$26$lambda$25);
        stringArray = $this$http;
        Filter filter$iv = this$0.koboAuthenticationFilter();
        boolean $i$f$addFilterBefore = false;
        this_$iv.addFilterBefore(filter$iv, AnonymousAuthenticationFilter.class);
        return Unit.INSTANCE;
    }

    private static final Unit kosyncFilterChain$lambda$37$lambda$27(CorsDsl $this$cors) {
        Intrinsics.checkNotNullParameter((Object)$this$cors, (String)"$this$cors");
        return Unit.INSTANCE;
    }

    private static final Unit kosyncFilterChain$lambda$37$lambda$28(CsrfDsl $this$csrf) {
        Intrinsics.checkNotNullParameter((Object)$this$csrf, (String)"$this$csrf");
        $this$csrf.disable();
        return Unit.INSTANCE;
    }

    private static final Unit kosyncFilterChain$lambda$37$lambda$29(FormLoginDsl $this$formLogin) {
        Intrinsics.checkNotNullParameter((Object)$this$formLogin, (String)"$this$formLogin");
        $this$formLogin.disable();
        return Unit.INSTANCE;
    }

    private static final Unit kosyncFilterChain$lambda$37$lambda$30(HttpBasicDsl $this$httpBasic) {
        Intrinsics.checkNotNullParameter((Object)$this$httpBasic, (String)"$this$httpBasic");
        $this$httpBasic.disable();
        return Unit.INSTANCE;
    }

    private static final Unit kosyncFilterChain$lambda$37$lambda$31(LogoutDsl $this$logout) {
        Intrinsics.checkNotNullParameter((Object)$this$logout, (String)"$this$logout");
        $this$logout.disable();
        return Unit.INSTANCE;
    }

    private static final Unit kosyncFilterChain$lambda$37$lambda$32(AuthorizeHttpRequestsDsl $this$authorizeHttpRequests) {
        Intrinsics.checkNotNullParameter((Object)$this$authorizeHttpRequests, (String)"$this$authorizeHttpRequests");
        $this$authorizeHttpRequests.authorize($this$authorizeHttpRequests.getAnyRequest(), $this$authorizeHttpRequests.hasRole("KOREADER_SYNC"));
        return Unit.INSTANCE;
    }

    private static final Unit kosyncFilterChain$lambda$37$lambda$34$lambda$33(CacheControlDsl $this$cacheControl) {
        Intrinsics.checkNotNullParameter((Object)$this$cacheControl, (String)"$this$cacheControl");
        $this$cacheControl.disable();
        return Unit.INSTANCE;
    }

    private static final Unit kosyncFilterChain$lambda$37$lambda$34(HeadersDsl $this$headers) {
        Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
        $this$headers.cacheControl(SecurityConfiguration::kosyncFilterChain$lambda$37$lambda$34$lambda$33);
        return Unit.INSTANCE;
    }

    private static final Unit kosyncFilterChain$lambda$37$lambda$36$lambda$35(SecurityConfiguration this$0, SessionConcurrencyDsl $this$sessionConcurrency) {
        Intrinsics.checkNotNullParameter((Object)$this$sessionConcurrency, (String)"$this$sessionConcurrency");
        $this$sessionConcurrency.setSessionRegistry(this$0.theSessionRegistry);
        $this$sessionConcurrency.setMaximumSessions(Integer.valueOf(-1));
        return Unit.INSTANCE;
    }

    private static final Unit kosyncFilterChain$lambda$37$lambda$36(SecurityConfiguration this$0, SessionManagementDsl $this$sessionManagement) {
        Intrinsics.checkNotNullParameter((Object)$this$sessionManagement, (String)"$this$sessionManagement");
        $this$sessionManagement.setSessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
        $this$sessionManagement.sessionConcurrency(arg_0 -> SecurityConfiguration.kosyncFilterChain$lambda$37$lambda$36$lambda$35(this$0, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit kosyncFilterChain$lambda$37(SecurityConfiguration this$0, HttpSecurityDsl $this$http) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$http, (String)"$this$http");
        $this$http.cors(SecurityConfiguration::kosyncFilterChain$lambda$37$lambda$27);
        $this$http.csrf(SecurityConfiguration::kosyncFilterChain$lambda$37$lambda$28);
        $this$http.formLogin(SecurityConfiguration::kosyncFilterChain$lambda$37$lambda$29);
        $this$http.httpBasic(SecurityConfiguration::kosyncFilterChain$lambda$37$lambda$30);
        $this$http.logout(SecurityConfiguration::kosyncFilterChain$lambda$37$lambda$31);
        String[] stringArray = new String[]{"/koreader/**"};
        $this$http.securityMatcher(stringArray);
        $this$http.authorizeHttpRequests(SecurityConfiguration::kosyncFilterChain$lambda$37$lambda$32);
        $this$http.headers(SecurityConfiguration::kosyncFilterChain$lambda$37$lambda$34);
        $this$http.sessionManagement(arg_0 -> SecurityConfiguration.kosyncFilterChain$lambda$37$lambda$36(this$0, arg_0));
        stringArray = $this$http;
        Filter filter$iv = this$0.kosyncAuthenticationFilter();
        boolean $i$f$addFilterBefore = false;
        this_$iv.addFilterBefore(filter$iv, AnonymousAuthenticationFilter.class);
        return Unit.INSTANCE;
    }
}

