/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.security.apikey;

import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.infrastructure.hash.Hasher;
import org.gotson.komga.infrastructure.security.TokenEncoder;
import org.gotson.komga.infrastructure.security.apikey.ApiKeyAuthenticationToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationConverter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gotson/komga/infrastructure/security/apikey/HeaderApiKeyAuthenticationConverter;", "Lorg/springframework/security/web/authentication/AuthenticationConverter;", "headerName", "", "hasher", "Lorg/gotson/komga/infrastructure/hash/Hasher;", "tokenEncoder", "Lorg/gotson/komga/infrastructure/security/TokenEncoder;", "authenticationDetailsSource", "Lorg/springframework/security/authentication/AuthenticationDetailsSource;", "Ljakarta/servlet/http/HttpServletRequest;", "<init>", "(Ljava/lang/String;Lorg/gotson/komga/infrastructure/hash/Hasher;Lorg/gotson/komga/infrastructure/security/TokenEncoder;Lorg/springframework/security/authentication/AuthenticationDetailsSource;)V", "convert", "Lorg/springframework/security/core/Authentication;", "request", "komga"})
@SourceDebugExtension(value={"SMAP\nHeaderApiKeyAuthenticationConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderApiKeyAuthenticationConverter.kt\norg/gotson/komga/infrastructure/security/apikey/HeaderApiKeyAuthenticationConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class HeaderApiKeyAuthenticationConverter
implements AuthenticationConverter {
    @NotNull
    private final String headerName;
    @NotNull
    private final Hasher hasher;
    @NotNull
    private final TokenEncoder tokenEncoder;
    @NotNull
    private final AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource;

    public HeaderApiKeyAuthenticationConverter(@NotNull String headerName, @NotNull Hasher hasher, @NotNull TokenEncoder tokenEncoder, @NotNull AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        Intrinsics.checkNotNullParameter((Object)tokenEncoder, (String)"tokenEncoder");
        Intrinsics.checkNotNullParameter(authenticationDetailsSource, (String)"authenticationDetailsSource");
        this.headerName = headerName;
        this.hasher = hasher;
        this.tokenEncoder = tokenEncoder;
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    @Nullable
    public Authentication convert(@NotNull HttpServletRequest request) {
        ApiKeyAuthenticationToken apiKeyAuthenticationToken;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getHeader(this.headerName);
        if (string != null) {
            ApiKeyAuthenticationToken apiKeyAuthenticationToken2;
            String it = string;
            boolean bl = false;
            String maskedToken = this.hasher.computeHash(it);
            String hashedToken = this.tokenEncoder.encode(it);
            ApiKeyAuthenticationToken $this$convert_u24lambda_u241_u24lambda_u240 = apiKeyAuthenticationToken2 = ApiKeyAuthenticationToken.Companion.unauthenticated((Object)maskedToken, (Object)hashedToken);
            boolean bl2 = false;
            $this$convert_u24lambda_u241_u24lambda_u240.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            apiKeyAuthenticationToken = apiKeyAuthenticationToken2;
        } else {
            apiKeyAuthenticationToken = null;
        }
        return (Authentication)apiKeyAuthenticationToken;
    }
}

