/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.util;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0006\u0010\u0002\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "checkTempDirectory", "", "komga"})
@SourceDebugExtension(value={"SMAP\nTempDirectoryChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TempDirectoryChecker.kt\norg/gotson/komga/infrastructure/util/TempDirectoryCheckerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n1#2:36\n*E\n"})
public final class TempDirectoryCheckerKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(TempDirectoryCheckerKt::logger$lambda$0);

    public static final void checkTempDirectory() {
        String string = System.getProperty("java.io.tmpdir");
        if (string != null) {
            String it = string;
            boolean bl = false;
            Path path = Paths.get(it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path tmpDir = path;
            if (Files.notExists(tmpDir, new LinkOption[0])) {
                logger.warn(() -> TempDirectoryCheckerKt.checkTempDirectory$lambda$5$lambda$1(tmpDir));
                try {
                    Files.createDirectories(tmpDir, new FileAttribute[0]);
                    logger.info(() -> TempDirectoryCheckerKt.checkTempDirectory$lambda$5$lambda$2(tmpDir));
                }
                catch (Exception e) {
                    logger.error((Throwable)e, () -> TempDirectoryCheckerKt.checkTempDirectory$lambda$5$lambda$3(tmpDir));
                    throw new IllegalStateException("Could not create missing temp directory: " + tmpDir, e);
                }
            }
            if (!Files.isWritable(tmpDir)) {
                boolean bl2 = false;
                String string2 = "Temp directory is not writable: " + tmpDir;
                throw new IllegalStateException(string2.toString());
            }
        } else {
            throw new IllegalStateException("System property 'java.io.tmpdir' is not defined");
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object checkTempDirectory$lambda$5$lambda$1(Path $tmpDir) {
        return "Temp directory does not exist, attempting to create it: " + $tmpDir;
    }

    private static final Object checkTempDirectory$lambda$5$lambda$2(Path $tmpDir) {
        return "Created missing temp directory: " + $tmpDir;
    }

    private static final Object checkTempDirectory$lambda$5$lambda$3(Path $tmpDir) {
        return "Could not create missing temp directory: " + $tmpDir;
    }
}

