/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.EntryNotFoundException;
import org.gotson.komga.domain.model.ImageConversionException;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MediaNotReadyException;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.MediaUnsupportedException;
import org.gotson.komga.domain.model.R2Progression;
import org.gotson.komga.domain.model.R2ProgressionKt;
import org.gotson.komga.domain.model.ReadProgress;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.domain.persistence.MediaRepository;
import org.gotson.komga.domain.persistence.ReadProgressRepository;
import org.gotson.komga.domain.persistence.SeriesMetadataRepository;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.domain.service.BookLifecycle;
import org.gotson.komga.infrastructure.image.ImageType;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.interfaces.api.CommonBookController;
import org.gotson.komga.interfaces.api.CommonBookControllerKt;
import org.gotson.komga.interfaces.api.ContentRestrictionChecker;
import org.gotson.komga.interfaces.api.UtilsKt;
import org.gotson.komga.interfaces.api.WebPubGenerator;
import org.gotson.komga.interfaces.api.dto.WPPublicationDto;
import org.gotson.komga.interfaces.api.persistence.BookDtoRepository;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(produces={"application/json"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016JP\u0010!\u001a\u0010\u0012\f\u0012\n $*\u0004\u0018\u00010#0#0\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u001b2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+H\u0016J4\u0010-\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010%\u001a\u00020&H\u0017J&\u0010.\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010%\u001a\u00020&H\u0016J6\u00103\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010(\u001a\u0002042\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u00105\u001a\u00020\u001bH\u0017J\"\u00106\u001a\b\u0012\u0004\u0012\u0002070\"2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0017J\u001e\u00108\u001a\b\u0012\u0004\u0012\u0002070\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u00109\u001a\b\u0012\u0004\u0012\u00020:0\"2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0017J&\u0010;\u001a\u00020<2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010=\u001a\u00020:H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/gotson/komga/interfaces/api/CommonBookController;", "", "mediaRepository", "Lorg/gotson/komga/domain/persistence/MediaRepository;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "bookDtoRepository", "Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;", "seriesMetadataRepository", "Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;", "bookLifecycle", "Lorg/gotson/komga/domain/service/BookLifecycle;", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "contentRestrictionChecker", "Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "readProgressRepository", "Lorg/gotson/komga/domain/persistence/ReadProgressRepository;", "<init>", "(Lorg/gotson/komga/domain/persistence/MediaRepository;Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;Lorg/gotson/komga/domain/persistence/SeriesMetadataRepository;Lorg/gotson/komga/domain/service/BookLifecycle;Lorg/gotson/komga/domain/service/BookAnalyzer;Lorg/gotson/komga/interfaces/api/ContentRestrictionChecker;Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Lorg/gotson/komga/domain/persistence/ReadProgressRepository;)V", "getWebPubManifestInternal", "Lorg/gotson/komga/interfaces/api/dto/WPPublicationDto;", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "bookId", "", "webPubGenerator", "Lorg/gotson/komga/interfaces/api/WebPubGenerator;", "getWebPubManifestEpubInternal", "getWebPubManifestPdfInternal", "getWebPubManifestDivinaInternal", "getBookPageInternal", "Lorg/springframework/http/ResponseEntity;", "", "kotlin.jvm.PlatformType", "pageNumber", "", "convertTo", "request", "Lorg/springframework/web/context/request/ServletWebRequest;", "acceptHeaders", "", "Lorg/springframework/http/MediaType;", "getBookPageRawByNumber", "getBookPageRawInternal", "book", "Lorg/gotson/komga/domain/model/Book;", "media", "Lorg/gotson/komga/domain/model/Media;", "getBookEpubResource", "Ljakarta/servlet/http/HttpServletRequest;", "resource", "downloadBookFile", "Lorg/springframework/web/servlet/mvc/method/annotation/StreamingResponseBody;", "getBookFileInternal", "getBookProgression", "Lorg/gotson/komga/domain/model/R2Progression;", "updateBookProgression", "", "progression", "komga"})
@SourceDebugExtension(value={"SMAP\nCommonBookController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonBookController.kt\norg/gotson/komga/interfaces/api/CommonBookController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,416:1\n1761#2,3:417\n295#2,2:420\n*S KotlinDebug\n*F\n+ 1 CommonBookController.kt\norg/gotson/komga/interfaces/api/CommonBookController\n*L\n149#1:417,3\n292#1:420,2\n*E\n"})
public class CommonBookController {
    @NotNull
    private final MediaRepository mediaRepository;
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final BookDtoRepository bookDtoRepository;
    @NotNull
    private final SeriesMetadataRepository seriesMetadataRepository;
    @NotNull
    private final BookLifecycle bookLifecycle;
    @NotNull
    private final BookAnalyzer bookAnalyzer;
    @NotNull
    private final ContentRestrictionChecker contentRestrictionChecker;
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final ReadProgressRepository readProgressRepository;

    public CommonBookController(@NotNull MediaRepository mediaRepository, @NotNull BookRepository bookRepository, @NotNull BookDtoRepository bookDtoRepository, @NotNull SeriesMetadataRepository seriesMetadataRepository, @NotNull BookLifecycle bookLifecycle, @NotNull BookAnalyzer bookAnalyzer, @NotNull ContentRestrictionChecker contentRestrictionChecker, @NotNull ContentDetector contentDetector, @NotNull ReadProgressRepository readProgressRepository) {
        Intrinsics.checkNotNullParameter((Object)mediaRepository, (String)"mediaRepository");
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)bookDtoRepository, (String)"bookDtoRepository");
        Intrinsics.checkNotNullParameter((Object)seriesMetadataRepository, (String)"seriesMetadataRepository");
        Intrinsics.checkNotNullParameter((Object)bookLifecycle, (String)"bookLifecycle");
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        Intrinsics.checkNotNullParameter((Object)contentRestrictionChecker, (String)"contentRestrictionChecker");
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter((Object)readProgressRepository, (String)"readProgressRepository");
        this.mediaRepository = mediaRepository;
        this.bookRepository = bookRepository;
        this.bookDtoRepository = bookDtoRepository;
        this.seriesMetadataRepository = seriesMetadataRepository;
        this.bookLifecycle = bookLifecycle;
        this.bookAnalyzer = bookAnalyzer;
        this.contentRestrictionChecker = contentRestrictionChecker;
        this.contentDetector = contentDetector;
        this.readProgressRepository = readProgressRepository;
    }

    @NotNull
    public WPPublicationDto getWebPubManifestInternal(@NotNull KomgaPrincipal principal, @NotNull String bookId, @NotNull WebPubGenerator webPubGenerator) {
        Media media;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                Intrinsics.checkNotNullParameter((Object)webPubGenerator, (String)"webPubGenerator");
                media = this.mediaRepository.findByIdOrNull(bookId);
                if (media == null) break block8;
                Media media2 = media;
                boolean bl = false;
                MediaType mediaType = MediaType.Companion.fromMediaType(media2.getMediaType());
                MediaProfile mediaProfile = mediaType != null ? mediaType.getProfile() : null;
                WPPublicationDto wPPublicationDto = switch (mediaProfile == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mediaProfile.ordinal()]) {
                    case 1 -> this.getWebPubManifestDivinaInternal(principal, bookId, webPubGenerator);
                    case 2 -> this.getWebPubManifestPdfInternal(principal, bookId, webPubGenerator);
                    case 3 -> this.getWebPubManifestEpubInternal(principal, bookId, webPubGenerator);
                    case -1 -> throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book analysis failed");
                    default -> throw new NoWhenBranchMatchedException();
                };
                media = wPPublicationDto;
                if (wPPublicationDto != null) break block9;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return media;
    }

    @NotNull
    public WPPublicationDto getWebPubManifestEpubInternal(@NotNull KomgaPrincipal principal, @NotNull String bookId, @NotNull WebPubGenerator webPubGenerator) {
        BookDto bookDto;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                Intrinsics.checkNotNullParameter((Object)webPubGenerator, (String)"webPubGenerator");
                bookDto = this.bookDtoRepository.findByIdOrNull(bookId, principal.getUser().getId());
                if (bookDto == null) break block4;
                BookDto bookDto2 = bookDto;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)bookDto2.getMedia().getMediaProfile(), (Object)"EPUB")) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Book media type '" + bookDto2.getMedia().getMediaType() + "' not compatible with requested profile");
                }
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), bookDto2);
                WPPublicationDto wPPublicationDto = webPubGenerator.toManifestEpub(bookDto2, this.mediaRepository.findById(bookId), this.seriesMetadataRepository.findById(bookDto2.getSeriesId()));
                bookDto = wPPublicationDto;
                if (wPPublicationDto != null) break block5;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return bookDto;
    }

    @NotNull
    public WPPublicationDto getWebPubManifestPdfInternal(@NotNull KomgaPrincipal principal, @NotNull String bookId, @NotNull WebPubGenerator webPubGenerator) {
        BookDto bookDto;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                Intrinsics.checkNotNullParameter((Object)webPubGenerator, (String)"webPubGenerator");
                bookDto = this.bookDtoRepository.findByIdOrNull(bookId, principal.getUser().getId());
                if (bookDto == null) break block4;
                BookDto bookDto2 = bookDto;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)bookDto2.getMedia().getMediaProfile(), (Object)"PDF")) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Book media type '" + bookDto2.getMedia().getMediaType() + "' not compatible with requested profile");
                }
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), bookDto2);
                WPPublicationDto wPPublicationDto = webPubGenerator.toManifestPdf(bookDto2, this.mediaRepository.findById(bookDto2.getId()), this.seriesMetadataRepository.findById(bookDto2.getSeriesId()));
                bookDto = wPPublicationDto;
                if (wPPublicationDto != null) break block5;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return bookDto;
    }

    @NotNull
    public WPPublicationDto getWebPubManifestDivinaInternal(@NotNull KomgaPrincipal principal, @NotNull String bookId, @NotNull WebPubGenerator webPubGenerator) {
        BookDto bookDto;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                Intrinsics.checkNotNullParameter((Object)webPubGenerator, (String)"webPubGenerator");
                bookDto = this.bookDtoRepository.findByIdOrNull(bookId, principal.getUser().getId());
                if (bookDto == null) break block2;
                BookDto bookDto2 = bookDto;
                boolean bl = false;
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), bookDto2);
                WPPublicationDto wPPublicationDto = webPubGenerator.toManifestDivina(bookDto2, this.mediaRepository.findById(bookDto2.getId()), this.seriesMetadataRepository.findById(bookDto2.getSeriesId()));
                bookDto = wPPublicationDto;
                if (wPPublicationDto != null) break block3;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return bookDto;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public ResponseEntity<byte[]> getBookPageInternal(@NotNull String bookId, int pageNumber, @Nullable String convertTo, @NotNull ServletWebRequest request, @NotNull KomgaPrincipal principal, @Nullable List<org.springframework.http.MediaType> acceptHeaders) {
        ResponseEntity responseEntity;
        Book book;
        block22: {
            ResponseEntity responseEntity2;
            org.springframework.http.MediaType it;
            Media media;
            Book book2;
            block21: {
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                book = this.bookRepository.findByIdOrNull(bookId);
                if (book == null) throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
                book2 = book;
                boolean bl = false;
                media = this.mediaRepository.findById(bookId);
                if (!request.checkNotModified(UtilsKt.getBookLastModified((Media)media))) break block21;
                ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_MODIFIED));
                Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder, (String)"status(...)");
                responseEntity = UtilsKt.setNotModified((ResponseEntity.BodyBuilder)bodyBuilder, (Media)media).body((Object)new byte[0]);
                break block22;
            }
            this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), book2);
            if (media.getProfile() == MediaProfile.PDF && acceptHeaders != null) {
                boolean bl;
                block20: {
                    Iterable $this$any$iv = acceptHeaders;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (org.springframework.http.MediaType)element$iv;
                            boolean bl2 = false;
                            if (!it.isCompatibleWith(org.springframework.http.MediaType.APPLICATION_PDF)) continue;
                            bl = true;
                            break block20;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    acceptHeaders.removeIf(arg_0 -> CommonBookController.getBookPageInternal$lambda$9$lambda$6(CommonBookController::getBookPageInternal$lambda$9$lambda$5, arg_0));
                    MimeTypeUtils.sortBySpecificity(acceptHeaders);
                    if (((org.springframework.http.MediaType)CollectionsKt.first(acceptHeaders)).isCompatibleWith(org.springframework.http.MediaType.APPLICATION_PDF)) {
                        return this.getBookPageRawInternal(book2, media, pageNumber);
                    }
                }
            }
            try {
                void $this$getBookPageInternal_u24lambda_u249_u24lambda_u247;
                ImageType imageType;
                block24: {
                    block23: {
                        String $i$f$any;
                        String string = convertTo;
                        if (string != null) {
                            String string2 = string.toLowerCase(Locale.ROOT);
                            v6 = string2;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        } else {
                            v6 = $i$f$any = null;
                        }
                        if ($i$f$any == null) break block23;
                        switch ($i$f$any.hashCode()) {
                            case 0: {
                                if (!$i$f$any.equals("")) {
                                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Invalid conversion format: " + convertTo);
                                }
                                break block23;
                            }
                            case 111145: {
                                if ($i$f$any.equals("png")) break;
                                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Invalid conversion format: " + convertTo);
                            }
                            case 3268712: {
                                if (!$i$f$any.equals("jpeg")) throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Invalid conversion format: " + convertTo);
                                imageType = ImageType.JPEG;
                                break block24;
                            }
                        }
                        imageType = ImageType.PNG;
                        break block24;
                    }
                    imageType = null;
                    break block24;
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Invalid conversion format: " + convertTo);
                }
                ImageType convertFormat = imageType;
                TypedBytes pageContent = BookLifecycle.getBookPage$default((BookLifecycle)this.bookLifecycle, (Book)book2, (int)pageNumber, (ImageType)convertFormat, null, (int)8, null);
                HttpHeaders httpHeaders = new HttpHeaders();
                it = httpHeaders;
                ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
                boolean bl = false;
                String string = this.contentDetector.mediaTypeToExtension(pageContent.getMediaType());
                if (string == null) {
                    string = "jpeg";
                }
                String extension = string;
                String imageFileName = book2.getName() + "-" + pageNumber + extension;
                $this$getBookPageInternal_u24lambda_u249_u24lambda_u247.setContentDisposition(ContentDisposition.builder((String)"inline").filename(imageFileName, StandardCharsets.UTF_8).build());
                ResponseEntity.BodyBuilder bodyBuilder2 = ((ResponseEntity.BodyBuilder)bodyBuilder.headers(httpHeaders)).contentType(org.gotson.komga.infrastructure.web.UtilsKt.getMediaTypeOrDefault((String)pageContent.getMediaType()));
                Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder2, (String)"contentType(...)");
                responseEntity2 = UtilsKt.setNotModified((ResponseEntity.BodyBuilder)bodyBuilder2, (Media)media).body((Object)pageContent.getBytes());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Page number does not exist");
            }
            catch (ImageConversionException ex) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, ex.getMessage());
            }
            catch (MediaNotReadyException mediaNotReadyException) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book analysis failed");
            }
            catch (NoSuchFileException ex) {
                CommonBookControllerKt.access$getLogger$p().warn((Throwable)ex, () -> CommonBookController.getBookPageInternal$lambda$9$lambda$8(book2));
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "File not found, it may have moved");
            }
            responseEntity = responseEntity2;
        }
        book = responseEntity;
        if (responseEntity != null) return book;
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @Operation(tags={"Book Pages"}, summary="Get raw book page", description="Returns the book page in raw format, without content negotiation.")
    @GetMapping(value={"api/v1/books/{bookId}/pages/{pageNumber}/raw", "opds/v2/books/{bookId}/pages/{pageNumber}/raw"}, produces={"*/*"})
    @PreAuthorize(value="hasRole('PAGE_STREAMING')")
    @NotNull
    public ResponseEntity<byte[]> getBookPageRawByNumber(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @NotNull ServletWebRequest request, @PathVariable @NotNull String bookId, @PathVariable int pageNumber) {
        Book book;
        block6: {
            block5: {
                ResponseEntity responseEntity;
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                book = this.bookRepository.findByIdOrNull(bookId);
                if (book == null) break block5;
                Book book2 = book;
                boolean bl = false;
                Media media = this.mediaRepository.findById(bookId);
                if (request.checkNotModified(UtilsKt.getBookLastModified((Media)media))) {
                    ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_MODIFIED));
                    Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder, (String)"status(...)");
                    ResponseEntity responseEntity2 = UtilsKt.setNotModified((ResponseEntity.BodyBuilder)bodyBuilder, (Media)media).body((Object)new byte[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"body(...)");
                    responseEntity = responseEntity2;
                } else {
                    this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), book2);
                    responseEntity = this.getBookPageRawInternal(book2, media, pageNumber);
                }
                book = responseEntity;
                if (responseEntity != null) break block6;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return book;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ResponseEntity<byte[]> getBookPageRawInternal(@NotNull Book book, @NotNull Media media, int pageNumber) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        try {
            void $this$getBookPageRawInternal_u24lambda_u2411;
            HttpHeaders httpHeaders;
            TypedBytes pageContent = this.bookAnalyzer.getPageContentRaw(new BookWithMedia(book, media), pageNumber);
            HttpHeaders httpHeaders2 = httpHeaders = new HttpHeaders();
            ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
            boolean bl = false;
            String string = this.contentDetector.mediaTypeToExtension(pageContent.getMediaType());
            if (string == null) {
                string = "";
            }
            String extension = string;
            String pageFileName = book.getName() + "-" + pageNumber + extension;
            $this$getBookPageRawInternal_u24lambda_u2411.setContentDisposition(ContentDisposition.builder((String)"inline").filename(pageFileName, StandardCharsets.UTF_8).build());
            ResponseEntity.BodyBuilder bodyBuilder2 = ((ResponseEntity.BodyBuilder)bodyBuilder.headers(httpHeaders)).contentType(org.gotson.komga.infrastructure.web.UtilsKt.getMediaTypeOrDefault((String)pageContent.getMediaType()));
            Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder2, (String)"contentType(...)");
            responseEntity = UtilsKt.setNotModified((ResponseEntity.BodyBuilder)bodyBuilder2, (Media)media).body((Object)pageContent.getBytes());
            Intrinsics.checkNotNull((Object)responseEntity);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Page number does not exist");
        }
        catch (MediaUnsupportedException ex) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage());
        }
        catch (MediaNotReadyException mediaNotReadyException) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Book analysis failed");
        }
        catch (NoSuchFileException ex) {
            CommonBookControllerKt.access$getLogger$p().warn((Throwable)ex, () -> CommonBookController.getBookPageRawInternal$lambda$12(book));
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "File not found, it may have moved");
        }
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Operation(tags={"WebPub Manifest"}, summary="Get Epub resource", description="Return a resource from within an Epub book.")
    @SecurityRequirements
    @GetMapping(value={"api/v1/books/{bookId}/resource/{*resource}", "opds/v2/books/{bookId}/resource/{*resource}"}, produces={"*/*"})
    @NotNull
    public ResponseEntity<byte[]> getBookEpubResource(@NotNull HttpServletRequest request, @AuthenticationPrincipal @Nullable KomgaPrincipal principal, @PathVariable @NotNull String bookId, @PathVariable @NotNull String resource) {
        void $this$getBookEpubResource_u24lambda_u2414;
        Object object;
        Object v6;
        Object element$iv2;
        Media media;
        Book book;
        String resourceName;
        block9: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            resourceName = StringsKt.removePrefix((String)resource, (CharSequence)"/");
            List list = CommonBookControllerKt.access$getFONT_EXTENSIONS$p();
            String string = FilenameUtils.getExtension((String)resourceName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            boolean isFont = list.contains(string2);
            if (!isFont && principal == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
            }
            Book book2 = this.bookRepository.findByIdOrNull(bookId);
            if (book2 == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            book = book2;
            media = this.mediaRepository.findById(book.getId());
            if (new ServletWebRequest(request).checkNotModified(UtilsKt.getBookLastModified((Media)media))) {
                String[] stringArray = new String[]{"script-src 'none'; object-src 'none';"};
                ResponseEntity.HeadersBuilder headersBuilder = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_MODIFIED)).header("Content-Security-Policy", stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)headersBuilder, (String)"header(...)");
                ResponseEntity responseEntity = UtilsKt.setNotModified((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)headersBuilder), (Media)media).body((Object)new byte[0]);
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
                return responseEntity;
            }
            if (media.getProfile() != MediaProfile.EPUB) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Book media type '" + media.getMediaType() + "' not compatible with requested profile");
            }
            if (!isFont) {
                KomgaPrincipal komgaPrincipal = principal;
                Intrinsics.checkNotNull((Object)komgaPrincipal);
                this.contentRestrictionChecker.checkContentRestriction(komgaPrincipal.getUser(), book);
            }
            Iterable $this$firstOrNull$iv = media.getFiles();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                MediaFile it = (MediaFile)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFileName(), (Object)resourceName)) continue;
                v6 = element$iv2;
                break block9;
            }
            v6 = null;
        }
        MediaFile mediaFile = v6;
        if (mediaFile == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        MediaFile res = mediaFile;
        try {
            object = this.bookAnalyzer.getFileContent(new BookWithMedia(book, media), resourceName);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        byte[] bytes = object;
        HttpHeaders httpHeaders = new HttpHeaders();
        element$iv2 = httpHeaders;
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
        boolean bl = false;
        $this$getBookEpubResource_u24lambda_u2414.setContentDisposition(ContentDisposition.builder((String)"inline").filename(FilenameUtils.getName((String)resourceName), StandardCharsets.UTF_8).build());
        $this$getBookEpubResource_u24lambda_u2414.set("Content-Security-Policy", "script-src 'none'; object-src 'none';");
        ResponseEntity.BodyBuilder bodyBuilder2 = ((ResponseEntity.BodyBuilder)bodyBuilder.headers(httpHeaders)).contentType(org.gotson.komga.infrastructure.web.UtilsKt.getMediaTypeOrDefault((String)res.getMediaType()));
        Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder2, (String)"contentType(...)");
        object = UtilsKt.setNotModified((ResponseEntity.BodyBuilder)bodyBuilder2, (Media)media).body((Object)bytes);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"body(...)");
        return object;
    }

    @Operation(tags={"Books"}, summary="Download book file", description="Download the book file.")
    @GetMapping(value={"api/v1/books/{bookId}/file", "api/v1/books/{bookId}/file/*", "opds/v1.2/books/{bookId}/file/*", "opds/v2/books/{bookId}/file", "opds/v2/books/{bookId}/file/*"}, produces={"application/octet-stream"})
    @PreAuthorize(value="hasRole('FILE_DOWNLOAD')")
    @NotNull
    public ResponseEntity<StreamingResponseBody> downloadBookFile(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return this.getBookFileInternal(principal, bookId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ResponseEntity<StreamingResponseBody> getBookFileInternal(@NotNull KomgaPrincipal principal, @NotNull String bookId) {
        Book book;
        block7: {
            block6: {
                ResponseEntity responseEntity;
                Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                book = this.bookRepository.findByIdOrNull(bookId);
                if (book == null) break block6;
                Book book2 = book;
                boolean bl = false;
                this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), book2);
                try {
                    void $this$getBookFileInternal_u24lambda_u2420_u24lambda_u2418_u24lambda_u2417;
                    HttpHeaders httpHeaders;
                    Media media = this.mediaRepository.findById(book2.getId());
                    FileSystemResource $this$getBookFileInternal_u24lambda_u2420_u24lambda_u2418 = new FileSystemResource(book2.getPath());
                    boolean bl2 = false;
                    if (!$this$getBookFileInternal_u24lambda_u2420_u24lambda_u2418.exists()) {
                        throw new FileNotFoundException($this$getBookFileInternal_u24lambda_u2420_u24lambda_u2418.getPath());
                    }
                    StreamingResponseBody stream = arg_0 -> CommonBookController.getBookFileInternal$lambda$20$lambda$18$lambda$16($this$getBookFileInternal_u24lambda_u2420_u24lambda_u2418, arg_0);
                    HttpHeaders httpHeaders2 = httpHeaders = new HttpHeaders();
                    ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
                    boolean bl3 = false;
                    $this$getBookFileInternal_u24lambda_u2420_u24lambda_u2418_u24lambda_u2417.setContentDisposition(ContentDisposition.builder((String)"attachment").filename(PathsKt.getName((Path)book2.getPath()), StandardCharsets.UTF_8).build());
                    responseEntity = ((ResponseEntity.BodyBuilder)bodyBuilder.headers(httpHeaders)).contentType(org.gotson.komga.infrastructure.web.UtilsKt.getMediaTypeOrDefault((String)media.getMediaType())).contentLength($this$getBookFileInternal_u24lambda_u2420_u24lambda_u2418.contentLength()).body((Object)stream);
                }
                catch (FileNotFoundException ex) {
                    CommonBookControllerKt.access$getLogger$p().warn((Throwable)ex, () -> CommonBookController.getBookFileInternal$lambda$20$lambda$19(book2));
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "File not found, it may have moved");
                }
                ResponseEntity responseEntity2 = responseEntity;
                book = responseEntity2;
                if (responseEntity2 != null) break block7;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return book;
    }

    @Operation(tags={"WebPub Manifest"}, summary="Get book progression", description="The Progression API is a proposed standard for OPDS 2 and Readium. It is used by the Epub Reader.")
    @GetMapping(value={"api/v1/books/{bookId}/progression", "opds/v2/books/{bookId}/progression"}, produces={"application/vnd.readium.progression+json"})
    @NotNull
    public ResponseEntity<R2Progression> getBookProgression(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId) {
        Book book;
        block7: {
            block4: {
                ReadProgress readProgress;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
                        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
                        book = this.bookRepository.findByIdOrNull(bookId);
                        if (book == null) break block4;
                        Book book2 = book;
                        boolean bl = false;
                        this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), book2);
                        readProgress = this.readProgressRepository.findByBookIdAndUserIdOrNull(bookId, principal.getUser().getId());
                        if (readProgress == null) break block5;
                        ReadProgress it = readProgress;
                        boolean bl2 = false;
                        ResponseEntity responseEntity = ResponseEntity.ok((Object)R2ProgressionKt.toR2Progression((ReadProgress)it));
                        readProgress = responseEntity;
                        if (responseEntity != null) break block6;
                    }
                    ResponseEntity responseEntity = ResponseEntity.noContent().build();
                    readProgress = responseEntity;
                    Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
                }
                book = readProgress;
                if (readProgress != null) break block7;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return book;
    }

    @Operation(tags={"WebPub Manifest"}, summary="Mark book progression", description="The Progression API is a proposed standard for OPDS 2 and Readium. It is used by the Epub Reader.")
    @PutMapping(value={"api/v1/books/{bookId}/progression", "opds/v2/books/{bookId}/progression"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateBookProgression(@AuthenticationPrincipal @NotNull KomgaPrincipal principal, @PathVariable @NotNull String bookId, @RequestBody @NotNull R2Progression progression) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)progression, (String)"progression");
        Book book = this.bookRepository.findByIdOrNull(bookId);
        if (book != null) {
            Book book2 = book;
            boolean bl = false;
            this.contentRestrictionChecker.checkContentRestriction(principal.getUser(), book2);
            try {
                this.bookLifecycle.markProgression(book2, principal.getUser(), progression);
            }
            catch (IllegalStateException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    private static final boolean getBookPageInternal$lambda$9$lambda$5(org.springframework.http.MediaType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isCompatibleWith(org.springframework.http.MediaType.APPLICATION_PDF) && !it.isCompatibleWith(new org.springframework.http.MediaType("image"));
    }

    private static final boolean getBookPageInternal$lambda$9$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object getBookPageInternal$lambda$9$lambda$8(Book $book) {
        return "File not found: " + $book;
    }

    private static final Object getBookPageRawInternal$lambda$12(Book $book) {
        return "File not found: " + $book;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void getBookFileInternal$lambda$20$lambda$18$lambda$16(FileSystemResource $this_with, OutputStream os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Closeable closeable = $this_with.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            IOUtils.copyLarge((InputStream)it, (OutputStream)os, (byte[])new byte[8192]);
            os.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Object getBookFileInternal$lambda$20$lambda$19(Book $book) {
        return "File not found: " + $book;
    }
}

