/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.api.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.gotson.komga.infrastructure.configuration.KomgaProperties;
import org.gotson.komga.interfaces.api.rest.FontsController;
import org.gotson.komga.interfaces.api.rest.FontsControllerKt;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"api/v1/fonts"}, produces={"application/json"})
@Tag(name="Fonts")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0017J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\b2\b\b\u0001\u0010\u0011\u001a\u00020\bH\u0017J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\bH\u0017J&\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u0012J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\bH\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gotson/komga/interfaces/api/rest/FontsController;", "", "komgaProperties", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;", "<init>", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;)V", "supportedExtensions", "", "", "fonts", "", "Lorg/springframework/core/io/Resource;", "getFonts", "", "getFontFile", "Lorg/springframework/http/ResponseEntity;", "fontFamily", "fontFile", "getFontFamilyAsCss", "buildFontFaceBlock", "styleAndWeight", "Lorg/gotson/komga/interfaces/api/rest/FontsController$FontCharacteristics;", "getFontCharacteristics", "filename", "FontCharacteristics", "komga"})
@SourceDebugExtension(value={"SMAP\nFontsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontsController.kt\norg/gotson/komga/interfaces/api/rest/FontsController\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,181:1\n4154#2:182\n4254#2,2:183\n774#3:185\n865#3,2:186\n1491#3:188\n1516#3,3:189\n1519#3,3:199\n774#3:202\n865#3,2:203\n1193#3,2:205\n1267#3,2:207\n774#3:209\n865#3,2:210\n774#3:212\n865#3,2:213\n774#3:215\n865#3,2:216\n1563#3:218\n1634#3,3:219\n1270#3:222\n295#3,2:223\n1491#3:225\n1516#3,3:226\n1519#3,3:236\n382#4,7:192\n382#4,7:229\n126#5:239\n153#5,3:240\n*S KotlinDebug\n*F\n+ 1 FontsController.kt\norg/gotson/komga/interfaces/api/rest/FontsController\n*L\n49#1:182\n49#1:183,2\n50#1:185\n50#1:186,2\n51#1:188\n51#1:189,3\n51#1:199,3\n65#1:202\n65#1:203,2\n66#1:205,2\n66#1:207,2\n70#1:209\n70#1:210,2\n71#1:212\n71#1:213,2\n72#1:215\n72#1:216,2\n73#1:218\n73#1:219,3\n66#1:222\n101#1:223,2\n123#1:225\n123#1:226,3\n123#1:236,3\n51#1:192,7\n123#1:229,7\n127#1:239\n127#1:240,3\n*E\n"})
public class FontsController {
    @NotNull
    private final List<String> supportedExtensions;
    @NotNull
    private final Map<String, List<Resource>> fonts;

    /*
     * WARNING - void declaration
     */
    public FontsController(@NotNull KomgaProperties komgaProperties) {
        Iterable answer$iv$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        Map map;
        Intrinsics.checkNotNullParameter((Object)komgaProperties, (String)"komgaProperties");
        Object[] objectArray = new String[]{"woff", "woff2", "ttf", "otf"};
        this.supportedExtensions = CollectionsKt.listOf((Object[])objectArray);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource it;
            Map $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Resource[] resourceArray = resolver.getResources("/embeddedFonts/**/*.*");
            Intrinsics.checkNotNullExpressionValue((Object)resourceArray, (String)"getResources(...)");
            Object[] objectArray2 = resourceArray;
            boolean $i$f$filterNot = false;
            map = $this$filterNot$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (void element$iv$iv : $this$filterNotTo$iv$iv) {
                Resource it2 = (Resource)element$iv$iv;
                boolean bl = false;
                if (it2.getFilename() == null) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterNotTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                it = (Resource)element$iv$iv;
                boolean bl = false;
                Iterable iterable = this.supportedExtensions;
                String string = FilenameUtils.getExtension((String)it.getURI().toString());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
                if (!LanguageUtilsKt.contains((Iterable)iterable, (String)string, (boolean)true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                it = (Resource)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = FilenameUtils.getName((String)FilenameUtils.getPathNoEndSeparator((String)it.getURI().toString()));
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
        }
        catch (Exception e) {
            FontsControllerKt.access$getLogger$p().error((Throwable)e, FontsController::_init_$lambda$3);
            $this$groupBy$iv = MapsKt.emptyMap();
        }
        Map fontsEmbedded = $this$groupBy$iv;
        Path path = Paths.get(komgaProperties.getFonts().getDataDirectory(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path fontsDir = path;
        try {
            Map map2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(fontsDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Files.isReadable(fontsDir)) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                $this$groupByTo$iv$iv = PathsKt.listDirectoryEntries$default((Path)fontsDir, null, (int)1, null);
                boolean $i$f$filter = false;
                void $i$f$groupByTo = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Path it = (Path)element$iv$iv;
                    boolean bl = false;
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Path it;
                    Iterable $this$filterTo$iv$iv2;
                    Iterable $this$filter$iv2;
                    Map map3 = destination$iv$iv2;
                    Path dir = (Path)element$iv$iv;
                    boolean bl = false;
                    answer$iv$iv$iv = PathsKt.listDirectoryEntries$default((Path)dir, null, (int)1, null);
                    String string = PathsKt.getName((Path)dir);
                    boolean $i$f$filter2 = false;
                    void var20_42 = $this$filter$iv2;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                        it = (Path)element$iv$iv2;
                        boolean bl3 = false;
                        LinkOption[] linkOptionArray3 = new LinkOption[]{};
                        if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) continue;
                        destination$iv$iv3.add(element$iv$iv2);
                    }
                    $this$filter$iv2 = (List)destination$iv$iv3;
                    $i$f$filter2 = false;
                    $this$filterTo$iv$iv2 = $this$filter$iv2;
                    destination$iv$iv3 = new ArrayList();
                    $i$f$filterTo2 = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                        it = (Path)element$iv$iv2;
                        boolean bl4 = false;
                        if (!Files.isReadable(it)) continue;
                        destination$iv$iv3.add(element$iv$iv2);
                    }
                    $this$filter$iv2 = (List)destination$iv$iv3;
                    $i$f$filter2 = false;
                    $this$filterTo$iv$iv2 = $this$filter$iv2;
                    destination$iv$iv3 = new ArrayList();
                    $i$f$filterTo2 = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                        it = (Path)element$iv$iv2;
                        boolean bl5 = false;
                        if (!LanguageUtilsKt.contains((Iterable)this.supportedExtensions, (String)PathsKt.getExtension((Path)it), (boolean)true)) continue;
                        destination$iv$iv3.add(element$iv$iv2);
                    }
                    $this$filter$iv2 = (List)destination$iv$iv3;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv2 = $this$map$iv;
                    destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Path)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl6 = false;
                        collection.add(new FileSystemResource(it));
                    }
                    Pair pair = TuplesKt.to((Object)string, (Object)((List)destination$iv$iv3));
                    map3.put(pair.getFirst(), pair.getSecond());
                }
                map2 = destination$iv$iv2;
            } else {
                map2 = MapsKt.emptyMap();
            }
            map = map2;
        }
        catch (Exception e) {
            FontsControllerKt.access$getLogger$p().error((Throwable)e, FontsController::_init_$lambda$10);
            map = MapsKt.emptyMap();
        }
        Map fontsAdditional = map;
        this.fonts = MapsKt.plus((Map)fontsEmbedded, (Map)fontsAdditional);
        FontsControllerKt.access$getLogger$p().info(() -> FontsController._init_$lambda$11(fontsEmbedded));
        FontsControllerKt.access$getLogger$p().info(() -> FontsController._init_$lambda$12(fontsAdditional));
    }

    @GetMapping(value={"families"})
    @Operation(summary="List font families", description="List all available font families.")
    @NotNull
    public Set<String> getFonts() {
        return this.fonts.keySet();
    }

    @GetMapping(value={"resource/{fontFamily}/{fontFile}"})
    @Operation(summary="Download font file")
    @SecurityRequirements
    @NotNull
    public ResponseEntity<Resource> getFontFile(@PathVariable @NotNull String fontFamily, @PathVariable @NotNull String fontFile) {
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        Intrinsics.checkNotNullParameter((Object)fontFile, (String)"fontFile");
        List list = (List)this.fonts.get(fontFamily);
        if (list != null) {
            Object v0;
            block3: {
                List resources = list;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = resources;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Resource it = (Resource)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFilename(), (Object)fontFile)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            Resource resource = v0;
            if (resource == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            Resource resource2 = resource;
            String string = FilenameUtils.getExtension((String)resource2.getURI().toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String mediaType = "font/" + string2;
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(arg_0 -> FontsController.getFontFile$lambda$15$lambda$14(fontFile, arg_0))).contentType(MediaType.parseMediaType((String)mediaType)).body((Object)resource2);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"resource/{fontFamily}/css"}, produces={"text/css"})
    @Operation(summary="Download CSS file", description="Download a CSS file with the @font-face block for the font family. This is used by the Epub Reader to change fonts.")
    @SecurityRequirements
    @NotNull
    public ResponseEntity<Resource> getFontFamilyAsCss(@PathVariable @NotNull String fontFamily) {
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        List list = (List)this.fonts.get(fontFamily);
        if (list != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map groups;
            void $this$groupByTo$iv$iv;
            List files = list;
            boolean bl = false;
            Iterable $this$groupBy$iv = files;
            boolean $i$f$groupBy22 = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                Resource it = (Resource)element$iv$iv;
                boolean bl2 = false;
                String string = FilenameUtils.getName((String)it.getURI().toString());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                FontCharacteristics key$iv$iv = this.getFontCharacteristics(string);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map $i$f$groupBy22 = groups = destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                FontCharacteristics styleWeight = (FontCharacteristics)entry.getKey();
                List resources = (List)entry.getValue();
                collection.add(this.buildFontFaceBlock(fontFamily, styleWeight, resources));
            }
            String css = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            ResponseEntity.BodyBuilder bodyBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(arg_0 -> FontsController.getFontFamilyAsCss$lambda$19$lambda$18(fontFamily, arg_0));
            byte[] byArray = css.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ResponseEntity responseEntity = bodyBuilder.body((Object)new ByteArrayResource(byArray));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    private String buildFontFaceBlock(String fontFamily, FontCharacteristics styleAndWeight, List<? extends Resource> fonts) {
        String srcBlock = CollectionsKt.joinToString$default((Iterable)fonts, (CharSequence)",", null, (CharSequence)";", (int)0, null, FontsController::buildFontFaceBlock$lambda$20, (int)26, null);
        return StringsKt.trimIndent((String)("\n      @font-face {\n          font-family: '" + fontFamily + "';\n          src: " + srcBlock + "\n          font-weight: " + styleAndWeight.getWeight() + ";\n          font-style: " + styleAndWeight.getStyle() + ";\n      }\n\n      "));
    }

    private FontCharacteristics getFontCharacteristics(String filename) {
        String style = StringsKt.contains((CharSequence)filename, (CharSequence)"italic", (boolean)true) ? "italic" : "normal";
        String weight = StringsKt.contains((CharSequence)filename, (CharSequence)"bold", (boolean)true) ? "bold" : "normal";
        return new FontCharacteristics(style, weight);
    }

    private static final Object _init_$lambda$3() {
        return "Could not load embedded fonts";
    }

    private static final Object _init_$lambda$10() {
        return "Could not load additional fonts";
    }

    private static final Object _init_$lambda$11(Map $fontsEmbedded) {
        return "Fonts embedded: " + $fontsEmbedded;
    }

    private static final Object _init_$lambda$12(Map $fontsAdditional) {
        return "Fonts discovered: " + $fontsAdditional;
    }

    private static final void getFontFile$lambda$15$lambda$14(String $fontFile, HttpHeaders it) {
        it.setContentDisposition(ContentDisposition.attachment().filename($fontFile).build());
    }

    private static final void getFontFamilyAsCss$lambda$19$lambda$18(String $fontFamily, HttpHeaders it) {
        it.setContentDisposition(ContentDisposition.attachment().filename($fontFamily + ".css").build());
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence buildFontFaceBlock$lambda$20(Resource resource) {
        void var3_2;
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        String filename = FilenameUtils.getName((String)resource.getURI().toString());
        String string = FilenameUtils.getExtension((String)resource.getURI().toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String extension = string2;
        String format = Intrinsics.areEqual((Object)extension, (Object)"ttf") ? "truetype" : (Intrinsics.areEqual((Object)extension, (Object)"otf") ? "opentype" : var3_2);
        return "url('" + filename + "') format('" + format + "')";
    }
}

