/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.interfaces.sse;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gotson.komga.application.tasks.TasksRepository;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.DomainEvent;
import org.gotson.komga.domain.model.KomgaUser;
import org.gotson.komga.domain.persistence.BookRepository;
import org.gotson.komga.infrastructure.security.KomgaPrincipal;
import org.gotson.komga.infrastructure.web.UtilsKt;
import org.gotson.komga.interfaces.sse.SseControllerKt;
import org.gotson.komga.interfaces.sse.dto.BookImportSseDto;
import org.gotson.komga.interfaces.sse.dto.BookSseDto;
import org.gotson.komga.interfaces.sse.dto.CollectionSseDto;
import org.gotson.komga.interfaces.sse.dto.LibrarySseDto;
import org.gotson.komga.interfaces.sse.dto.ReadListSseDto;
import org.gotson.komga.interfaces.sse.dto.ReadProgressSeriesSseDto;
import org.gotson.komga.interfaces.sse.dto.ReadProgressSseDto;
import org.gotson.komga.interfaces.sse.dto.SeriesSseDto;
import org.gotson.komga.interfaces.sse.dto.SessionExpiredDto;
import org.gotson.komga.interfaces.sse.dto.TaskQueueSseDto;
import org.gotson.komga.interfaces.sse.dto.ThumbnailBookSseDto;
import org.gotson.komga.interfaces.sse.dto.ThumbnailReadListSseDto;
import org.gotson.komga.interfaces.sse.dto.ThumbnailSeriesCollectionSseDto;
import org.gotson.komga.interfaces.sse.dto.ThumbnailSeriesSseDto;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0010\u001a\u00020\f2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J.\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\t2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0012J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\b\u0010 \u001a\u00020\u0014H\u0016J\b\u0010!\u001a\u00020\tH\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u000e\u00a2\u0006\u0002\n\u0000RN\u0010\n\u001aB\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r* \u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000f0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/gotson/komga/interfaces/sse/SseController;", "Lorg/springframework/context/SmartLifecycle;", "bookRepository", "Lorg/gotson/komga/domain/persistence/BookRepository;", "tasksRepository", "Lorg/gotson/komga/application/tasks/TasksRepository;", "<init>", "(Lorg/gotson/komga/domain/persistence/BookRepository;Lorg/gotson/komga/application/tasks/TasksRepository;)V", "acceptingConnections", "", "emitters", "", "Lorg/springframework/web/servlet/mvc/method/annotation/SseEmitter;", "kotlin.jvm.PlatformType", "Lorg/gotson/komga/domain/model/KomgaUser;", "", "sse", "principal", "Lorg/gotson/komga/infrastructure/security/KomgaPrincipal;", "taskCount", "", "handleSseEvent", "event", "Lorg/gotson/komga/domain/model/DomainEvent;", "emitSse", "name", "", "data", "", "adminOnly", "userIdOnly", "start", "stop", "isRunning", "getPhase", "", "komga"})
@SourceDebugExtension(value={"SMAP\nSseController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SseController.kt\norg/gotson/komga/interfaces/sse/SseController\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n126#2:151\n153#2,3:152\n126#2:155\n153#2,3:156\n126#2:159\n153#2,3:160\n216#2,2:177\n216#2,2:179\n536#3:163\n521#3,6:164\n536#3:170\n521#3,6:171\n1#4:181\n*S KotlinDebug\n*F\n+ 1 SseController.kt\norg/gotson/komga/interfaces/sse/SseController\n*L\n83#1:151\n83#1:152,3\n84#1:155\n84#1:156,3\n85#1:159\n85#1:160,3\n122#1:177,2\n142#1:179,2\n120#1:163\n120#1:164,6\n121#1:170\n121#1:171,6\n*E\n"})
public class SseController
implements SmartLifecycle {
    @NotNull
    private final BookRepository bookRepository;
    @NotNull
    private final TasksRepository tasksRepository;
    private boolean acceptingConnections;
    private final Map<SseEmitter, KomgaUser> emitters;

    public SseController(@NotNull BookRepository bookRepository, @NotNull TasksRepository tasksRepository) {
        Intrinsics.checkNotNullParameter((Object)bookRepository, (String)"bookRepository");
        Intrinsics.checkNotNullParameter((Object)tasksRepository, (String)"tasksRepository");
        this.bookRepository = bookRepository;
        this.tasksRepository = tasksRepository;
        this.acceptingConnections = true;
        this.emitters = Collections.synchronizedMap(new HashMap());
    }

    @GetMapping(value={"sse/v1/events"})
    @NotNull
    public SseEmitter sse(@AuthenticationPrincipal @NotNull KomgaPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        if (!this.acceptingConnections) {
            throw new IllegalStateException("Server is shutting down, not accepting new SSE connections");
        }
        SseEmitter emitter = new SseEmitter();
        emitter.onCompletion(() -> SseController.sse$lambda$1(this, emitter));
        emitter.onTimeout(() -> SseController.sse$lambda$3(this, emitter));
        emitter.onError(arg_0 -> SseController.sse$lambda$5(this, emitter, arg_0));
        Map map = this.emitters;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"emitters");
        Map map2 = map;
        KomgaUser komgaUser = principal.getUser();
        map2.put(emitter, komgaUser);
        return emitter;
    }

    @Scheduled(fixedRate=10000L)
    public void taskCount() {
        Map map = this.emitters;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"emitters");
        if (!map.isEmpty()) {
            Map tasksCount = this.tasksRepository.countBySimpleType();
            SseController.emitSse$default((SseController)this, (String)"TaskQueueStatus", (Object)new TaskQueueSseDto(CollectionsKt.sumOfInt((Iterable)tasksCount.values()), tasksCount), (boolean)true, null, (int)8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void handleSseEvent(@NotNull DomainEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DomainEvent domainEvent = event;
        if (domainEvent instanceof DomainEvent.LibraryAdded) {
            SseController.emitSse$default((SseController)this, (String)"LibraryAdded", (Object)new LibrarySseDto(((DomainEvent.LibraryAdded)event).getLibrary().getId()), (boolean)false, null, (int)12, null);
        } else if (domainEvent instanceof DomainEvent.LibraryUpdated) {
            SseController.emitSse$default((SseController)this, (String)"LibraryChanged", (Object)new LibrarySseDto(((DomainEvent.LibraryUpdated)event).getLibrary().getId()), (boolean)false, null, (int)12, null);
        } else if (domainEvent instanceof DomainEvent.LibraryDeleted) {
            SseController.emitSse$default((SseController)this, (String)"LibraryDeleted", (Object)new LibrarySseDto(((DomainEvent.LibraryDeleted)event).getLibrary().getId()), (boolean)false, null, (int)12, null);
        } else if (!(domainEvent instanceof DomainEvent.LibraryScanned)) {
            if (domainEvent instanceof DomainEvent.SeriesAdded) {
                SseController.emitSse$default((SseController)this, (String)"SeriesAdded", (Object)new SeriesSseDto(((DomainEvent.SeriesAdded)event).getSeries().getId(), ((DomainEvent.SeriesAdded)event).getSeries().getLibraryId()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.SeriesUpdated) {
                SseController.emitSse$default((SseController)this, (String)"SeriesChanged", (Object)new SeriesSseDto(((DomainEvent.SeriesUpdated)event).getSeries().getId(), ((DomainEvent.SeriesUpdated)event).getSeries().getLibraryId()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.SeriesDeleted) {
                SseController.emitSse$default((SseController)this, (String)"SeriesDeleted", (Object)new SeriesSseDto(((DomainEvent.SeriesDeleted)event).getSeries().getId(), ((DomainEvent.SeriesDeleted)event).getSeries().getLibraryId()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.BookAdded) {
                SseController.emitSse$default((SseController)this, (String)"BookAdded", (Object)new BookSseDto(((DomainEvent.BookAdded)event).getBook().getId(), ((DomainEvent.BookAdded)event).getBook().getSeriesId(), ((DomainEvent.BookAdded)event).getBook().getLibraryId()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.BookUpdated) {
                SseController.emitSse$default((SseController)this, (String)"BookChanged", (Object)new BookSseDto(((DomainEvent.BookUpdated)event).getBook().getId(), ((DomainEvent.BookUpdated)event).getBook().getSeriesId(), ((DomainEvent.BookUpdated)event).getBook().getLibraryId()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.BookDeleted) {
                SseController.emitSse$default((SseController)this, (String)"BookDeleted", (Object)new BookSseDto(((DomainEvent.BookDeleted)event).getBook().getId(), ((DomainEvent.BookDeleted)event).getBook().getSeriesId(), ((DomainEvent.BookDeleted)event).getBook().getLibraryId()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.BookImported) {
                Book book = ((DomainEvent.BookImported)event).getBook();
                SseController.emitSse$default((SseController)this, (String)"BookImported", (Object)new BookImportSseDto(book != null ? book.getId() : null, UtilsKt.toFilePath((URL)((DomainEvent.BookImported)event).getSourceFile()), ((DomainEvent.BookImported)event).getSuccess(), ((DomainEvent.BookImported)event).getMessage()), (boolean)true, null, (int)8, null);
            } else if (domainEvent instanceof DomainEvent.ReadListAdded) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map map = ((DomainEvent.ReadListAdded)event).getReadList().getBookIds();
                String string = ((DomainEvent.ReadListAdded)event).getReadList().getId();
                String string2 = "ReadListAdded";
                SseController sseController = this;
                boolean $i$f$map = false;
                void var5_18 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)it.getValue());
                }
                Collection<String> collection2 = collection = (List)destination$iv$iv;
                String string3 = string;
                SseController.emitSse$default((SseController)sseController, (String)string2, (Object)new ReadListSseDto(string3, (List)collection2), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.ReadListUpdated) {
                Collection<String> collection;
                Map $this$map$iv = ((DomainEvent.ReadListUpdated)event).getReadList().getBookIds();
                String string = ((DomainEvent.ReadListUpdated)event).getReadList().getId();
                String string4 = "ReadListChanged";
                SseController sseController = this;
                boolean $i$f$map = false;
                Map $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry it = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)it.getValue());
                }
                Collection<String> collection3 = collection = (List)destination$iv$iv;
                String string5 = string;
                SseController.emitSse$default((SseController)sseController, (String)string4, (Object)new ReadListSseDto(string5, (List)collection3), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.ReadListDeleted) {
                Collection<String> collection;
                Map $this$map$iv = ((DomainEvent.ReadListDeleted)event).getReadList().getBookIds();
                String string = ((DomainEvent.ReadListDeleted)event).getReadList().getId();
                String string6 = "ReadListDeleted";
                SseController sseController = this;
                boolean $i$f$map = false;
                Map $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry it = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)it.getValue());
                }
                Collection<String> collection4 = collection = (List)destination$iv$iv;
                String string7 = string;
                SseController.emitSse$default((SseController)sseController, (String)string6, (Object)new ReadListSseDto(string7, (List)collection4), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.CollectionAdded) {
                SseController.emitSse$default((SseController)this, (String)"CollectionAdded", (Object)new CollectionSseDto(((DomainEvent.CollectionAdded)event).getCollection().getId(), ((DomainEvent.CollectionAdded)event).getCollection().getSeriesIds()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.CollectionUpdated) {
                SseController.emitSse$default((SseController)this, (String)"CollectionChanged", (Object)new CollectionSseDto(((DomainEvent.CollectionUpdated)event).getCollection().getId(), ((DomainEvent.CollectionUpdated)event).getCollection().getSeriesIds()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.CollectionDeleted) {
                SseController.emitSse$default((SseController)this, (String)"CollectionDeleted", (Object)new CollectionSseDto(((DomainEvent.CollectionDeleted)event).getCollection().getId(), ((DomainEvent.CollectionDeleted)event).getCollection().getSeriesIds()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.ReadProgressChanged) {
                SseController.emitSse$default((SseController)this, (String)"ReadProgressChanged", (Object)new ReadProgressSseDto(((DomainEvent.ReadProgressChanged)event).getProgress().getBookId(), ((DomainEvent.ReadProgressChanged)event).getProgress().getUserId()), (boolean)false, (String)((DomainEvent.ReadProgressChanged)event).getProgress().getUserId(), (int)4, null);
            } else if (domainEvent instanceof DomainEvent.ReadProgressDeleted) {
                SseController.emitSse$default((SseController)this, (String)"ReadProgressDeleted", (Object)new ReadProgressSseDto(((DomainEvent.ReadProgressDeleted)event).getProgress().getBookId(), ((DomainEvent.ReadProgressDeleted)event).getProgress().getUserId()), (boolean)false, (String)((DomainEvent.ReadProgressDeleted)event).getProgress().getUserId(), (int)4, null);
            } else if (domainEvent instanceof DomainEvent.ReadProgressSeriesChanged) {
                SseController.emitSse$default((SseController)this, (String)"ReadProgressSeriesChanged", (Object)new ReadProgressSeriesSseDto(((DomainEvent.ReadProgressSeriesChanged)event).getSeriesId(), ((DomainEvent.ReadProgressSeriesChanged)event).getUserId()), (boolean)false, (String)((DomainEvent.ReadProgressSeriesChanged)event).getUserId(), (int)4, null);
            } else if (domainEvent instanceof DomainEvent.ReadProgressSeriesDeleted) {
                SseController.emitSse$default((SseController)this, (String)"ReadProgressSeriesDeleted", (Object)new ReadProgressSeriesSseDto(((DomainEvent.ReadProgressSeriesDeleted)event).getSeriesId(), ((DomainEvent.ReadProgressSeriesDeleted)event).getUserId()), (boolean)false, (String)((DomainEvent.ReadProgressSeriesDeleted)event).getUserId(), (int)4, null);
            } else if (domainEvent instanceof DomainEvent.ThumbnailBookAdded) {
                String string = ((DomainEvent.ThumbnailBookAdded)event).getThumbnail().getBookId();
                String string8 = this.bookRepository.getSeriesIdOrNull(((DomainEvent.ThumbnailBookAdded)event).getThumbnail().getBookId());
                if (string8 == null) {
                    string8 = "";
                }
                SseController.emitSse$default((SseController)this, (String)"ThumbnailBookAdded", (Object)new ThumbnailBookSseDto(string, string8, ((DomainEvent.ThumbnailBookAdded)event).getThumbnail().getSelected()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.ThumbnailBookDeleted) {
                String string = ((DomainEvent.ThumbnailBookDeleted)event).getThumbnail().getBookId();
                String string9 = this.bookRepository.getSeriesIdOrNull(((DomainEvent.ThumbnailBookDeleted)event).getThumbnail().getBookId());
                if (string9 == null) {
                    string9 = "";
                }
                SseController.emitSse$default((SseController)this, (String)"ThumbnailBookDeleted", (Object)new ThumbnailBookSseDto(string, string9, ((DomainEvent.ThumbnailBookDeleted)event).getThumbnail().getSelected()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.ThumbnailSeriesAdded) {
                SseController.emitSse$default((SseController)this, (String)"ThumbnailSeriesAdded", (Object)new ThumbnailSeriesSseDto(((DomainEvent.ThumbnailSeriesAdded)event).getThumbnail().getSeriesId(), ((DomainEvent.ThumbnailSeriesAdded)event).getThumbnail().getSelected()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.ThumbnailSeriesDeleted) {
                SseController.emitSse$default((SseController)this, (String)"ThumbnailSeriesDeleted", (Object)new ThumbnailSeriesSseDto(((DomainEvent.ThumbnailSeriesDeleted)event).getThumbnail().getSeriesId(), ((DomainEvent.ThumbnailSeriesDeleted)event).getThumbnail().getSelected()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.ThumbnailSeriesCollectionAdded) {
                SseController.emitSse$default((SseController)this, (String)"ThumbnailSeriesCollectionAdded", (Object)new ThumbnailSeriesCollectionSseDto(((DomainEvent.ThumbnailSeriesCollectionAdded)event).getThumbnail().getCollectionId(), ((DomainEvent.ThumbnailSeriesCollectionAdded)event).getThumbnail().getSelected()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.ThumbnailSeriesCollectionDeleted) {
                SseController.emitSse$default((SseController)this, (String)"ThumbnailSeriesCollectionDeleted", (Object)new ThumbnailSeriesCollectionSseDto(((DomainEvent.ThumbnailSeriesCollectionDeleted)event).getThumbnail().getCollectionId(), ((DomainEvent.ThumbnailSeriesCollectionDeleted)event).getThumbnail().getSelected()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.ThumbnailReadListAdded) {
                SseController.emitSse$default((SseController)this, (String)"ThumbnailReadListAdded", (Object)new ThumbnailReadListSseDto(((DomainEvent.ThumbnailReadListAdded)event).getThumbnail().getReadListId(), ((DomainEvent.ThumbnailReadListAdded)event).getThumbnail().getSelected()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.ThumbnailReadListDeleted) {
                SseController.emitSse$default((SseController)this, (String)"ThumbnailReadListDeleted", (Object)new ThumbnailReadListSseDto(((DomainEvent.ThumbnailReadListDeleted)event).getThumbnail().getReadListId(), ((DomainEvent.ThumbnailReadListDeleted)event).getThumbnail().getSelected()), (boolean)false, null, (int)12, null);
            } else if (domainEvent instanceof DomainEvent.UserUpdated) {
                if (((DomainEvent.UserUpdated)event).getExpireSession()) {
                    SseController.emitSse$default((SseController)this, (String)"SessionExpired", (Object)new SessionExpiredDto(((DomainEvent.UserUpdated)event).getUser().getId()), (boolean)false, (String)((DomainEvent.UserUpdated)event).getUser().getId(), (int)4, null);
                }
            } else if (domainEvent instanceof DomainEvent.UserDeleted) {
                SseController.emitSse$default((SseController)this, (String)"SessionExpired", (Object)new SessionExpiredDto(((DomainEvent.UserDeleted)event).getUser().getId()), (boolean)false, (String)((DomainEvent.UserDeleted)event).getUser().getId(), (int)4, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void emitSse(String name, Object data, boolean adminOnly, String userIdOnly) {
        SseControllerKt.access$getLogger$p().debug(() -> SseController.emitSse$lambda$9(name, data));
        Map map = this.emitters;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"emitters");
        Map map2 = map;
        synchronized (map2) {
            void $this$forEach$iv;
            Map.Entry it;
            Map.Entry element$iv$iv;
            Map $this$filterTo$iv$iv;
            Map $this$filter$iv;
            boolean bl = false;
            Map map3 = this.emitters;
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"emitters");
            Map map4 = map3;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                if (!(adminOnly ? ((KomgaUser)it.getValue()).isAdmin() : true)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$filterTo = false;
            iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv$iv = iterator2.next();
                boolean bl3 = false;
                if (!(userIdOnly != null ? Intrinsics.areEqual((Object)((KomgaUser)it.getValue()).getId(), (Object)userIdOnly) : true)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl4 = false;
                SseEmitter emitter = (SseEmitter)entry.getKey();
                try {
                    emitter.send(SseEmitter.event().name(name).data(data, MediaType.APPLICATION_JSON));
                }
                catch (IOException iOException) {
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* synthetic */ void emitSse$default(SseController sseController, String string, Object object, boolean bl, String string2, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: emitSse");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        sseController.emitSse(string, object, bl, string2);
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SseControllerKt.access$getLogger$p().debug(SseController::stop$lambda$14);
        this.acceptingConnections = false;
        Map map = this.emitters;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"emitters");
        Map map2 = map;
        synchronized (map2) {
            boolean bl = false;
            Map map3 = this.emitters;
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"emitters");
            Map $this$forEach$iv = map3;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                SseEmitter emitter = (SseEmitter)entry.getKey();
                emitter.complete();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public boolean isRunning() {
        return true;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sse$lambda$1(SseController this$0, SseEmitter $emitter) {
        Map map = this$0.emitters;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"emitters");
        Map map2 = map;
        synchronized (map2) {
            boolean bl = false;
            this$0.emitters.remove($emitter);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sse$lambda$3(SseController this$0, SseEmitter $emitter) {
        Map map = this$0.emitters;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"emitters");
        Map map2 = map;
        synchronized (map2) {
            boolean bl = false;
            this$0.emitters.remove($emitter);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sse$lambda$5(SseController this$0, SseEmitter $emitter, Throwable it) {
        Map map = this$0.emitters;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"emitters");
        Map map2 = map;
        synchronized (map2) {
            boolean bl = false;
            this$0.emitters.remove($emitter);
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Object emitSse$lambda$9(String $name, Object $data) {
        return "Publish SSE: '" + $name + "':" + $data;
    }

    private static final Object stop$lambda$14() {
        return "Closing all SSE connections";
    }
}

