/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.build.AbstractOriginSupplier;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.Dimension;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaContainerEntry;
import org.gotson.komga.domain.model.MediaExtension;
import org.gotson.komga.domain.model.MediaExtensionEpub;
import org.gotson.komga.domain.model.MediaFile;
import org.gotson.komga.domain.model.MediaNotReadyException;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.MediaType;
import org.gotson.komga.domain.model.MediaUnsupportedException;
import org.gotson.komga.domain.model.NoThumbnailFoundException;
import org.gotson.komga.domain.model.ThumbnailBook;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.domain.service.BookAnalyzerKt;
import org.gotson.komga.infrastructure.configuration.KomgaSettingsProvider;
import org.gotson.komga.infrastructure.hash.Hasher;
import org.gotson.komga.infrastructure.image.ImageAnalyzer;
import org.gotson.komga.infrastructure.image.ImageConverter;
import org.gotson.komga.infrastructure.image.ImageType;
import org.gotson.komga.infrastructure.mediacontainer.ContentDetector;
import org.gotson.komga.infrastructure.mediacontainer.divina.DivinaExtractor;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubExtractor;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubKt;
import org.gotson.komga.infrastructure.mediacontainer.epub.EpubPackage;
import org.gotson.komga.infrastructure.mediacontainer.epub.OpfKt;
import org.gotson.komga.infrastructure.mediacontainer.pdf.PdfExtractor;
import org.gotson.komga.infrastructure.util.ZipFileUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0001\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0001\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020$H\u0012J\u0018\u0010(\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0012J\u0018\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0012J\u0010\u0010*\u001a\u00020+2\u0006\u0010!\u001a\u00020,H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010!\u001a\u00020,H\u0016J\u0014\u0010-\u001a\u00020.*\u00020\u00062\u0006\u0010!\u001a\u00020,H\u0012J\u0018\u0010/\u001a\u0002002\u0006\u0010!\u001a\u00020,2\u0006\u00101\u001a\u00020\u0012H\u0016J\u0018\u00102\u001a\u00020.2\u0006\u0010!\u001a\u00020,2\u0006\u00101\u001a\u00020\u0012H\u0016J\u0018\u00103\u001a\u0002002\u0006\u0010!\u001a\u00020,2\u0006\u00104\u001a\u00020\u001cH\u0016J\u0010\u00105\u001a\u00020 2\u0006\u0010!\u001a\u00020,H\u0016J\u0018\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000200H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u0002080\u00052\u0006\u0010;\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00168\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00168\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00060\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006<"}, d2={"Lorg/gotson/komga/domain/service/BookAnalyzer;", "", "contentDetector", "Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;", "extractors", "", "Lorg/gotson/komga/infrastructure/mediacontainer/divina/DivinaExtractor;", "pdfExtractor", "Lorg/gotson/komga/infrastructure/mediacontainer/pdf/PdfExtractor;", "epubExtractor", "Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor;", "imageConverter", "Lorg/gotson/komga/infrastructure/image/ImageConverter;", "imageAnalyzer", "Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;", "hasher", "Lorg/gotson/komga/infrastructure/hash/Hasher;", "pageHashing", "", "komgaSettingsProvider", "Lorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;", "thumbnailType", "Lorg/gotson/komga/infrastructure/image/ImageType;", "pdfImageType", "<init>", "(Lorg/gotson/komga/infrastructure/mediacontainer/ContentDetector;Ljava/util/List;Lorg/gotson/komga/infrastructure/mediacontainer/pdf/PdfExtractor;Lorg/gotson/komga/infrastructure/mediacontainer/epub/EpubExtractor;Lorg/gotson/komga/infrastructure/image/ImageConverter;Lorg/gotson/komga/infrastructure/image/ImageAnalyzer;Lorg/gotson/komga/infrastructure/hash/Hasher;ILorg/gotson/komga/infrastructure/configuration/KomgaSettingsProvider;Lorg/gotson/komga/infrastructure/image/ImageType;Lorg/gotson/komga/infrastructure/image/ImageType;)V", "divinaExtractors", "", "", "getDivinaExtractors", "()Ljava/util/Map;", "analyze", "Lorg/gotson/komga/domain/model/Media;", "book", "Lorg/gotson/komga/domain/model/Book;", "analyzeDimensions", "", "analyzeDivina", "mediaType", "Lorg/gotson/komga/domain/model/MediaType;", "analyzeEpub", "analyzePdf", "generateThumbnail", "Lorg/gotson/komga/domain/model/ThumbnailBook;", "Lorg/gotson/komga/domain/model/BookWithMedia;", "getPoster", "Lorg/gotson/komga/domain/model/TypedBytes;", "getPageContent", "", "number", "getPageContentRaw", "getFileContent", "fileName", "hashPages", "hashPage", "page", "Lorg/gotson/komga/domain/model/BookPage;", "content", "getPdfPagesDynamic", "media", "komga"})
@SourceDebugExtension(value={"SMAP\nBookAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookAnalyzer.kt\norg/gotson/komga/domain/service/BookAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Epub.kt\norg/gotson/komga/infrastructure/mediacontainer/epub/EpubKt\n+ 5 ZipFileUtils.kt\norg/gotson/komga/infrastructure/util/ZipFileUtilsKt\n*L\n1#1,424:1\n1374#2:425\n1460#2,2:426\n1563#2:428\n1634#2,3:429\n1462#2,3:432\n3301#2,4:435\n3305#2,6:440\n1563#2:446\n1634#2,3:447\n774#2:450\n865#2,2:451\n1563#2:453\n1634#2,3:454\n1563#2:457\n1634#2,3:458\n3301#2,10:468\n1563#2:478\n1634#2,3:479\n1563#2:483\n1634#2,3:484\n1573#2:487\n1604#2,4:488\n1563#2:492\n1634#2,3:493\n1#3:439\n1#3:465\n21#4:461\n22#4,2:463\n24#4,2:466\n26#4:482\n8#5:462\n*S KotlinDebug\n*F\n+ 1 BookAnalyzer.kt\norg/gotson/komga/domain/service/BookAnalyzer\n*L\n57#1:425\n57#1:426,2\n57#1:428\n57#1:429,3\n57#1:432,3\n116#1:435,4\n116#1:440,6\n120#1:446\n120#1:447,3\n127#1:450\n127#1:451,2\n128#1:453\n128#1:454,3\n138#1:457\n138#1:458,3\n148#1:468,10\n202#1:478\n202#1:479,3\n236#1:483\n236#1:484,3\n377#1:487\n377#1:488,4\n416#1:492\n416#1:493,3\n147#1:465\n147#1:461\n147#1:463,2\n147#1:466,2\n147#1:482\n147#1:462\n*E\n"})
public class BookAnalyzer {
    @NotNull
    private final ContentDetector contentDetector;
    @NotNull
    private final PdfExtractor pdfExtractor;
    @NotNull
    private final EpubExtractor epubExtractor;
    @NotNull
    private final ImageConverter imageConverter;
    @NotNull
    private final ImageAnalyzer imageAnalyzer;
    @NotNull
    private final Hasher hasher;
    private final int pageHashing;
    @NotNull
    private final KomgaSettingsProvider komgaSettingsProvider;
    @Qualifier(value="thumbnailType")
    @NotNull
    private final ImageType thumbnailType;
    @Qualifier(value="pdfImageType")
    @NotNull
    private final ImageType pdfImageType;
    @NotNull
    private final Map<String, DivinaExtractor> divinaExtractors;

    /*
     * WARNING - void declaration
     */
    public BookAnalyzer(@NotNull ContentDetector contentDetector, @NotNull List<? extends DivinaExtractor> extractors, @NotNull PdfExtractor pdfExtractor, @NotNull EpubExtractor epubExtractor, @NotNull ImageConverter imageConverter, @NotNull ImageAnalyzer imageAnalyzer, @NotNull Hasher hasher, @Value(value="#{@komgaProperties.pageHashing}") int pageHashing, @NotNull KomgaSettingsProvider komgaSettingsProvider, @Qualifier(value="thumbnailType") @NotNull ImageType thumbnailType, @Qualifier(value="pdfImageType") @NotNull ImageType pdfImageType) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)contentDetector, (String)"contentDetector");
        Intrinsics.checkNotNullParameter(extractors, (String)"extractors");
        Intrinsics.checkNotNullParameter((Object)pdfExtractor, (String)"pdfExtractor");
        Intrinsics.checkNotNullParameter((Object)epubExtractor, (String)"epubExtractor");
        Intrinsics.checkNotNullParameter((Object)imageConverter, (String)"imageConverter");
        Intrinsics.checkNotNullParameter((Object)imageAnalyzer, (String)"imageAnalyzer");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        Intrinsics.checkNotNullParameter((Object)komgaSettingsProvider, (String)"komgaSettingsProvider");
        Intrinsics.checkNotNullParameter((Object)thumbnailType, (String)"thumbnailType");
        Intrinsics.checkNotNullParameter((Object)pdfImageType, (String)"pdfImageType");
        this.contentDetector = contentDetector;
        this.pdfExtractor = pdfExtractor;
        this.epubExtractor = epubExtractor;
        this.imageConverter = imageConverter;
        this.imageAnalyzer = imageAnalyzer;
        this.hasher = hasher;
        this.pageHashing = pageHashing;
        this.komgaSettingsProvider = komgaSettingsProvider;
        this.thumbnailType = thumbnailType;
        this.pdfImageType = pdfImageType;
        Iterable iterable = extractors;
        BookAnalyzer bookAnalyzer = this;
        boolean $i$f$flatMap = false;
        void var14_15 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            DivinaExtractor e = (DivinaExtractor)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = e.mediaTypes();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)it, (Object)e));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        bookAnalyzer.divinaExtractors = MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Map<String, DivinaExtractor> getDivinaExtractors() {
        return this.divinaExtractors;
    }

    @NotNull
    public Media analyze(@NotNull Book book, boolean analyzeDimensions) {
        Media media;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        BookAnalyzerKt.access$getLogger$p().info(() -> BookAnalyzer.analyze$lambda$2(book));
        try {
            String it = this.contentDetector.detectMediaType(book.getPath());
            boolean bl = false;
            BookAnalyzerKt.access$getLogger$p().info(() -> BookAnalyzer.analyze$lambda$4$lambda$3(it));
            MediaType mediaType = MediaType.Companion.fromMediaType(it);
            if (mediaType == null) {
                Media.Status status = Media.Status.UNSUPPORTED;
                String string = book.getId();
                return new Media(status, it, null, 0, null, "ERR_1001", null, string, false, false, null, null, 3932, null);
            }
            MediaType mediaType2 = mediaType;
            String string = PathsKt.getExtension((Path)book.getPath()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)string, (Object)"epub") && mediaType2 != MediaType.EPUB) {
                if (this.epubExtractor.isEpub(book.getPath())) {
                    mediaType2 = MediaType.EPUB;
                } else {
                    BookAnalyzerKt.access$getLogger$p().warn(() -> BookAnalyzer.analyze$lambda$5(book));
                    String string2 = mediaType2.getType();
                    Media.Status status = Media.Status.ERROR;
                    String string3 = book.getId();
                    return new Media(status, string2, null, 0, null, "ERR_1032", null, string3, false, false, null, null, 3932, null);
                }
            }
            media = Media.copy$default((Media)(switch (WhenMappings.$EnumSwitchMapping$0[mediaType2.getProfile().ordinal()]) {
                case 1 -> this.analyzeDivina(book, mediaType2, analyzeDimensions);
                case 2 -> this.analyzePdf(book, analyzeDimensions);
                case 3 -> this.analyzeEpub(book, analyzeDimensions);
                default -> throw new NoWhenBranchMatchedException();
            }), null, (String)mediaType2.getType(), null, (int)0, null, null, null, null, (boolean)false, (boolean)false, null, null, (int)4093, null);
        }
        catch (AccessDeniedException ade) {
            BookAnalyzerKt.access$getLogger$p().error((Throwable)ade, () -> BookAnalyzer.analyze$lambda$6(book));
            media = new Media(Media.Status.ERROR, null, null, 0, null, "ERR_1000", null, null, false, false, null, null, 4062, null);
        }
        catch (NoSuchFileException ex) {
            BookAnalyzerKt.access$getLogger$p().error((Throwable)ex, () -> BookAnalyzer.analyze$lambda$7(book));
            media = new Media(Media.Status.ERROR, null, null, 0, null, "ERR_1018", null, null, false, false, null, null, 4062, null);
        }
        catch (Exception ex) {
            BookAnalyzerKt.access$getLogger$p().error((Throwable)ex, () -> BookAnalyzer.analyze$lambda$8(book));
            media = new Media(Media.Status.ERROR, null, null, 0, null, "ERR_1005", null, null, false, false, null, null, 4062, null);
        }
        return Media.copy$default((Media)media, null, null, null, (int)0, null, null, null, (String)book.getId(), (boolean)false, (boolean)false, null, null, (int)3967, null);
    }

    /*
     * WARNING - void declaration
     */
    private Media analyzeDivina(Book book, MediaType mediaType, boolean analyzeDimensions) {
        String entriesErrorSummary;
        Collection collection;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv2;
        MediaContainerEntry entry;
        void $this$partition$iv;
        Object object;
        try {
            Object object2 = (DivinaExtractor)this.getDivinaExtractors().get(mediaType.getType());
            if (object2 == null || (object2 = object2.getEntries(book.getPath(), analyzeDimensions)) == null) {
                return new Media(Media.Status.UNSUPPORTED, null, null, 0, null, null, null, null, false, false, null, null, 4094, null);
            }
            object = object2;
        }
        catch (MediaUnsupportedException ex) {
            return new Media(Media.Status.UNSUPPORTED, null, null, 0, null, ex.getCode(), null, null, false, false, null, null, 4062, null);
        }
        catch (Exception ex) {
            BookAnalyzerKt.access$getLogger$p().error((Throwable)ex, () -> BookAnalyzer.analyzeDivina$lambda$9(book));
            return new Media(Media.Status.ERROR, null, null, 0, null, "ERR_1008", null, null, false, false, null, null, 4062, null);
        }
        Object entries = object;
        Iterable ex = (Iterable)entries;
        boolean $i$f$partition22 = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            boolean bl;
            entry = (MediaContainerEntry)element$iv;
            boolean bl2 = false;
            if (entry.getMediaType() != null) {
                String it;
                boolean bl3 = false;
                bl = this.contentDetector.isImage(it);
            } else {
                bl = false;
            }
            boolean bl4 = bl ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair $i$f$partition22 = new Pair(first$iv, second$iv);
        boolean bl = false;
        List images = (List)$i$f$partition22.component1();
        Iterable others = (List)$i$f$partition22.component2();
        Iterable $this$map$iv2 = images;
        boolean $i$f$map = false;
        Iterable bl3 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            MediaContainerEntry mediaContainerEntry = (MediaContainerEntry)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl5 = false;
            String string = it.getName();
            String string2 = it.getMediaType();
            Intrinsics.checkNotNull((Object)string2);
            collection3.add(new BookPage(string, string2, it.getDimension(), null, it.getFileSize(), 8, null));
        }
        List list = others;
        List list2 = (List)destination$iv$iv;
        object = new Pair((Object)list2, (Object)list);
        List pages = (List)object.component1();
        List others2 = (List)object.component2();
        others = others2;
        boolean $i$f$filter = false;
        entry = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MediaContainerEntry it = (MediaContainerEntry)element$iv$iv;
            boolean bl6 = false;
            CharSequence charSequence = it.getMediaType();
            boolean bl7 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
            if (!bl7) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MediaContainerEntry it = (MediaContainerEntry)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl8 = false;
            collection2.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv2;
        if ($this$map$iv.isEmpty()) {
            boolean bl9 = false;
            collection = null;
        } else {
            collection = $this$map$iv;
        }
        images = (List)collection;
        String string = entriesErrorSummary = images != null ? CollectionsKt.joinToString$default((Iterable)images, null, (CharSequence)"ERR_1007 [", (CharSequence)"]", (int)0, null, BookAnalyzer::analyzeDivina$lambda$17, (int)25, null) : null;
        if (pages.isEmpty()) {
            BookAnalyzerKt.access$getLogger$p().warn(() -> BookAnalyzer.analyzeDivina$lambda$18(book));
            return new Media(Media.Status.ERROR, null, null, 0, null, "ERR_1006", null, null, false, false, null, null, 4062, null);
        }
        BookAnalyzerKt.access$getLogger$p().info(() -> BookAnalyzer.analyzeDivina$lambda$19(pages));
        $this$map$iv = others2;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MediaContainerEntry it = (MediaContainerEntry)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl10 = false;
            collection2.add(new MediaFile(it.getName(), it.getMediaType(), null, it.getFileSize(), 4, null));
        }
        List files = (List)destination$iv$iv2;
        return new Media(Media.Status.READY, null, pages, pages.size(), files, entriesErrorSummary, null, null, false, false, null, null, 4034, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Media analyzeEpub(Book book, boolean analyzeDimensions) {
        Path $this$epub$iv = book.getPath();
        boolean $i$f$epub = false;
        AbstractOriginSupplier abstractOriginSupplier = ZipFile.builder().setPath($this$epub$iv);
        Intrinsics.checkNotNullExpressionValue((Object)abstractOriginSupplier, (String)"setPath(...)");
        ZipFile.Builder $this$use$iv$iv = (ZipFile.Builder)abstractOriginSupplier;
        boolean $i$f$use = false;
        Closeable closeable = (Closeable)$this$use$iv$iv.get();
        Throwable throwable = null;
        try {
            Object object;
            Iterable iterable;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list;
            List e4;
            List e22;
            List e32;
            Object element$iv2;
            InputStream inputStream;
            String opfFile$iv;
            ZipFile zip$iv;
            block31: {
                block30: {
                    Document document;
                    zip$iv = (ZipFile)closeable;
                    boolean bl = false;
                    opfFile$iv = EpubKt.getPackagePath((ZipFile)zip$iv);
                    inputStream = ZipFileUtilsKt.getEntryInputStream((ZipFile)zip$iv, (String)opfFile$iv);
                    if (inputStream == null) break block30;
                    Closeable closeable2 = inputStream;
                    Throwable throwable2 = null;
                    try {
                        InputStream it$iv = (InputStream)closeable2;
                        boolean bl2 = false;
                        Document document2 = Jsoup.parse((InputStream)it$iv, null, (String)"", (Parser)Parser.xmlParser());
                        document = document2;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    inputStream = document;
                    if (document != null) break block31;
                }
                throw new MediaUnsupportedException("Could not open OPF resource", null, 2, null);
            }
            InputStream opfDoc$iv = inputStream;
            Path opfDir$iv = Paths.get(opfFile$iv, new String[0]).getParent();
            EpubPackage epub = new EpubPackage(zip$iv, (Document)opfDoc$iv, opfDir$iv, OpfKt.getManifest((Document)opfDoc$iv));
            boolean bl = false;
            Iterable $this$partition$iv = this.epubExtractor.getResources(epub);
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv2 : $this$partition$iv) {
                MediaFile it = (MediaFile)element$iv2;
                boolean bl3 = false;
                boolean bl4 = it.getFileSize() != null ? first$iv.add(element$iv2) : second$iv.add(element$iv2);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List resources = (List)pair.component1();
            List missingResources = (List)pair.component2();
            boolean isKepub = this.epubExtractor.isKepub(epub, resources);
            List errors = new ArrayList();
            try {
                element$iv2 = this.epubExtractor.getToc(epub);
            }
            catch (Exception e32) {
                BookAnalyzerKt.access$getLogger$p().error((Throwable)e32, BookAnalyzer::analyzeEpub$lambda$31$lambda$22);
                errors.add("ERR_1035");
                element$iv2 = CollectionsKt.emptyList();
            }
            Object toc = element$iv2;
            try {
                e32 = this.epubExtractor.getLandmarks(epub);
            }
            catch (Exception e22) {
                BookAnalyzerKt.access$getLogger$p().error((Throwable)e22, BookAnalyzer::analyzeEpub$lambda$31$lambda$23);
                errors.add("ERR_1036");
                e32 = CollectionsKt.emptyList();
            }
            List landmarks = e32;
            try {
                e22 = this.epubExtractor.getPageList(epub);
            }
            catch (Exception e4) {
                BookAnalyzerKt.access$getLogger$p().error((Throwable)e4, BookAnalyzer::analyzeEpub$lambda$31$lambda$24);
                errors.add("ERR_1037");
                e22 = CollectionsKt.emptyList();
            }
            List pageList = e22;
            try {
                e4 = this.epubExtractor.getDivinaPages(epub, analyzeDimensions);
            }
            catch (Exception e5) {
                BookAnalyzerKt.access$getLogger$p().error((Throwable)e5, BookAnalyzer::analyzeEpub$lambda$31$lambda$25);
                errors.add("ERR_1038");
                e4 = CollectionsKt.emptyList();
            }
            List divinaPages = e4;
            boolean isFixedLayout = !((Collection)divinaPages).isEmpty() || this.epubExtractor.isFixedLayout(epub);
            try {
                list = this.epubExtractor.computePositions(epub, book.getPath(), resources, isFixedLayout, isKepub);
            }
            catch (Exception e6) {
                BookAnalyzerKt.access$getLogger$p().error((Throwable)e6, BookAnalyzer::analyzeEpub$lambda$31$lambda$26);
                errors.add("ERR_1039");
                list = CollectionsKt.emptyList();
            }
            List positions = list;
            Object object2 = missingResources;
            boolean $i$f$map = false;
            void var35_48 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MediaFile mediaFile = (MediaFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(it.getFileName());
            }
            object2 = (List)destination$iv$iv;
            if (object2.isEmpty()) {
                boolean bl6 = false;
                iterable = null;
            } else {
                iterable = object2;
            }
            List e6 = (List)iterable;
            String entriesErrorSummary = e6 != null ? CollectionsKt.joinToString$default((Iterable)e6, null, (CharSequence)"ERR_1033 [", (CharSequence)"]", (int)0, null, BookAnalyzer::analyzeEpub$lambda$31$lambda$29, (int)25, null) : null;
            object2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)errors, entriesErrorSummary)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            if (StringsKt.isBlank((CharSequence)object2)) {
                boolean bl7 = false;
                object = null;
            } else {
                object = object2;
            }
            String allErrors = (String)object;
            object2 = Media.Status.READY;
            int n = !((Collection)divinaPages).isEmpty() ? divinaPages.size() : this.epubExtractor.computePageCount(epub);
            boolean bl8 = !((Collection)divinaPages).isEmpty();
            MediaExtensionEpub mediaExtensionEpub = new MediaExtensionEpub(toc, landmarks, pageList, isFixedLayout, positions);
            Media media = new Media((Media.Status)object2, null, divinaPages, n, resources, allErrors, (MediaExtension)mediaExtensionEpub, null, bl8, isKepub, null, null, 3202, null);
            return media;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Media analyzePdf(Book book, boolean analyzeDimensions) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.pdfExtractor.getPages(book.getPath(), analyzeDimensions);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaContainerEntry mediaContainerEntry = (MediaContainerEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new BookPage(it.getName(), "", it.getDimension(), null, null, 24, null));
        }
        List pages = (List)destination$iv$iv;
        return new Media(Media.Status.READY, null, pages, 0, null, null, null, null, false, false, null, null, 4090, null);
    }

    @NotNull
    public ThumbnailBook generateThumbnail(@NotNull BookWithMedia book) throws MediaNotReadyException, NoThumbnailFoundException {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)book, (String)"book");
                BookAnalyzerKt.access$getLogger$p().info(() -> BookAnalyzer.generateThumbnail$lambda$33(book));
                if (book.getMedia().getStatus() != Media.Status.READY) {
                    BookAnalyzerKt.access$getLogger$p().warn(() -> BookAnalyzer.generateThumbnail$lambda$34(book));
                    throw new MediaNotReadyException();
                }
                object = this.getPoster(book);
                if (object == null) break block5;
                TypedBytes cover = object;
                boolean bl = false;
                byte[] byArray = this.imageConverter.resizeImageToByteArray(cover.getBytes(), this.thumbnailType, this.komgaSettingsProvider.getThumbnailSize().getMaxEdge());
                object = byArray;
                if (byArray != null) break block6;
            }
            throw new NoThumbnailFoundException();
        }
        Object thumbnail = object;
        ThumbnailBook.Type type = ThumbnailBook.Type.GENERATED;
        String string = book.getBook().getId();
        String string2 = this.thumbnailType.getMediaType();
        Dimension dimension = this.imageAnalyzer.getDimension((InputStream)new ByteArrayInputStream((byte[])thumbnail));
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        Dimension dimension2 = dimension;
        long l = ((TypedBytes)thumbnail).length;
        return new ThumbnailBook((byte[])thumbnail, null, false, type, string2, l, dimension2, null, string, null, null, 1670, null);
    }

    @Nullable
    public TypedBytes getPoster(@NotNull BookWithMedia book) {
        TypedBytes typedBytes;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        MediaProfile mediaProfile = book.getMedia().getProfile();
        switch (mediaProfile == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mediaProfile.ordinal()]) {
            case 1: {
                DivinaExtractor divinaExtractor = (DivinaExtractor)this.getDivinaExtractors().get(book.getMedia().getMediaType());
                if (divinaExtractor != null) {
                    typedBytes = this.getPoster(divinaExtractor, book);
                    break;
                }
                typedBytes = null;
                break;
            }
            case 2: {
                typedBytes = this.pdfExtractor.getPageContentAsImage(book.getBook().getPath(), 1);
                break;
            }
            case 3: {
                typedBytes = this.epubExtractor.getCover(book.getBook().getPath());
                if (typedBytes != null) break;
                if (book.getMedia().getEpubDivinaCompatible()) {
                    DivinaExtractor divinaExtractor = (DivinaExtractor)this.getDivinaExtractors().get(MediaType.ZIP.getType());
                    if (divinaExtractor != null) {
                        typedBytes = this.getPoster(divinaExtractor, book);
                        break;
                    }
                    typedBytes = null;
                    break;
                }
                typedBytes = null;
                break;
            }
            case -1: {
                typedBytes = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typedBytes;
    }

    private TypedBytes getPoster(DivinaExtractor $this$getPoster, BookWithMedia book) {
        byte[] it = $this$getPoster.getEntryStream(book.getBook().getPath(), ((BookPage)CollectionsKt.first((List)book.getMedia().getPages())).getFileName());
        boolean bl = false;
        return new TypedBytes(it, ((BookPage)CollectionsKt.first((List)book.getMedia().getPages())).getMediaType());
    }

    @NotNull
    public byte[] getPageContent(@NotNull BookWithMedia book, int number) throws MediaNotReadyException, IndexOutOfBoundsException {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        BookAnalyzerKt.access$getLogger$p().debug(() -> BookAnalyzer.getPageContent$lambda$37(number, book));
        if (book.getMedia().getStatus() != Media.Status.READY) {
            BookAnalyzerKt.access$getLogger$p().warn(BookAnalyzer::getPageContent$lambda$38);
            throw new MediaNotReadyException();
        }
        if (number > book.getMedia().getPageCount() || number <= 0) {
            BookAnalyzerKt.access$getLogger$p().error(() -> BookAnalyzer.getPageContent$lambda$39(number, book));
            throw new IndexOutOfBoundsException("Page " + number + " does not exist");
        }
        MediaProfile mediaProfile = book.getMedia().getProfile();
        return switch (mediaProfile == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mediaProfile.ordinal()]) {
            case 1 -> {
                Map v1 = this.getDivinaExtractors();
                String v2 = book.getMedia().getMediaType();
                Intrinsics.checkNotNull((Object)v2);
                yield ((DivinaExtractor)MapsKt.getValue((Map)v1, (Object)v2)).getEntryStream(book.getBook().getPath(), ((BookPage)book.getMedia().getPages().get(number - 1)).getFileName());
            }
            case 2 -> this.pdfExtractor.getPageContentAsImage(book.getBook().getPath(), number).getBytes();
            case 3 -> {
                if (book.getMedia().getEpubDivinaCompatible()) {
                    yield this.epubExtractor.getEntryStream(book.getBook().getPath(), ((BookPage)book.getMedia().getPages().get(number - 1)).getFileName());
                }
                throw new MediaUnsupportedException("Epub profile does not support getting page content", null, 2, null);
            }
            case -1 -> throw new MediaNotReadyException();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public TypedBytes getPageContentRaw(@NotNull BookWithMedia book, int number) throws MediaNotReadyException, IndexOutOfBoundsException {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        BookAnalyzerKt.access$getLogger$p().debug(() -> BookAnalyzer.getPageContentRaw$lambda$40(number, book));
        if (book.getMedia().getProfile() != MediaProfile.PDF) {
            throw new MediaUnsupportedException("Extractor does not support raw extraction of pages", null, 2, null);
        }
        if (book.getMedia().getStatus() != Media.Status.READY) {
            BookAnalyzerKt.access$getLogger$p().warn(BookAnalyzer::getPageContentRaw$lambda$41);
            throw new MediaNotReadyException();
        }
        if (number > book.getMedia().getPageCount() || number <= 0) {
            BookAnalyzerKt.access$getLogger$p().error(() -> BookAnalyzer.getPageContentRaw$lambda$42(number, book));
            throw new IndexOutOfBoundsException("Page " + number + " does not exist");
        }
        return this.pdfExtractor.getPageContentAsPdf(book.getBook().getPath(), number);
    }

    @NotNull
    public byte[] getFileContent(@NotNull BookWithMedia book, @NotNull String fileName) throws MediaNotReadyException {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        BookAnalyzerKt.access$getLogger$p().debug(() -> BookAnalyzer.getFileContent$lambda$43(fileName, book));
        if (book.getMedia().getStatus() != Media.Status.READY) {
            BookAnalyzerKt.access$getLogger$p().warn(BookAnalyzer::getFileContent$lambda$44);
            throw new MediaNotReadyException();
        }
        MediaProfile mediaProfile = book.getMedia().getProfile();
        return switch (mediaProfile == null ? -1 : WhenMappings.$EnumSwitchMapping$0[mediaProfile.ordinal()]) {
            case 1 -> {
                Map v1 = this.getDivinaExtractors();
                String v2 = book.getMedia().getMediaType();
                Intrinsics.checkNotNull((Object)v2);
                yield ((DivinaExtractor)MapsKt.getValue((Map)v1, (Object)v2)).getEntryStream(book.getBook().getPath(), fileName);
            }
            case 3 -> this.epubExtractor.getEntryStream(book.getBook().getPath(), fileName);
            case -1, 2 -> throw new MediaUnsupportedException("Extractor does not support extraction of files", null, 2, null);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Media hashPages(@NotNull BookWithMedia book) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Iterable $this$mapIndexed$iv = book.getMedia().getPages();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            BookPage bookPage;
            void index;
            void bookPage2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BookPage bookPage3 = (BookPage)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)bookPage2.getFileHash()) && (index < this.pageHashing || index >= book.getMedia().getPageCount() - this.pageHashing)) {
                byte[] content = this.getPageContent(book, (int)(index + true));
                String hash = this.hashPage((BookPage)bookPage2, content);
                bookPage = BookPage.copy$default((BookPage)bookPage2, null, null, null, (String)hash, null, (int)23, null);
            } else {
                bookPage = bookPage2;
            }
            collection.add(bookPage);
        }
        List hashedPages = (List)destination$iv$iv;
        return Media.copy$default((Media)book.getMedia(), null, null, (List)hashedPages, (int)0, null, null, null, null, (boolean)false, (boolean)false, null, null, (int)4091, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String hashPage(@NotNull BookPage page, @NotNull byte[] content) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (Intrinsics.areEqual((Object)page.getMediaType(), (Object)ImageType.JPEG.getMediaType())) {
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                ByteArrayOutputStream buffer = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                ImageIO.write((RenderedImage)ImageIO.read(new ByteArrayInputStream(content)), ImageType.JPEG.getImageIOFormat(), buffer);
                byte[] byArray2 = buffer.toByteArray();
                byArray = byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            byArray = content;
        }
        byte[] bytes = byArray;
        Intrinsics.checkNotNull((Object)bytes);
        return this.hasher.computeHash((InputStream)new ByteArrayInputStream(bytes));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<BookPage> getPdfPagesDynamic(@NotNull Media media) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        if (media.getProfile() != MediaProfile.PDF) {
            throw new MediaUnsupportedException("Cannot get synthetic pages for non-PDF media", null, 2, null);
        }
        Iterable $this$map$iv = media.getPages();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Dimension dimension;
            void page;
            BookPage bookPage = (BookPage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = page;
            String string = null;
            String string2 = this.pdfImageType.getMediaType();
            if (page.getDimension() != null) {
                void it;
                String string3 = string2;
                String string4 = string;
                void var14_14 = v0;
                boolean bl2 = false;
                Dimension dimension2 = this.pdfExtractor.scaleDimension((Dimension)it);
                v0 = var14_14;
                string = string4;
                string2 = string3;
                dimension = dimension2;
            } else {
                dimension = null;
            }
            collection.add(BookPage.copy$default((BookPage)v0, string, (String)string2, dimension, null, null, (int)25, null));
        }
        return (List)destination$iv$iv;
    }

    private static final Object analyze$lambda$2(Book $book) {
        return "Trying to analyze book: " + $book;
    }

    private static final Object analyze$lambda$4$lambda$3(String $it) {
        return "Detected media type: " + $it;
    }

    private static final Object analyze$lambda$5(Book $book) {
        return "Epub file is malformed, file is probably broken: " + $book.getPath();
    }

    private static final Object analyze$lambda$6(Book $book) {
        return "Error while analyzing book: " + $book;
    }

    private static final Object analyze$lambda$7(Book $book) {
        return "Error while analyzing book: " + $book;
    }

    private static final Object analyze$lambda$8(Book $book) {
        return "Error while analyzing book: " + $book;
    }

    private static final Object analyzeDivina$lambda$9(Book $book) {
        return "Error while analyzing book: " + $book;
    }

    private static final CharSequence analyzeDivina$lambda$17(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final Object analyzeDivina$lambda$18(Book $book) {
        return "Book " + $book + " does not contain any pages";
    }

    private static final Object analyzeDivina$lambda$19(List $pages) {
        return "Book has " + $pages.size() + " pages";
    }

    private static final Object analyzeEpub$lambda$31$lambda$22() {
        return "Error while getting EPUB TOC";
    }

    private static final Object analyzeEpub$lambda$31$lambda$23() {
        return "Error while getting EPUB Landmarks";
    }

    private static final Object analyzeEpub$lambda$31$lambda$24() {
        return "Error while getting EPUB page list";
    }

    private static final Object analyzeEpub$lambda$31$lambda$25() {
        return "Error while getting EPUB Divina pages";
    }

    private static final Object analyzeEpub$lambda$31$lambda$26() {
        return "Error while getting EPUB positions";
    }

    private static final CharSequence analyzeEpub$lambda$31$lambda$29(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final Object generateThumbnail$lambda$33(BookWithMedia $book) {
        return "Generate thumbnail for book: " + $book;
    }

    private static final Object generateThumbnail$lambda$34(BookWithMedia $book) {
        return "Book media is not ready, cannot generate thumbnail. Book: " + $book;
    }

    private static final Object getPageContent$lambda$37(int $number, BookWithMedia $book) {
        return "Get page #" + $number + " for book: " + $book;
    }

    private static final Object getPageContent$lambda$38() {
        return "Book media is not ready, cannot get pages";
    }

    private static final Object getPageContent$lambda$39(int $number, BookWithMedia $book) {
        return "Page number #" + $number + " is out of bounds. Book has " + $book.getMedia().getPageCount() + " pages";
    }

    private static final Object getPageContentRaw$lambda$40(int $number, BookWithMedia $book) {
        return "Get raw page #" + $number + " for book: " + $book;
    }

    private static final Object getPageContentRaw$lambda$41() {
        return "Book media is not ready, cannot get pages";
    }

    private static final Object getPageContentRaw$lambda$42(int $number, BookWithMedia $book) {
        return "Page number #" + $number + " is out of bounds. Book has " + $book.getMedia().getPageCount() + " pages";
    }

    private static final Object getFileContent$lambda$43(String $fileName, BookWithMedia $book) {
        return "Get file " + $fileName + " for book: " + $book;
    }

    private static final Object getFileContent$lambda$44() {
        return "Book media is not ready, cannot get files";
    }
}

