/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.domain.service;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.Book;
import org.gotson.komga.domain.model.BookMetadataPatch;
import org.gotson.komga.domain.model.BookMetadataPatchCapability;
import org.gotson.komga.domain.model.BookPage;
import org.gotson.komga.domain.model.BookWithMedia;
import org.gotson.komga.domain.model.Library;
import org.gotson.komga.domain.model.Media;
import org.gotson.komga.domain.model.MediaNotReadyException;
import org.gotson.komga.domain.model.MediaProfile;
import org.gotson.komga.domain.model.PathContainedInPath;
import org.gotson.komga.domain.model.SearchCondition;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.domain.model.SearchOperator;
import org.gotson.komga.domain.model.Series;
import org.gotson.komga.domain.model.TransientBook;
import org.gotson.komga.domain.model.TransientBookKt;
import org.gotson.komga.domain.model.TypedBytes;
import org.gotson.komga.domain.persistence.LibraryRepository;
import org.gotson.komga.domain.persistence.SeriesRepository;
import org.gotson.komga.domain.persistence.TransientBookRepository;
import org.gotson.komga.domain.service.BookAnalyzer;
import org.gotson.komga.domain.service.FileSystemScanner;
import org.gotson.komga.infrastructure.image.ImageType;
import org.gotson.komga.infrastructure.metadata.BookMetadataProvider;
import org.gotson.komga.infrastructure.metadata.SeriesMetadataFromBookProvider;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J \u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lorg/gotson/komga/domain/service/TransientBookLifecycle;", "", "transientBookRepository", "Lorg/gotson/komga/domain/persistence/TransientBookRepository;", "bookAnalyzer", "Lorg/gotson/komga/domain/service/BookAnalyzer;", "fileSystemScanner", "Lorg/gotson/komga/domain/service/FileSystemScanner;", "libraryRepository", "Lorg/gotson/komga/domain/persistence/LibraryRepository;", "pdfImageType", "Lorg/gotson/komga/infrastructure/image/ImageType;", "seriesRepository", "Lorg/gotson/komga/domain/persistence/SeriesRepository;", "seriesMetadataProviders", "", "Lorg/gotson/komga/infrastructure/metadata/SeriesMetadataFromBookProvider;", "bookMetadataProviders", "Lorg/gotson/komga/infrastructure/metadata/BookMetadataProvider;", "<init>", "(Lorg/gotson/komga/domain/persistence/TransientBookRepository;Lorg/gotson/komga/domain/service/BookAnalyzer;Lorg/gotson/komga/domain/service/FileSystemScanner;Lorg/gotson/komga/domain/persistence/LibraryRepository;Lorg/gotson/komga/infrastructure/image/ImageType;Lorg/gotson/komga/domain/persistence/SeriesRepository;Ljava/util/List;Ljava/util/List;)V", "getBookMetadataProviders", "()Ljava/util/List;", "scanAndPersist", "Lorg/gotson/komga/domain/model/TransientBook;", "filePath", "", "analyzeAndPersist", "transientBook", "getMetadata", "Lkotlin/Pair;", "", "getBookPage", "Lorg/gotson/komga/domain/model/TypedBytes;", "number", "", "komga"})
@SourceDebugExtension(value={"SMAP\nTransientBookLifecycle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransientBookLifecycle.kt\norg/gotson/komga/domain/service/TransientBookLifecycle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n774#2:116\n865#2,2:117\n1869#2,2:119\n1563#2:121\n1634#2,3:122\n1374#2:126\n1460#2,5:127\n1563#2:132\n1634#2,3:133\n1563#2:136\n1634#2,3:137\n1#3:125\n*S KotlinDebug\n*F\n+ 1 TransientBookLifecycle.kt\norg/gotson/komga/domain/service/TransientBookLifecycle\n*L\n37#1:116\n37#1:117,2\n42#1:119,2\n51#1:121\n51#1:122,3\n73#1:126\n73#1:127,5\n82#1:132\n82#1:133,3\n87#1:136\n87#1:137,3\n*E\n"})
public class TransientBookLifecycle {
    @NotNull
    private final TransientBookRepository transientBookRepository;
    @NotNull
    private final BookAnalyzer bookAnalyzer;
    @NotNull
    private final FileSystemScanner fileSystemScanner;
    @NotNull
    private final LibraryRepository libraryRepository;
    @Qualifier(value="pdfImageType")
    @NotNull
    private final ImageType pdfImageType;
    @NotNull
    private final SeriesRepository seriesRepository;
    @NotNull
    private final List<SeriesMetadataFromBookProvider> seriesMetadataProviders;
    @NotNull
    private final List<BookMetadataProvider> bookMetadataProviders;

    /*
     * WARNING - void declaration
     */
    public TransientBookLifecycle(@NotNull TransientBookRepository transientBookRepository, @NotNull BookAnalyzer bookAnalyzer, @NotNull FileSystemScanner fileSystemScanner, @NotNull LibraryRepository libraryRepository, @Qualifier(value="pdfImageType") @NotNull ImageType pdfImageType, @NotNull SeriesRepository seriesRepository, @NotNull List<? extends SeriesMetadataFromBookProvider> seriesMetadataProviders, @NotNull List<? extends BookMetadataProvider> bookMetadataProviders) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)transientBookRepository, (String)"transientBookRepository");
        Intrinsics.checkNotNullParameter((Object)bookAnalyzer, (String)"bookAnalyzer");
        Intrinsics.checkNotNullParameter((Object)fileSystemScanner, (String)"fileSystemScanner");
        Intrinsics.checkNotNullParameter((Object)libraryRepository, (String)"libraryRepository");
        Intrinsics.checkNotNullParameter((Object)pdfImageType, (String)"pdfImageType");
        Intrinsics.checkNotNullParameter((Object)seriesRepository, (String)"seriesRepository");
        Intrinsics.checkNotNullParameter(seriesMetadataProviders, (String)"seriesMetadataProviders");
        Intrinsics.checkNotNullParameter(bookMetadataProviders, (String)"bookMetadataProviders");
        this.transientBookRepository = transientBookRepository;
        this.bookAnalyzer = bookAnalyzer;
        this.fileSystemScanner = fileSystemScanner;
        this.libraryRepository = libraryRepository;
        this.pdfImageType = pdfImageType;
        this.seriesRepository = seriesRepository;
        this.seriesMetadataProviders = seriesMetadataProviders;
        Iterable iterable = bookMetadataProviders;
        TransientBookLifecycle transientBookLifecycle = this;
        boolean $i$f$filter = false;
        void var11_12 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BookMetadataProvider it = (BookMetadataProvider)element$iv$iv;
            boolean bl = false;
            if (!it.getCapabilities().contains(BookMetadataPatchCapability.NUMBER_SORT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        transientBookLifecycle.bookMetadataProviders = (List)destination$iv$iv;
    }

    @NotNull
    public List<BookMetadataProvider> getBookMetadataProviders() {
        return this.bookMetadataProviders;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TransientBook> scanAndPersist(@NotNull String filePath) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Path folderToScan = Paths.get(filePath, new String[0]);
        Iterable $this$forEach$iv = this.libraryRepository.findAll();
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Library library = (Library)element$iv2;
            boolean bl = false;
            if (!folderToScan.startsWith(library.getPath())) continue;
            throw new PathContainedInPath("Cannot scan folder that is part of an existing library", "ERR_1017");
        }
        Intrinsics.checkNotNull((Object)folderToScan);
        Iterable $i$f$forEach22 = CollectionsKt.flatten((Iterable)FileSystemScanner.scanRootFolder$default((FileSystemScanner)this.fileSystemScanner, (Path)folderToScan, (boolean)false, null, (boolean)false, (boolean)false, (boolean)false, null, (int)126, null).getSeries().values());
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Book book = (Book)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TransientBook((Book)it, new Media(null, null, null, 0, null, null, null, null, false, false, null, null, 4095, null), null, 4, null));
        }
        List books = (List)destination$iv$iv;
        this.transientBookRepository.save((Collection)books);
        return books;
    }

    @NotNull
    public TransientBook analyzeAndPersist(@NotNull TransientBook transientBook) {
        Intrinsics.checkNotNullParameter((Object)transientBook, (String)"transientBook");
        Media media = this.bookAnalyzer.analyze(transientBook.getBook(), true);
        Pair pair = this.getMetadata(TransientBook.copy$default((TransientBook)transientBook, null, (Media)media, null, (int)5, null));
        String seriesId = (String)pair.component1();
        Float number = (Float)pair.component2();
        TransientBook updated = TransientBook.copy$default((TransientBook)transientBook, null, (Media)media, (TransientBook.Metadata)new TransientBook.Metadata(number, seriesId), (int)1, null);
        this.transientBookRepository.save(updated);
        return updated;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Pair<String, Float> getMetadata(@NotNull TransientBook transientBook) {
        Series series;
        Series series2;
        Iterator iterator;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object;
        BookWithMedia bookWithMedia;
        block17: {
            Intrinsics.checkNotNullParameter((Object)transientBook, (String)"transientBook");
            bookWithMedia = TransientBookKt.toBookWithMedia((TransientBook)transientBook);
            for (Object it : (Iterable)this.getBookMetadataProviders()) {
                boolean bl = false;
                BookMetadataPatch bookMetadataPatch = it.getBookMetadataFromBook(bookWithMedia);
                it = bookMetadataPatch != null ? bookMetadataPatch.getNumberSort() : null;
                if (it == null) continue;
                object = it;
                break block17;
            }
            object = null;
        }
        Object number = object;
        Iterable iterable = this.seriesMetadataProviders;
        boolean $i$f$flatMap = false;
        void bl = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String string;
            List list;
            CharSequence charSequence;
            SeriesMetadataFromBookProvider it = (SeriesMetadataFromBookProvider)element$iv$iv;
            boolean bl2 = false;
            iterator = CollectionsKt.createListBuilder();
            List $this$getMetadata_u24lambda_u247_u24lambda_u246 = iterator;
            boolean bl3 = false;
            if (it.getSupportsAppendVolume()) {
                String string2;
                List list2 = $this$getMetadata_u24lambda_u247_u24lambda_u246;
                Object object2 = it.getSeriesMetadataFromBook(bookWithMedia, true);
                if (object2 != null && (object2 = object2.getTitle()) != null) {
                    CharSequence charSequence2;
                    charSequence = (CharSequence)object2;
                    if (StringsKt.isBlank((CharSequence)charSequence)) {
                        list = list2;
                        boolean bl4 = false;
                        charSequence2 = null;
                        list2 = list;
                    } else {
                        charSequence2 = charSequence;
                    }
                    string2 = (String)charSequence2;
                } else {
                    string2 = null;
                }
                list2.add(string2);
            }
            List list3 = $this$getMetadata_u24lambda_u247_u24lambda_u246;
            Object object3 = it.getSeriesMetadataFromBook(bookWithMedia, false);
            if (object3 != null && (object3 = object3.getTitle()) != null) {
                CharSequence charSequence3;
                charSequence = (CharSequence)object3;
                if (StringsKt.isBlank((CharSequence)charSequence)) {
                    list = list3;
                    boolean bl5 = false;
                    charSequence3 = null;
                    list3 = list;
                } else {
                    charSequence3 = charSequence;
                }
                string = (String)charSequence3;
            } else {
                string = null;
            }
            list3.add(string);
            Iterable list$iv$iv = CollectionsKt.build((List)((Object)iterator));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List seriesNamesFromMetadata = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        if (!((Collection)seriesNamesFromMetadata).isEmpty()) {
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = seriesNamesFromMetadata;
            boolean $i$f$map = false;
            Iterable $i$f$flatMapTo2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                iterator = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl6 = false;
                collection.add(new SearchCondition.Title((SearchOperator.StringOp)new SearchOperator.Is((Object)it)));
            }
            List list = (List)destination$iv$iv2;
            SearchCondition.AnyOfSeries exactSearch = new SearchCondition.AnyOfSeries(list);
            SearchCondition.Series series3 = (SearchCondition.Series)exactSearch;
            SearchContext searchContext = SearchContext.Companion.ofAnonymousUser();
            Pageable pageable = Pageable.unpaged();
            Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged(...)");
            Page exactMatches = this.seriesRepository.findAll(series3, searchContext, pageable);
            if (!exactMatches.isEmpty()) {
                List list4 = exactMatches.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getContent(...)");
                series2 = (Series)CollectionsKt.first((List)list4);
            } else {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = seriesNamesFromMetadata;
                boolean $i$f$map2 = false;
                Iterable $i$f$mapTo2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    String bl3 = (String)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl7 = false;
                    collection.add(new SearchCondition.Title((SearchOperator.StringOp)new SearchOperator.Contains((String)it)));
                }
                List list5 = (List)destination$iv$iv3;
                SearchCondition.AnyOfSeries containsSearch = new SearchCondition.AnyOfSeries(list5);
                SearchCondition.Series series4 = (SearchCondition.Series)containsSearch;
                SearchContext searchContext2 = SearchContext.Companion.ofAnonymousUser();
                Pageable pageable2 = Pageable.unpaged();
                Intrinsics.checkNotNullExpressionValue((Object)pageable2, (String)"unpaged(...)");
                List list6 = this.seriesRepository.findAll(series4, searchContext2, pageable2).getContent();
                Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"getContent(...)");
                series2 = (Series)CollectionsKt.firstOrNull((List)list6);
            }
        } else {
            series2 = null;
        }
        Series series5 = series = series2;
        return TuplesKt.to((Object)(series5 != null ? series5.getId() : null), (Object)number);
    }

    @NotNull
    public TypedBytes getBookPage(@NotNull TransientBook transientBook, int number) throws MediaNotReadyException, IndexOutOfBoundsException {
        Intrinsics.checkNotNullParameter((Object)transientBook, (String)"transientBook");
        byte[] pageContent = this.bookAnalyzer.getPageContent(TransientBookKt.toBookWithMedia((TransientBook)transientBook), number);
        String pageMediaType = transientBook.getMedia().getProfile() == MediaProfile.PDF ? this.pdfImageType.getMediaType() : ((BookPage)transientBook.getMedia().getPages().get(number - 1)).getMediaType();
        return new TypedBytes(pageContent, pageMediaType);
    }
}

