/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.configuration;

import jakarta.annotation.PostConstruct;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gotson.komga.domain.model.ConfigurationException;
import org.gotson.komga.infrastructure.configuration.ConfigurationCheckerKt;
import org.gotson.komga.infrastructure.configuration.KomgaProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0012J\u001a\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gotson/komga/infrastructure/configuration/ConfigurationChecker;", "", "komgaProperties", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;", "<init>", "(Lorg/gotson/komga/infrastructure/configuration/KomgaProperties;)V", "blockTypes", "", "", "checkDatabasesPath", "", "checkDatabaseIsLocal", "database", "Lorg/gotson/komga/infrastructure/configuration/KomgaProperties$Database;", "ignoreProp", "checkIfRemote", "path", "Ljava/nio/file/Path;", "komga"})
@SourceDebugExtension(value={"SMAP\nConfigurationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationChecker.kt\norg/gotson/komga/infrastructure/configuration/ConfigurationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1761#2,3:68\n*S KotlinDebug\n*F\n+ 1 ConfigurationChecker.kt\norg/gotson/komga/infrastructure/configuration/ConfigurationChecker\n*L\n56#1:68,3\n*E\n"})
public class ConfigurationChecker {
    @NotNull
    private final KomgaProperties komgaProperties;
    @NotNull
    private final List<String> blockTypes;

    public ConfigurationChecker(@NotNull KomgaProperties komgaProperties) {
        Intrinsics.checkNotNullParameter((Object)komgaProperties, (String)"komgaProperties");
        this.komgaProperties = komgaProperties;
        Object[] objectArray = new String[]{"cifs", "nfs"};
        this.blockTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    @PostConstruct
    public void checkDatabasesPath() {
        this.checkDatabaseIsLocal(this.komgaProperties.getDatabase(), "komga.database.check-local-filesystem: false");
        this.checkDatabaseIsLocal(this.komgaProperties.getTasksDb(), "komga.tasks-db.check-local-filesystem: false");
    }

    private void checkDatabaseIsLocal(KomgaProperties.Database database, String ignoreProp) {
        if (database.getCheckLocalFilesystem()) {
            Path path;
            try {
                Path path2 = Paths.get(database.getFile(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                path = path2;
            }
            catch (Exception exception) {
                return;
            }
            Path path3 = path;
            this.checkIfRemote(path3, ignoreProp);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                this.checkIfRemote(path3.getParent(), ignoreProp);
            }
        }
    }

    private void checkIfRemote(Path path, String ignoreProp) {
        if (path == null) {
            return;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl;
            String storeType;
            block8: {
                String string;
                try {
                    String string2 = Files.getFileStore(path).type();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type(...)");
                    String string3 = string2.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    string = string3;
                }
                catch (Exception e) {
                    ConfigurationCheckerKt.access$getLogger$p().warn((Throwable)e, () -> ConfigurationChecker.checkIfRemote$lambda$0(path));
                    string = "unknown";
                }
                storeType = string;
                Iterable $this$any$iv = this.blockTypes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith((String)storeType, (String)it, (boolean)true)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                String errorMessage = "The path '" + path + "' should be on a local filesystem, but was detected to be on a remote filesystem (" + storeType + "). If this is inaccurate you can set '" + ignoreProp + "' to ignore this check.";
                ConfigurationCheckerKt.access$getLogger$p().error(() -> ConfigurationChecker.checkIfRemote$lambda$2(errorMessage));
                throw new ConfigurationException(errorMessage);
            }
            ConfigurationCheckerKt.access$getLogger$p().debug(() -> ConfigurationChecker.checkIfRemote$lambda$3(storeType, path));
        }
    }

    private static final Object checkIfRemote$lambda$0(Path $path) {
        return "Could not get FileStore type for path: " + $path;
    }

    private static final Object checkIfRemote$lambda$2(String $errorMessage) {
        return $errorMessage;
    }

    private static final Object checkIfRemote$lambda$3(String $storeType, Path $path) {
        return "FileStore type: " + $storeType + ", path: " + $path;
    }
}

