/*
 * Decompiled with CFR 0.152.
 */
package org.gotson.komga.infrastructure.jooq.main;

import java.io.Closeable;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import org.gotson.komga.domain.model.BookSearch;
import org.gotson.komga.domain.model.ContentRestrictions;
import org.gotson.komga.domain.model.ReadList;
import org.gotson.komga.domain.model.SearchContext;
import org.gotson.komga.infrastructure.jooq.BookSearchHelper;
import org.gotson.komga.infrastructure.jooq.RequiredJoin;
import org.gotson.komga.infrastructure.jooq.SplitDslDaoBase;
import org.gotson.komga.infrastructure.jooq.TempTable;
import org.gotson.komga.infrastructure.jooq.UtilsKt;
import org.gotson.komga.infrastructure.jooq.main.BookCommonDao;
import org.gotson.komga.infrastructure.search.LuceneEntity;
import org.gotson.komga.infrastructure.search.LuceneHelper;
import org.gotson.komga.interfaces.api.persistence.BookDtoRepository;
import org.gotson.komga.interfaces.api.rest.dto.AuthorDto;
import org.gotson.komga.interfaces.api.rest.dto.BookDto;
import org.gotson.komga.interfaces.api.rest.dto.BookMetadataDto;
import org.gotson.komga.interfaces.api.rest.dto.MediaDto;
import org.gotson.komga.interfaces.api.rest.dto.ReadProgressDto;
import org.gotson.komga.interfaces.api.rest.dto.WebLinkDto;
import org.gotson.komga.jooq.main.Tables;
import org.gotson.komga.jooq.main.tables.Book;
import org.gotson.komga.jooq.main.tables.BookMetadata;
import org.gotson.komga.jooq.main.tables.BookMetadataAuthor;
import org.gotson.komga.jooq.main.tables.BookMetadataLink;
import org.gotson.komga.jooq.main.tables.BookMetadataTag;
import org.gotson.komga.jooq.main.tables.Media;
import org.gotson.komga.jooq.main.tables.ReadProgress;
import org.gotson.komga.jooq.main.tables.ReadlistBook;
import org.gotson.komga.jooq.main.tables.SeriesMetadata;
import org.gotson.komga.jooq.main.tables.records.BookMetadataAuthorRecord;
import org.gotson.komga.jooq.main.tables.records.BookMetadataLinkRecord;
import org.gotson.komga.jooq.main.tables.records.BookMetadataRecord;
import org.gotson.komga.jooq.main.tables.records.BookMetadataTagRecord;
import org.gotson.komga.jooq.main.tables.records.BookRecord;
import org.gotson.komga.jooq.main.tables.records.MediaRecord;
import org.gotson.komga.jooq.main.tables.records.ReadProgressRecord;
import org.gotson.komga.language.LanguageUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectForUpdateStep;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectSeekStep1;
import org.jooq.SelectSeekStepN;
import org.jooq.SortField;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.H\u0016J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010/\u001a\u0002002\u0006\u0010-\u001a\u00020.H\u0016J&\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u00101\u001a\u0002022\u0006\u0010/\u001a\u0002002\u0006\u0010-\u001a\u00020.H\u0016J>\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020(2\u0006\u0010-\u001a\u00020.2\b\u00106\u001a\u0004\u0018\u00010(2\f\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0012J\u001a\u0010:\u001a\u0004\u0018\u00010,2\u0006\u0010;\u001a\u00020(2\u0006\u00105\u001a\u00020(H\u0016J\u001a\u0010<\u001a\u0004\u0018\u00010,2\u0006\u0010;\u001a\u00020(2\u0006\u00105\u001a\u00020(H\u0016J\u001a\u0010=\u001a\u0004\u0018\u00010,2\u0006\u0010;\u001a\u00020(2\u0006\u00105\u001a\u00020(H\u0016J:\u0010>\u001a\u0004\u0018\u00010,2\u0006\u0010?\u001a\u00020@2\u0006\u0010;\u001a\u00020(2\u0006\u00105\u001a\u00020(2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010B2\u0006\u0010C\u001a\u00020DH\u0016J:\u0010E\u001a\u0004\u0018\u00010,2\u0006\u0010?\u001a\u00020@2\u0006\u0010;\u001a\u00020(2\u0006\u00105\u001a\u00020(2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010B2\u0006\u0010C\u001a\u00020DH\u0016J6\u0010F\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u00105\u001a\u00020(2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010B2\u0006\u0010-\u001a\u00020.2\u0006\u0010C\u001a\u00020DH\u0016J\u001e\u0010G\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u00105\u001a\u00020(2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010H\u001a\u0002042\u0006\u00105\u001a\u00020(H\u0012J\"\u0010I\u001a\u0004\u0018\u00010,2\u0006\u0010;\u001a\u00020(2\u0006\u00105\u001a\u00020(2\u0006\u0010J\u001a\u00020KH\u0012JB\u0010L\u001a\u0004\u0018\u00010,2\u0006\u0010?\u001a\u00020@2\u0006\u0010;\u001a\u00020(2\u0006\u00105\u001a\u00020(2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010B2\u0006\u0010C\u001a\u00020D2\u0006\u0010J\u001a\u00020KH\u0012J*\u0010M\u001a\b\u0012\u0004\u0012\u00020O0N*\u00020\u00042\u0006\u00105\u001a\u00020(2\u000e\b\u0002\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0012J \u0010P\u001a\b\u0012\u0004\u0012\u00020,0Q*\b\u0012\u0004\u0012\u00020O0R2\u0006\u0010S\u001a\u00020\u0004H\u0012J.\u0010T\u001a\u00020,*\u00020U2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\b\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010\\\u001a\u00020(H\u0012J\f\u0010T\u001a\u00020W*\u00020]H\u0012J6\u0010T\u001a\u00020Y*\u00020^2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020a0`2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020(082\f\u0010c\u001a\b\u0012\u0004\u0012\u00020d0`H\u0012J\f\u0010T\u001a\u00020[*\u00020eH\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u00120\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u00140\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0010*\u0004\u0018\u00010\u00160\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0010*\u0004\u0018\u00010\u00180\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u0010*\u0004\u0018\u00010\u001a0\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u0010*\u0004\u0018\u00010\u001c0\u001cX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u0010*\u0004\u0018\u00010\u001e0\u001eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n \u0010*\u0004\u0018\u00010 0 X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010!\u001a\u0011\u0012\r\u0012\u000b\u0012\u0002\b\u00030#\u00a2\u0006\u0002\b$0\"X\u0092\u0004\u00a2\u0006\u0004\n\u0002\u0010%RB\u0010&\u001a6\u0012\u0004\u0012\u00020(\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \u0010*\u0004\u0018\u00010)0) \u0010*\u0014\u0012\u000e\b\u0001\u0012\n \u0010*\u0004\u0018\u00010)0)\u0018\u00010#0#0'X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lorg/gotson/komga/infrastructure/jooq/main/BookDtoDao;", "Lorg/gotson/komga/infrastructure/jooq/SplitDslDaoBase;", "Lorg/gotson/komga/interfaces/api/persistence/BookDtoRepository;", "dslRW", "Lorg/jooq/DSLContext;", "dslRO", "luceneHelper", "Lorg/gotson/komga/infrastructure/search/LuceneHelper;", "batchSize", "", "bookCommonDao", "Lorg/gotson/komga/infrastructure/jooq/main/BookCommonDao;", "<init>", "(Lorg/jooq/DSLContext;Lorg/jooq/DSLContext;Lorg/gotson/komga/infrastructure/search/LuceneHelper;ILorg/gotson/komga/infrastructure/jooq/main/BookCommonDao;)V", "b", "Lorg/gotson/komga/jooq/main/tables/Book;", "kotlin.jvm.PlatformType", "m", "Lorg/gotson/komga/jooq/main/tables/Media;", "d", "Lorg/gotson/komga/jooq/main/tables/BookMetadata;", "r", "Lorg/gotson/komga/jooq/main/tables/ReadProgress;", "a", "Lorg/gotson/komga/jooq/main/tables/BookMetadataAuthor;", "sd", "Lorg/gotson/komga/jooq/main/tables/SeriesMetadata;", "rlb", "Lorg/gotson/komga/jooq/main/tables/ReadlistBook;", "bt", "Lorg/gotson/komga/jooq/main/tables/BookMetadataTag;", "bl", "Lorg/gotson/komga/jooq/main/tables/BookMetadataLink;", "onDeckFields", "", "Lorg/jooq/Field;", "Lkotlin/jvm/internal/EnhancedNullability;", "[Lorg/jooq/Field;", "sorts", "", "", "", "findAll", "Lorg/springframework/data/domain/Page;", "Lorg/gotson/komga/interfaces/api/rest/dto/BookDto;", "pageable", "Lorg/springframework/data/domain/Pageable;", "context", "Lorg/gotson/komga/domain/model/SearchContext;", "search", "Lorg/gotson/komga/domain/model/BookSearch;", "conditions", "Lorg/jooq/Condition;", "userId", "searchTerm", "joins", "", "Lorg/gotson/komga/infrastructure/jooq/RequiredJoin;", "findByIdOrNull", "bookId", "findPreviousInSeriesOrNull", "findNextInSeriesOrNull", "findPreviousInReadListOrNull", "readList", "Lorg/gotson/komga/domain/model/ReadList;", "filterOnLibraryIds", "", "restrictions", "Lorg/gotson/komga/domain/model/ContentRestrictions;", "findNextInReadListOrNull", "findAllOnDeck", "findAllDuplicates", "readProgressCondition", "findSiblingSeries", "next", "", "findSiblingReadList", "selectBase", "Lorg/jooq/SelectOnConditionStep;", "Lorg/jooq/Record;", "fetchAndMap", "", "Lorg/jooq/ResultQuery;", "dsl", "toDto", "Lorg/gotson/komga/jooq/main/tables/records/BookRecord;", "media", "Lorg/gotson/komga/interfaces/api/rest/dto/MediaDto;", "metadata", "Lorg/gotson/komga/interfaces/api/rest/dto/BookMetadataDto;", "readProgress", "Lorg/gotson/komga/interfaces/api/rest/dto/ReadProgressDto;", "seriesTitle", "Lorg/gotson/komga/jooq/main/tables/records/MediaRecord;", "Lorg/gotson/komga/jooq/main/tables/records/BookMetadataRecord;", "authors", "", "Lorg/gotson/komga/interfaces/api/rest/dto/AuthorDto;", "tags", "links", "Lorg/gotson/komga/interfaces/api/rest/dto/WebLinkDto;", "Lorg/gotson/komga/jooq/main/tables/records/ReadProgressRecord;", "komga"})
@SourceDebugExtension(value={"SMAP\nBookDtoDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookDtoDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookDtoDao\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,555:1\n1#2:556\n1#2:578\n1617#3,9:557\n1869#3:566\n808#3,11:567\n1870#3:579\n1626#3:580\n1869#3,2:581\n1193#3,2:583\n1267#3,4:585\n360#3,7:589\n1869#3,2:596\n774#3:598\n865#3,2:599\n1504#3:601\n1534#3,3:602\n1537#3,3:612\n1504#3:615\n1534#3,3:616\n1537#3,3:626\n1504#3:629\n1534#3,3:630\n1537#3,3:640\n382#4,7:605\n382#4,7:619\n382#4,7:633\n*S KotlinDebug\n*F\n+ 1 BookDtoDao.kt\norg/gotson/komga/infrastructure/jooq/main/BookDtoDao\n*L\n126#1:578\n126#1:557,9\n126#1:566\n131#1:567,11\n126#1:579\n126#1:580\n169#1:581,2\n284#1:583,2\n284#1:585,4\n383#1:589,7\n423#1:596,2\n454#1:598\n454#1:599,2\n455#1:601\n455#1:602,3\n455#1:612,3\n461#1:615\n461#1:616,3\n461#1:626,3\n467#1:629\n467#1:630,3\n467#1:640,3\n455#1:605,7\n461#1:619,7\n467#1:633,7\n*E\n"})
public class BookDtoDao
extends SplitDslDaoBase
implements BookDtoRepository {
    @NotNull
    private final LuceneHelper luceneHelper;
    private final int batchSize;
    @NotNull
    private final BookCommonDao bookCommonDao;
    private final Book b;
    private final Media m;
    private final BookMetadata d;
    private final ReadProgress r;
    private final BookMetadataAuthor a;
    private final SeriesMetadata sd;
    private final ReadlistBook rlb;
    private final BookMetadataTag bt;
    private final BookMetadataLink bl;
    @NotNull
    private final Field<?>[] onDeckFields;
    @NotNull
    private final Map<String, Field<? extends Object>> sorts;

    public BookDtoDao(@NotNull DSLContext dslRW, @Qualifier(value="dslContextRO") @NotNull DSLContext dslRO, @NotNull LuceneHelper luceneHelper, @Value(value="#{@komgaProperties.database.batchChunkSize}") int batchSize, @NotNull BookCommonDao bookCommonDao) {
        Intrinsics.checkNotNullParameter((Object)dslRW, (String)"dslRW");
        Intrinsics.checkNotNullParameter((Object)dslRO, (String)"dslRO");
        Intrinsics.checkNotNullParameter((Object)luceneHelper, (String)"luceneHelper");
        Intrinsics.checkNotNullParameter((Object)bookCommonDao, (String)"bookCommonDao");
        super(dslRW, dslRO);
        this.luceneHelper = luceneHelper;
        this.batchSize = batchSize;
        this.bookCommonDao = bookCommonDao;
        this.b = Tables.BOOK;
        this.m = Tables.MEDIA;
        this.d = Tables.BOOK_METADATA;
        this.r = Tables.READ_PROGRESS;
        this.a = Tables.BOOK_METADATA_AUTHOR;
        this.sd = Tables.SERIES_METADATA;
        this.rlb = Tables.READLIST_BOOK;
        this.bt = Tables.BOOK_METADATA_TAG;
        this.bl = Tables.BOOK_METADATA_LINK;
        Field[] fieldArray = this.b.fields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"fields(...)");
        Object[] objectArray = fieldArray;
        Field[] fieldArray2 = this.m.fields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray2, (String)"fields(...)");
        Object[] objectArray2 = ArraysKt.plus((Object[])objectArray, (Object[])fieldArray2);
        Field[] fieldArray3 = this.d.fields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray3, (String)"fields(...)");
        Object[] objectArray3 = ArraysKt.plus((Object[])objectArray2, (Object[])fieldArray3);
        Field[] fieldArray4 = this.r.fields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray4, (String)"fields(...)");
        this.onDeckFields = (Field[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])objectArray3, (Object[])fieldArray4), (Object)this.sd.TITLE);
        Pair[] pairArray = new Pair[20];
        pairArray[0] = TuplesKt.to((Object)"name", (Object)this.b.NAME.collate("COLLATION_UNICODE_3"));
        pairArray[1] = TuplesKt.to((Object)"series", (Object)this.sd.TITLE_SORT.collate("COLLATION_UNICODE_3"));
        pairArray[2] = TuplesKt.to((Object)"created", (Object)this.b.CREATED_DATE);
        pairArray[3] = TuplesKt.to((Object)"createdDate", (Object)this.b.CREATED_DATE);
        pairArray[4] = TuplesKt.to((Object)"lastModified", (Object)this.b.LAST_MODIFIED_DATE);
        pairArray[5] = TuplesKt.to((Object)"lastModifiedDate", (Object)this.b.LAST_MODIFIED_DATE);
        pairArray[6] = TuplesKt.to((Object)"fileSize", (Object)this.b.FILE_SIZE);
        pairArray[7] = TuplesKt.to((Object)"size", (Object)this.b.FILE_SIZE);
        pairArray[8] = TuplesKt.to((Object)"fileHash", (Object)this.b.FILE_HASH);
        TableField tableField = this.b.URL;
        Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"URL");
        pairArray[9] = TuplesKt.to((Object)"url", (Object)UtilsKt.noCase((Field)((Field)tableField)));
        TableField tableField2 = this.m.STATUS;
        Intrinsics.checkNotNullExpressionValue((Object)tableField2, (String)"STATUS");
        pairArray[10] = TuplesKt.to((Object)"media.status", (Object)UtilsKt.noCase((Field)((Field)tableField2)));
        TableField tableField3 = this.m.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)tableField3, (String)"COMMENT");
        pairArray[11] = TuplesKt.to((Object)"media.comment", (Object)UtilsKt.noCase((Field)((Field)tableField3)));
        TableField tableField4 = this.m.MEDIA_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)tableField4, (String)"MEDIA_TYPE");
        pairArray[12] = TuplesKt.to((Object)"media.mediaType", (Object)UtilsKt.noCase((Field)((Field)tableField4)));
        pairArray[13] = TuplesKt.to((Object)"media.pagesCount", (Object)this.m.PAGE_COUNT);
        pairArray[14] = TuplesKt.to((Object)"metadata.title", (Object)this.d.TITLE.collate("COLLATION_UNICODE_3"));
        pairArray[15] = TuplesKt.to((Object)"metadata.numberSort", (Object)this.d.NUMBER_SORT);
        pairArray[16] = TuplesKt.to((Object)"metadata.releaseDate", (Object)this.d.RELEASE_DATE);
        pairArray[17] = TuplesKt.to((Object)"readProgress.lastModified", (Object)this.r.LAST_MODIFIED_DATE);
        pairArray[18] = TuplesKt.to((Object)"readProgress.readDate", (Object)this.r.READ_DATE);
        pairArray[19] = TuplesKt.to((Object)"readList.number", (Object)this.rlb.NUMBER);
        this.sorts = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public Page<BookDto> findAll(@NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.findAll(new BookSearch(null, null, 3, null), SearchContext.Companion.ofAnonymousUser(), pageable);
    }

    @NotNull
    public Page<BookDto> findAll(@NotNull SearchContext context, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.findAll(new BookSearch(null, null, 3, null), context, pageable);
    }

    @NotNull
    public Page<BookDto> findAll(@NotNull BookSearch search, @NotNull SearchContext context, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        if (context.getUserId() == null) {
            boolean $i$a$-requireNotNull-BookDtoDao$findAll$22 = false;
            String $i$a$-requireNotNull-BookDtoDao$findAll$22 = "Missing userId in search context";
            throw new IllegalArgumentException($i$a$-requireNotNull-BookDtoDao$findAll$22.toString());
        }
        Pair pair = new BookSearchHelper(context).toCondition(search.getCondition());
        Condition conditions = (Condition)pair.component1();
        Set joins = (Set)pair.component2();
        return this.findAll(conditions, context.getUserId(), pageable, search.getFullTextSearch(), joins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Page<BookDto> findAll(Condition conditions, String userId, Pageable pageable, String searchTerm, Set<? extends RequiredJoin> joins) {
        Iterable iterable;
        void $this$mapNotNullTo$iv$iv;
        List bookIds = this.luceneHelper.searchEntitiesIds(searchTerm, LuceneEntity.Book);
        Sort sort = pageable.getSort();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"getSort(...)");
        Iterable $this$mapNotNull$iv = (Iterable)sort;
        boolean $i$f$mapNotNull = false;
        Iterable iterable2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        GroupField[] groupFieldArray = $this$forEach$iv$iv$iv.iterator();
        while (groupFieldArray.hasNext()) {
            OrderField orderField;
            block15: {
                SortField sortField;
                block18: {
                    Sort.Order it;
                    block16: {
                        Object object;
                        block17: {
                            void $this$filterIsInstanceTo$iv$iv;
                            block14: {
                                Collection collection;
                                Object element$iv$iv$iv;
                                Object element$iv$iv = element$iv$iv$iv = groupFieldArray.next();
                                boolean bl = false;
                                it = (Sort.Order)element$iv$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getProperty(), (Object)"relevance") || (collection = (Collection)bookIds) == null || collection.isEmpty()) break block14;
                                TableField tableField = this.b.ID;
                                Intrinsics.checkNotNullExpressionValue((Object)tableField, (String)"ID");
                                orderField = (OrderField)UtilsKt.sortByValues((Field)((Field)tableField), (List)bookIds, (boolean)it.isAscending());
                                break block15;
                            }
                            if (!Intrinsics.areEqual((Object)it.getProperty(), (Object)"readList.number")) break block16;
                            Iterable $this$filterIsInstance$iv = joins;
                            boolean $i$f$filterIsInstance = false;
                            iterable = $this$filterIsInstance$iv;
                            Collection destination$iv$iv2 = new ArrayList();
                            boolean $i$f$filterIsInstanceTo = false;
                            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv instanceof RequiredJoin.ReadList)) continue;
                                destination$iv$iv2.add(element$iv$iv);
                            }
                            object = (RequiredJoin.ReadList)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
                            if (object != null && (object = object.getReadListId()) != null) break block17;
                            orderField = null;
                            break block15;
                        }
                        Object readListId = object;
                        TableField f = UtilsKt.rlbAlias((String)readListId).NUMBER;
                        sortField = it.isAscending() ? f.asc() : f.desc();
                        break block18;
                    }
                    Intrinsics.checkNotNull((Object)it);
                    sortField = UtilsKt.toSortField((Sort.Order)it, (Map)this.sorts);
                }
                orderField = (OrderField)sortField;
            }
            if (orderField == null) continue;
            OrderField it$iv$iv = orderField;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List orderBy = (List)destination$iv$iv;
        Closeable closeable = (Closeable)new TempTable(this.getDslRO());
        Throwable throwable = null;
        try {
            Condition condition;
            TempTable tempTable = (TempTable)closeable;
            boolean bl = false;
            if (bookIds == null) {
                condition = DSL.noCondition();
            } else if (bookIds.isEmpty()) {
                condition = (Condition)DSL.falseCondition();
            } else {
                tempTable.insertTempStrings(this.batchSize, (Collection)bookIds);
                condition = this.b.ID.in((Select)tempTable.selectTempStrings());
            }
            Condition $i$f$mapNotNullTo2 = condition;
            Intrinsics.checkNotNull((Object)$i$f$mapNotNullTo2);
            Condition searchCondition = $i$f$mapNotNullTo2;
            groupFieldArray = $i$f$forEach3 = this.getDslRO().select((SelectField)this.b.ID).from((TableLike)this.b).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.readProgressCondition(userId)).leftJoin((TableLike)this.sd).on(this.b.SERIES_ID.eq((Field)this.sd.SERIES_ID));
            DSLContext dSLContext = this.getDslRO();
            boolean bl3 = false;
            Iterable $this$forEach$iv = joins;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                RequiredJoin join = (RequiredJoin)element$iv;
                boolean bl4 = false;
                iterable = join;
                if (iterable instanceof RequiredJoin.ReadList) {
                    void $this$findAll_u24lambda_u245_u24lambda_u243;
                    ReadlistBook rlbAlias = UtilsKt.rlbAlias((String)((RequiredJoin.ReadList)join).getReadListId());
                    $this$findAll_u24lambda_u245_u24lambda_u243.leftJoin((TableLike)rlbAlias).on(rlbAlias.BOOK_ID.eq((Field)this.b.ID).and(rlbAlias.READLIST_ID.eq((Object)((RequiredJoin.ReadList)join).getReadListId())));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iterable, (Object)RequiredJoin.BookMetadata.INSTANCE) || Intrinsics.areEqual((Object)iterable, (Object)RequiredJoin.Media.INSTANCE) || iterable instanceof RequiredJoin.ReadProgress || Intrinsics.areEqual((Object)iterable, (Object)RequiredJoin.BookMetadataAggregation.INSTANCE) || Intrinsics.areEqual((Object)iterable, (Object)RequiredJoin.SeriesMetadata.INSTANCE) || iterable instanceof RequiredJoin.Collection) continue;
                throw new NoWhenBranchMatchedException();
            }
            SelectConditionStep selectConditionStep = $i$f$forEach3.where(conditions).and(searchCondition);
            GroupField[] $i$f$forEach3 = new GroupField[]{this.b.ID};
            int count = dSLContext.fetchCount((Select)selectConditionStep.groupBy($i$f$forEach3));
            SelectSeekStepN selectSeekStepN = this.selectBase(this.getDslRO(), userId, joins).where(conditions).and(searchCondition).orderBy((Collection)orderBy);
            $this$forEach$iv = selectSeekStepN;
            dSLContext = this;
            boolean bl5 = false;
            if (pageable.isPaged()) {
                void $this$findAll_u24lambda_u245_u24lambda_u244;
                $this$findAll_u24lambda_u245_u24lambda_u244.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
            }
            SelectSeekStepN selectSeekStepN2 = selectSeekStepN;
            Intrinsics.checkNotNullExpressionValue((Object)selectSeekStepN2, (String)"apply(...)");
            List dtos = super.fetchAndMap((ResultQuery)selectSeekStepN2, this.getDslRO());
            selectSeekStepN = !((Collection)orderBy).isEmpty() ? pageable.getSort() : Sort.unsorted();
            Intrinsics.checkNotNull((Object)selectSeekStepN);
            SelectSeekStepN pageSort = selectSeekStepN;
            Page page = (Page)new PageImpl(dtos, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageSort) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)pageSort)), (long)count);
            return page;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public BookDto findByIdOrNull(@NotNull String bookId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        SelectConditionStep selectConditionStep = BookDtoDao.selectBase$default((BookDtoDao)this, (DSLContext)this.getDslRO(), (String)userId, null, (int)2, null).where(this.b.ID.eq((Object)bookId));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
        return (BookDto)CollectionsKt.firstOrNull((List)this.fetchAndMap((ResultQuery)selectConditionStep, this.getDslRO()));
    }

    @Nullable
    public BookDto findPreviousInSeriesOrNull(@NotNull String bookId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.findSiblingSeries(bookId, userId, false);
    }

    @Nullable
    public BookDto findNextInSeriesOrNull(@NotNull String bookId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.findSiblingSeries(bookId, userId, true);
    }

    @Nullable
    public BookDto findPreviousInReadListOrNull(@NotNull ReadList readList, @NotNull String bookId, @NotNull String userId, @Nullable Collection<String> filterOnLibraryIds, @NotNull ContentRestrictions restrictions) {
        Intrinsics.checkNotNullParameter((Object)readList, (String)"readList");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        return this.findSiblingReadList(readList, bookId, userId, filterOnLibraryIds, restrictions, false);
    }

    @Nullable
    public BookDto findNextInReadListOrNull(@NotNull ReadList readList, @NotNull String bookId, @NotNull String userId, @Nullable Collection<String> filterOnLibraryIds, @NotNull ContentRestrictions restrictions) {
        Intrinsics.checkNotNullParameter((Object)readList, (String)"readList");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        return this.findSiblingReadList(readList, bookId, userId, filterOnLibraryIds, restrictions, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<BookDto> findAllOnDeck(@NotNull String userId, @Nullable Collection<String> filterOnLibraryIds, @NotNull Pageable pageable, @NotNull ContentRestrictions restrictions) {
        SelectSeekStep1 selectSeekStep1;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        Triple triple = this.bookCommonDao.getBooksOnDeckQuery(userId, restrictions, filterOnLibraryIds, this.onDeckFields);
        SelectConditionStep query = (SelectConditionStep)triple.component1();
        Field sortField = (Field)triple.component2();
        int count = this.getDslRO().fetchCount((Select)query);
        SelectSeekStep1 selectSeekStep12 = selectSeekStep1 = query.orderBy((OrderField)sortField.desc());
        BookDtoDao bookDtoDao = this;
        boolean bl = false;
        if (pageable.isPaged()) {
            void $this$findAllOnDeck_u24lambda_u246;
            $this$findAllOnDeck_u24lambda_u246.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        SelectSeekStep1 selectSeekStep13 = selectSeekStep1;
        Intrinsics.checkNotNullExpressionValue((Object)selectSeekStep13, (String)"apply(...)");
        List dtos = bookDtoDao.fetchAndMap((ResultQuery)selectSeekStep13, this.getDslRO());
        return (Page)new PageImpl(dtos, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.unsorted()) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)Sort.unsorted())), (long)count);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<BookDto> findAllDuplicates(@NotNull String userId, @NotNull Pageable pageable) {
        SelectSeekStepN selectSeekStepN;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        GroupField[] groupFieldArray = new GroupField[]{this.b.FILE_HASH, this.b.FILE_SIZE};
        Result result = this.getDslRO().select((SelectField)this.b.FILE_HASH, (SelectField)DSL.count((Field)((Field)this.b.ID))).from((TableLike)this.b).where(this.b.FILE_HASH.ne((Object)"")).groupBy(groupFieldArray).having(DSL.count((Field)((Field)this.b.ID)).gt((Object)1)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fetch(...)");
        Iterable iterable = (Iterable)result;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_10 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo22 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Record2 it = (Record2)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.value1(), (Object)it.value2());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map hashes = destination$iv$iv;
        int count = CollectionsKt.sumOfInt((Iterable)hashes.values());
        Sort sort = pageable.getSort();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"getSort(...)");
        List orderBy = UtilsKt.toOrderBy((Sort)sort, (Map)this.sorts);
        SelectSeekStepN $i$f$associateTo22 = selectSeekStepN = BookDtoDao.selectBase$default((BookDtoDao)this, (DSLContext)this.getDslRO(), (String)userId, null, (int)2, null).where(this.b.FILE_HASH.in((Collection)hashes.keySet())).orderBy((Collection)orderBy);
        BookDtoDao bookDtoDao = this;
        boolean bl = false;
        if (pageable.isPaged()) {
            void $this$findAllDuplicates_u24lambda_u248;
            $this$findAllDuplicates_u24lambda_u248.limit((Number)pageable.getPageSize()).offset((Number)pageable.getOffset());
        }
        SelectSeekStepN selectSeekStepN2 = selectSeekStepN;
        Intrinsics.checkNotNullExpressionValue((Object)selectSeekStepN2, (String)"apply(...)");
        List dtos = bookDtoDao.fetchAndMap((ResultQuery)selectSeekStepN2, this.getDslRO());
        selectSeekStepN = !((Collection)orderBy).isEmpty() ? pageable.getSort() : Sort.unsorted();
        Intrinsics.checkNotNull((Object)selectSeekStepN);
        SelectSeekStepN pageSort = selectSeekStepN;
        return (Page)new PageImpl(dtos, (Pageable)(pageable.isPaged() ? PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageSort) : PageRequest.of((int)0, (int)Math.max(count, 20), (Sort)pageSort)), (long)count);
    }

    private Condition readProgressCondition(String userId) {
        Condition condition = this.r.USER_ID.eq((Object)userId);
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"eq(...)");
        return condition;
    }

    /*
     * WARNING - void declaration
     */
    private BookDto findSiblingSeries(String bookId, String userId, boolean next) {
        void it;
        Record record = this.getDslRO().select((SelectField)this.b.SERIES_ID, (SelectField)this.d.NUMBER_SORT).from((TableLike)this.b).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).where(this.b.ID.eq((Object)bookId)).fetchOne();
        Intrinsics.checkNotNull((Object)record);
        Record2 record2 = (Record2)record;
        String seriesId = (String)record2.get(0, String.class);
        Float numberSort = (Float)record2.get(1, Float.TYPE);
        TableField tableField = this.d.NUMBER_SORT;
        SelectConditionStep selectConditionStep = BookDtoDao.selectBase$default((BookDtoDao)this, (DSLContext)this.getDslRO(), (String)userId, null, (int)2, null).where(this.b.SERIES_ID.eq((Object)seriesId));
        BookDtoDao bookDtoDao = this;
        boolean bl = false;
        SortField sortField = next ? it.asc() : it.desc();
        SelectForUpdateStep selectForUpdateStep = selectConditionStep.orderBy((OrderField)sortField).seek((Object)numberSort).limit((Number)1);
        Intrinsics.checkNotNullExpressionValue((Object)selectForUpdateStep, (String)"limit(...)");
        return (BookDto)CollectionsKt.firstOrNull((List)bookDtoDao.fetchAndMap((ResultQuery)selectForUpdateStep, this.getDslRO()));
    }

    /*
     * WARNING - void declaration
     */
    private BookDto findSiblingReadList(ReadList readList, String bookId, String userId, Collection<String> filterOnLibraryIds, ContentRestrictions restrictions, boolean next) {
        int bookIndex;
        Object it;
        List bookIds;
        Object it2;
        block12: {
            int n;
            SelectOnConditionStep $this$findSiblingReadList_u24lambda_u24112;
            if (readList.getOrdered()) {
                void it3;
                TableField $this$findSiblingReadList_u24lambda_u2414;
                SelectConditionStep $this$findSiblingReadList_u24lambda_u2412;
                SelectConditionStep selectConditionStep;
                SelectConditionStep $this$findSiblingReadList_u24lambda_u24112 = selectConditionStep = this.getDslRO().select((SelectField)this.rlb.NUMBER).from((TableLike)this.b).leftJoin((TableLike)this.rlb).on(this.b.ID.eq((Field)this.rlb.BOOK_ID)).where(this.b.ID.eq((Object)bookId)).and(this.rlb.READLIST_ID.eq((Object)readList.getId()));
                boolean $i$a$-apply-BookDtoDao$findSiblingReadList$numberSort$22 = false;
                Collection<String> collection = filterOnLibraryIds;
                if (collection != null) {
                    Collection<String> it4 = collection;
                    boolean bl = false;
                    $this$findSiblingReadList_u24lambda_u24112.and(this.b.LIBRARY_ID.in(it4));
                }
                Integer numberSort = (Integer)selectConditionStep.fetchOne((Field)this.rlb.NUMBER);
                SelectConditionStep $i$a$-apply-BookDtoDao$findSiblingReadList$numberSort$22 = $this$findSiblingReadList_u24lambda_u24112 = this.selectBase(this.getDslRO(), userId, SetsKt.setOf((Object)new RequiredJoin.ReadList(readList.getId())));
                BookDtoDao bookDtoDao = this;
                boolean bl = false;
                if (restrictions.isRestricted()) {
                    $this$findSiblingReadList_u24lambda_u2412.and(UtilsKt.toCondition((ContentRestrictions)restrictions));
                }
                $this$findSiblingReadList_u24lambda_u2412 = $this$findSiblingReadList_u24lambda_u24112;
                boolean bl2 = false;
                Collection<String> collection2 = filterOnLibraryIds;
                if (collection2 != null) {
                    Collection<String> it5 = collection2;
                    boolean bl3 = false;
                    $this$findSiblingReadList_u24lambda_u2414.and(this.b.LIBRARY_ID.in(it5));
                }
                $this$findSiblingReadList_u24lambda_u2414 = UtilsKt.rlbAlias((String)readList.getId()).NUMBER;
                SelectConditionStep selectConditionStep2 = $this$findSiblingReadList_u24lambda_u24112;
                boolean bl4 = false;
                SortField sortField = next ? it3.asc() : it3.desc();
                SelectForUpdateStep selectForUpdateStep = selectConditionStep2.orderBy((OrderField)sortField).seek((Object)numberSort).limit((Number)1);
                Intrinsics.checkNotNullExpressionValue((Object)selectForUpdateStep, (String)"limit(...)");
                return (BookDto)CollectionsKt.firstOrNull((List)bookDtoDao.fetchAndMap((ResultQuery)selectForUpdateStep, this.getDslRO()));
            }
            SelectOnConditionStep $this$findSiblingReadList_u24lambda_u2416 = $this$findSiblingReadList_u24lambda_u24112 = this.getDslRO().select((SelectField)this.b.ID).from((TableLike)this.b).leftJoin((TableLike)this.rlb).on(this.b.ID.eq((Field)this.rlb.BOOK_ID)).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID));
            boolean bl = false;
            if (restrictions.isRestricted()) {
                $this$findSiblingReadList_u24lambda_u2416.leftJoin((TableLike)this.sd).on(this.sd.SERIES_ID.eq((Field)this.b.SERIES_ID));
            }
            SelectOnConditionStep $this$findSiblingReadList_u24lambda_u2417 = $this$findSiblingReadList_u24lambda_u24112 = $this$findSiblingReadList_u24lambda_u24112.where(this.rlb.READLIST_ID.eq((Object)readList.getId()));
            boolean bl5 = false;
            if (restrictions.isRestricted()) {
                $this$findSiblingReadList_u24lambda_u2417.and(UtilsKt.toCondition((ContentRestrictions)restrictions));
            }
            SelectOnConditionStep $this$findSiblingReadList_u24lambda_u2419 = $this$findSiblingReadList_u24lambda_u24112;
            boolean bl6 = false;
            Collection<String> collection = filterOnLibraryIds;
            if (collection != null) {
                it2 = collection;
                boolean bl7 = false;
                $this$findSiblingReadList_u24lambda_u2419.and(this.b.LIBRARY_ID.in(it2));
            }
            List list = $this$findSiblingReadList_u24lambda_u24112.orderBy((OrderField)this.d.RELEASE_DATE).fetch((Field)this.b.ID);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
            List $this$indexOfFirst$iv = bookIds = list;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                it = (String)item$iv;
                boolean bl8 = false;
                if (Intrinsics.areEqual((Object)it, (Object)bookId)) {
                    n = index$iv;
                    break block12;
                }
                ++index$iv;
            }
            n = bookIndex = -1;
        }
        if (bookIndex == -1) {
            return null;
        }
        String string = (String)CollectionsKt.getOrNull((List)bookIds, (int)(bookIndex + (next ? 1 : -1)));
        if (string == null) {
            return null;
        }
        String siblingId = string;
        SelectConditionStep selectConditionStep = BookDtoDao.selectBase$default((BookDtoDao)this, (DSLContext)this.getDslRO(), (String)userId, null, (int)2, null).where(this.b.ID.eq((Object)siblingId));
        it2 = selectConditionStep;
        BookDtoDao bookDtoDao = this;
        boolean bl = false;
        Collection<String> collection = filterOnLibraryIds;
        if (collection != null) {
            void $this$findSiblingReadList_u24lambda_u2422;
            it = collection;
            boolean bl9 = false;
            $this$findSiblingReadList_u24lambda_u2422.and(this.b.LIBRARY_ID.in((Collection)it));
        }
        SelectLimitPercentStep selectLimitPercentStep = selectConditionStep.limit((Number)1);
        Intrinsics.checkNotNullExpressionValue((Object)selectLimitPercentStep, (String)"limit(...)");
        return (BookDto)CollectionsKt.firstOrNull((List)bookDtoDao.fetchAndMap((ResultQuery)selectLimitPercentStep, this.getDslRO()));
    }

    private SelectOnConditionStep<Record> selectBase(DSLContext $this$selectBase, String userId, Set<? extends RequiredJoin> joins) {
        SelectOnConditionStep selectOnConditionStep;
        SpreadBuilder spreadBuilder = new SpreadBuilder(5);
        spreadBuilder.addSpread((Object)this.b.fields());
        spreadBuilder.addSpread((Object)this.m.fields());
        spreadBuilder.addSpread((Object)this.d.fields());
        spreadBuilder.addSpread((Object)this.r.fields());
        spreadBuilder.add((Object)this.sd.TITLE);
        List selectFields = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Field[spreadBuilder.size()]));
        SelectOnConditionStep $this$selectBase_u24lambda_u2424 = selectOnConditionStep = $this$selectBase.select((Collection)selectFields).from((TableLike)this.b).leftJoin((TableLike)this.m).on(this.b.ID.eq((Field)this.m.BOOK_ID)).leftJoin((TableLike)this.d).on(this.b.ID.eq((Field)this.d.BOOK_ID)).leftJoin((TableLike)this.r).on(this.b.ID.eq((Field)this.r.BOOK_ID)).and(this.readProgressCondition(userId)).leftJoin((TableLike)this.sd).on(this.b.SERIES_ID.eq((Field)this.sd.SERIES_ID));
        boolean bl = false;
        Iterable $this$forEach$iv = joins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RequiredJoin join = (RequiredJoin)element$iv;
            boolean bl2 = false;
            RequiredJoin requiredJoin = join;
            if (requiredJoin instanceof RequiredJoin.ReadList) {
                ReadlistBook rlbAlias = UtilsKt.rlbAlias((String)((RequiredJoin.ReadList)join).getReadListId());
                $this$selectBase_u24lambda_u2424.leftJoin((TableLike)rlbAlias).on(rlbAlias.BOOK_ID.eq((Field)this.b.ID).and(rlbAlias.READLIST_ID.eq((Object)((RequiredJoin.ReadList)join).getReadListId())));
                continue;
            }
            if (Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.BookMetadata.INSTANCE) || Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.Media.INSTANCE) || requiredJoin instanceof RequiredJoin.ReadProgress || Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.BookMetadataAggregation.INSTANCE) || Intrinsics.areEqual((Object)requiredJoin, (Object)RequiredJoin.SeriesMetadata.INSTANCE) || requiredJoin instanceof RequiredJoin.Collection) continue;
            throw new NoWhenBranchMatchedException();
        }
        SelectOnConditionStep selectOnConditionStep2 = selectOnConditionStep;
        Intrinsics.checkNotNullExpressionValue((Object)selectOnConditionStep2, (String)"apply(...)");
        return selectOnConditionStep2;
    }

    static /* synthetic */ SelectOnConditionStep selectBase$default(BookDtoDao bookDtoDao, DSLContext dSLContext, String string, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: selectBase");
        }
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return bookDtoDao.selectBase(dSLContext, string, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<BookDto> fetchAndMap(ResultQuery<Record> $this$fetchAndMap, DSLContext dsl) {
        Result result = $this$fetchAndMap.fetch();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fetch(...)");
        Result records = result;
        List list = records.getValues((Field)this.b.ID);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
        List bookIds = list;
        Ref.ObjectRef authors = new Ref.ObjectRef();
        Ref.ObjectRef tags = new Ref.ObjectRef();
        Ref.ObjectRef links = new Ref.ObjectRef();
        Closeable closeable = (Closeable)TempTable.Companion.withTempTable(dsl, this.batchSize, (Collection)bookIds);
        Throwable throwable = null;
        try {
            List list2;
            List list$iv$iv;
            List answer$iv$iv$iv;
            Object value$iv$iv$iv;
            String key$iv$iv;
            boolean $i$f$getOrPut;
            Object $this$getOrPut$iv$iv$iv;
            Iterable $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv;
            BookMetadataAuthorRecord it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            TempTable tempTable = (TempTable)closeable;
            boolean bl = false;
            SelectConditionStep selectConditionStep = dsl.selectFrom((TableLike)this.a).where(this.a.BOOK_ID.in((Select)tempTable.selectTempStrings()));
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"where(...)");
            Iterable iterable = (Iterable)selectConditionStep;
            Ref.ObjectRef objectRef = authors;
            boolean $i$f$filter = false;
            void var15_17 = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BookMetadataAuthorRecord)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getName() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it2;
                Object object;
                it = (BookMetadataAuthorRecord)element$iv$iv;
                boolean $i$a$-groupBy-BookDtoDao$fetchAndMap$1$82 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getBookId(), (String)"getBookId(...)");
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                BookMetadataAuthorRecord $i$a$-groupBy-BookDtoDao$fetchAndMap$1$82 = (BookMetadataAuthorRecord)element$iv$iv;
                list2 = list$iv$iv;
                boolean bl4 = false;
                String string = it2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = it2.getRole();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRole(...)");
                list2.add(new AuthorDto(string, string2));
            }
            objectRef.element = destination$iv$iv;
            SelectConditionStep selectConditionStep2 = dsl.selectFrom((TableLike)this.bt).where(this.bt.BOOK_ID.in((Select)tempTable.selectTempStrings()));
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep2, (String)"where(...)");
            $this$groupBy$iv = (Iterable)selectConditionStep2;
            objectRef = tags;
            $i$f$groupBy = false;
            $this$groupByTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it3;
                Object object;
                it = (BookMetadataTagRecord)element$iv$iv;
                boolean $i$a$-groupBy-BookDtoDao$fetchAndMap$1$92 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getBookId(), (String)"getBookId(...)");
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                BookMetadataTagRecord $i$a$-groupBy-BookDtoDao$fetchAndMap$1$92 = (BookMetadataTagRecord)element$iv$iv;
                list2 = list$iv$iv;
                boolean bl6 = false;
                list2.add(it3.getTag());
            }
            objectRef.element = destination$iv$iv;
            SelectConditionStep selectConditionStep3 = dsl.selectFrom((TableLike)this.bl).where(this.bl.BOOK_ID.in((Select)tempTable.selectTempStrings()));
            Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep3, (String)"where(...)");
            $this$groupBy$iv = (Iterable)selectConditionStep3;
            objectRef = links;
            $i$f$groupBy = false;
            $this$groupByTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it4;
                Object object;
                it = (BookMetadataLinkRecord)element$iv$iv;
                boolean $i$a$-groupBy-BookDtoDao$fetchAndMap$1$102 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getBookId(), (String)"getBookId(...)");
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl7 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                BookMetadataLinkRecord $i$a$-groupBy-BookDtoDao$fetchAndMap$1$102 = (BookMetadataLinkRecord)element$iv$iv;
                list2 = list$iv$iv;
                boolean bl8 = false;
                String string = it4.getLabel();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLabel(...)");
                String string3 = it4.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUrl(...)");
                list2.add(new WebLinkDto(string, string3));
            }
            objectRef.element = destination$iv$iv;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        List list3 = records.map((RecordMapper)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"map(...)");
        return list3;
    }

    private BookDto toDto(BookRecord $this$toDto, MediaDto media, BookMetadataDto metadata, ReadProgressDto readProgress, String seriesTitle) {
        String string = $this$toDto.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = $this$toDto.getSeriesId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSeriesId(...)");
        String string3 = $this$toDto.getLibraryId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLibraryId(...)");
        String string4 = $this$toDto.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        String string5 = org.gotson.komga.infrastructure.web.UtilsKt.toFilePath((URL)new URL($this$toDto.getUrl()));
        Integer n = $this$toDto.getNumber();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getNumber(...)");
        int n2 = ((Number)n).intValue();
        LocalDateTime localDateTime = $this$toDto.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = $this$toDto.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getLastModifiedDate(...)");
        LocalDateTime localDateTime3 = $this$toDto.getFileLastModified();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getFileLastModified(...)");
        LocalDateTime localDateTime4 = LanguageUtilsKt.toUTC((LocalDateTime)localDateTime3);
        Long l = $this$toDto.getFileSize();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getFileSize(...)");
        long l2 = ((Number)l).longValue();
        boolean bl = $this$toDto.getDeletedDate() != null;
        String string6 = $this$toDto.getFileHash();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getFileHash(...)");
        Boolean bl2 = $this$toDto.getOneshot();
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"getOneshot(...)");
        return new BookDto(string, string2, seriesTitle, string3, string4, string5, n2, localDateTime, localDateTime2, localDateTime4, l2, null, media, metadata, readProgress, bl, string6, bl2.booleanValue(), 2048, null);
    }

    private MediaDto toDto(MediaRecord $this$toDto) {
        String string = $this$toDto.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatus(...)");
        String string2 = $this$toDto.getMediaType();
        if (string2 == null) {
            string2 = "";
        }
        int n = $this$toDto.getPageCount();
        String string3 = $this$toDto.getComment();
        if (string3 == null) {
            string3 = "";
        }
        Boolean bl = $this$toDto.getEpubDivinaCompatible();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getEpubDivinaCompatible(...)");
        boolean bl2 = bl;
        Boolean bl3 = $this$toDto.getEpubIsKepub();
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"getEpubIsKepub(...)");
        return new MediaDto(string, string2, n, string3, bl2, bl3.booleanValue());
    }

    private BookMetadataDto toDto(BookMetadataRecord $this$toDto, List<AuthorDto> authors, Set<String> tags, List<WebLinkDto> links) {
        String string = $this$toDto.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        Boolean bl = $this$toDto.getTitleLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getTitleLock(...)");
        boolean bl2 = bl;
        String string2 = $this$toDto.getSummary();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSummary(...)");
        Boolean bl3 = $this$toDto.getSummaryLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"getSummaryLock(...)");
        boolean bl4 = bl3;
        String string3 = $this$toDto.getNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNumber(...)");
        Boolean bl5 = $this$toDto.getNumberLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl5, (String)"getNumberLock(...)");
        boolean bl6 = bl5;
        Float f = $this$toDto.getNumberSort();
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"getNumberSort(...)");
        float f2 = ((Number)f).floatValue();
        Boolean bl7 = $this$toDto.getNumberSortLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl7, (String)"getNumberSortLock(...)");
        boolean bl8 = bl7;
        LocalDate localDate = $this$toDto.getReleaseDate();
        Boolean bl9 = $this$toDto.getReleaseDateLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl9, (String)"getReleaseDateLock(...)");
        boolean bl10 = bl9;
        Boolean bl11 = $this$toDto.getAuthorsLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl11, (String)"getAuthorsLock(...)");
        boolean bl12 = bl11;
        Boolean bl13 = $this$toDto.getTagsLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl13, (String)"getTagsLock(...)");
        boolean bl14 = bl13;
        String string4 = $this$toDto.getIsbn();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getIsbn(...)");
        Boolean bl15 = $this$toDto.getIsbnLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl15, (String)"getIsbnLock(...)");
        boolean bl16 = bl15;
        Boolean bl17 = $this$toDto.getLinksLock();
        Intrinsics.checkNotNullExpressionValue((Object)bl17, (String)"getLinksLock(...)");
        boolean bl18 = bl17;
        LocalDateTime localDateTime = $this$toDto.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime2 = $this$toDto.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getLastModifiedDate(...)");
        return new BookMetadataDto(string, bl2, string2, bl4, string3, bl6, f2, bl8, localDate, bl10, authors, bl12, tags, bl14, string4, bl16, links, bl18, localDateTime, localDateTime2);
    }

    private ReadProgressDto toDto(ReadProgressRecord $this$toDto) {
        Integer n = $this$toDto.getPage();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getPage(...)");
        int n2 = ((Number)n).intValue();
        Boolean bl = $this$toDto.getCompleted();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getCompleted(...)");
        boolean bl2 = bl;
        LocalDateTime localDateTime = $this$toDto.getReadDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getReadDate(...)");
        LocalDateTime localDateTime2 = $this$toDto.getCreatedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"getCreatedDate(...)");
        LocalDateTime localDateTime3 = $this$toDto.getLastModifiedDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"getLastModifiedDate(...)");
        String string = $this$toDto.getDeviceId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDeviceId(...)");
        String string2 = $this$toDto.getDeviceName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDeviceName(...)");
        return new ReadProgressDto(n2, bl2, localDateTime, localDateTime2, localDateTime3, string, string2);
    }

    public static final /* synthetic */ Book access$getB$p(BookDtoDao $this) {
        return $this.b;
    }

    public static final /* synthetic */ Media access$getM$p(BookDtoDao $this) {
        return $this.m;
    }

    public static final /* synthetic */ BookMetadata access$getD$p(BookDtoDao $this) {
        return $this.d;
    }

    public static final /* synthetic */ ReadProgress access$getR$p(BookDtoDao $this) {
        return $this.r;
    }

    public static final /* synthetic */ SeriesMetadata access$getSd$p(BookDtoDao $this) {
        return $this.sd;
    }

    public static final /* synthetic */ BookDto access$toDto(BookDtoDao $this, BookRecord $receiver, MediaDto media, BookMetadataDto metadata, ReadProgressDto readProgress, String seriesTitle) {
        return $this.toDto($receiver, media, metadata, readProgress, seriesTitle);
    }

    public static final /* synthetic */ MediaDto access$toDto(BookDtoDao $this, MediaRecord $receiver) {
        return $this.toDto($receiver);
    }

    public static final /* synthetic */ BookMetadataDto access$toDto(BookDtoDao $this, BookMetadataRecord $receiver, List authors, Set tags, List links) {
        return $this.toDto($receiver, authors, tags, links);
    }

    public static final /* synthetic */ ReadProgressDto access$toDto(BookDtoDao $this, ReadProgressRecord $receiver) {
        return $this.toDto($receiver);
    }
}

