/**
 * This file is part of the "libunicode" project
 *   Copyright (c) 2020-2021 Christian Parpart <christian@parpart.family>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#pragma once

#include <cstdint>

namespace unicode
{

enum class Plane: uint8_t
{
    Basic_Multilingual_Plane = 0,
    Supplementary_Ideographic_Plane = 1,
    Supplementary_Multilingual_Plane = 2,
    Supplementary_Private_Use_Area_Plane = 3,
    Supplementary_Special_purpose_Plane = 4,
    Tertiary_Ideographic_Plane = 5,
    Unassigned = 6,
};

enum class Age: uint8_t
{
    Unassigned = 0,
    V10_0 = 1,
    V11_0 = 2,
    V12_0 = 3,
    V12_1 = 4,
    V13_0 = 5,
    V14_0 = 6,
    V15_0 = 7,
    V1_1 = 8,
    V2_0 = 9,
    V2_1 = 10,
    V3_0 = 11,
    V3_1 = 12,
    V3_2 = 13,
    V4_0 = 14,
    V4_1 = 15,
    V5_0 = 16,
    V5_1 = 17,
    V5_2 = 18,
    V6_0 = 19,
    V6_1 = 20,
    V6_2 = 21,
    V6_3 = 22,
    V7_0 = 23,
    V8_0 = 24,
    V9_0 = 25,
};

enum class Bidi_Class: uint8_t
{
    Arabic_Letter = 0,
    Arabic_Number = 1,
    Boundary_Neutral = 2,
    Common_Separator = 3,
    European_Number = 4,
    European_Separator = 5,
    European_Terminator = 6,
    First_Strong_Isolate = 7,
    Left_To_Right = 8,
    Left_To_Right_Embedding = 9,
    Left_To_Right_Isolate = 10,
    Left_To_Right_Override = 11,
    Nonspacing_Mark = 12,
    Other_Neutral = 13,
    Paragraph_Separator = 14,
    Pop_Directional_Format = 15,
    Pop_Directional_Isolate = 16,
    Right_To_Left = 17,
    Right_To_Left_Embedding = 18,
    Right_To_Left_Isolate = 19,
    Right_To_Left_Override = 20,
    Segment_Separator = 21,
    White_Space = 22,
};

enum class Bidi_Paired_Bracket_Type: uint8_t
{
    Close = 0,
    None = 1,
    Open = 2,
};

enum class Canonical_Combining_Class: uint8_t
{
    A = 0,
    AL = 1,
    AR = 2,
    ATA = 3,
    ATAR = 4,
    ATB = 5,
    ATBL = 6,
    B = 7,
    BL = 8,
    BR = 9,
    CCC10 = 10,
    CCC103 = 11,
    CCC107 = 12,
    CCC11 = 13,
    CCC118 = 14,
    CCC12 = 15,
    CCC122 = 16,
    CCC129 = 17,
    CCC13 = 18,
    CCC130 = 19,
    CCC132 = 20,
    CCC133 = 21,
    CCC14 = 22,
    CCC15 = 23,
    CCC16 = 24,
    CCC17 = 25,
    CCC18 = 26,
    CCC19 = 27,
    CCC20 = 28,
    CCC21 = 29,
    CCC22 = 30,
    CCC23 = 31,
    CCC24 = 32,
    CCC25 = 33,
    CCC26 = 34,
    CCC27 = 35,
    CCC28 = 36,
    CCC29 = 37,
    CCC30 = 38,
    CCC31 = 39,
    CCC32 = 40,
    CCC33 = 41,
    CCC34 = 42,
    CCC35 = 43,
    CCC36 = 44,
    CCC84 = 45,
    CCC91 = 46,
    DA = 47,
    DB = 48,
    HANR = 49,
    IS = 50,
    KV = 51,
    L = 52,
    NK = 53,
    NR = 54,
    OV = 55,
    R = 56,
    VR = 57,
};

enum class Decomposition_Type: uint8_t
{
    Canonical = 0,
    Circle = 1,
    Compat = 2,
    Final = 3,
    Font = 4,
    Fraction = 5,
    Initial = 6,
    Isolated = 7,
    Medial = 8,
    Narrow = 9,
    Nobreak = 10,
    None = 11,
    Small = 12,
    Square = 13,
    Sub = 14,
    Super = 15,
    Vertical = 16,
    Wide = 17,
};

enum class East_Asian_Width: uint8_t
{
    Ambiguous = 0,
    Fullwidth = 1,
    Halfwidth = 2,
    Narrow = 3,
    Neutral = 4,
    Wide = 5,
};

enum class Grapheme_Cluster_Break: uint8_t
{
    Undefined = 0,
    CR = 1,
    Control = 2,
    E_Base = 3,
    E_Base_GAZ = 4,
    E_Modifier = 5,
    Extend = 6,
    Glue_After_Zwj = 7,
    L = 8,
    LF = 9,
    LV = 10,
    LVT = 11,
    Other = 12,
    Prepend = 13,
    Regional_Indicator = 14,
    SpacingMark = 15,
    T = 16,
    V = 17,
    ZWJ = 18,
};

enum class Hangul_Syllable_Type: uint8_t
{
    LVT_Syllable = 0,
    LV_Syllable = 1,
    Leading_Jamo = 2,
    Not_Applicable = 3,
    Trailing_Jamo = 4,
    Vowel_Jamo = 5,
};

enum class Indic_Positional_Category: uint8_t
{
    Bottom = 0,
    Bottom_And_Left = 1,
    Bottom_And_Right = 2,
    Left = 3,
    Left_And_Right = 4,
    NA = 5,
    Overstruck = 6,
    Right = 7,
    Top = 8,
    Top_And_Bottom = 9,
    Top_And_Bottom_And_Left = 10,
    Top_And_Bottom_And_Right = 11,
    Top_And_Left = 12,
    Top_And_Left_And_Right = 13,
    Top_And_Right = 14,
    Visual_Order_Left = 15,
};

enum class Indic_Syllabic_Category: uint8_t
{
    Avagraha = 0,
    Bindu = 1,
    Brahmi_Joining_Number = 2,
    Cantillation_Mark = 3,
    Consonant = 4,
    Consonant_Dead = 5,
    Consonant_Final = 6,
    Consonant_Head_Letter = 7,
    Consonant_Initial_Postfixed = 8,
    Consonant_Killer = 9,
    Consonant_Medial = 10,
    Consonant_Placeholder = 11,
    Consonant_Preceding_Repha = 12,
    Consonant_Prefixed = 13,
    Consonant_Subjoined = 14,
    Consonant_Succeeding_Repha = 15,
    Consonant_With_Stacker = 16,
    Gemination_Mark = 17,
    Invisible_Stacker = 18,
    Joiner = 19,
    Modifying_Letter = 20,
    Non_Joiner = 21,
    Nukta = 22,
    Number = 23,
    Number_Joiner = 24,
    Other = 25,
    Pure_Killer = 26,
    Register_Shifter = 27,
    Syllable_Modifier = 28,
    Tone_Letter = 29,
    Tone_Mark = 30,
    Virama = 31,
    Visarga = 32,
    Vowel = 33,
    Vowel_Dependent = 34,
    Vowel_Independent = 35,
};

enum class Jamo_Short_Name: uint8_t
{
    A = 0,
    AE = 1,
    B = 2,
    BB = 3,
    BS = 4,
    C = 5,
    D = 6,
    DD = 7,
    E = 8,
    EO = 9,
    EU = 10,
    G = 11,
    GG = 12,
    GS = 13,
    H = 14,
    I = 15,
    J = 16,
    JJ = 17,
    K = 18,
    L = 19,
    LB = 20,
    LG = 21,
    LH = 22,
    LM = 23,
    LP = 24,
    LS = 25,
    LT = 26,
    M = 27,
    N = 28,
    NG = 29,
    NH = 30,
    NJ = 31,
    O = 32,
    OE = 33,
    P = 34,
    R = 35,
    S = 36,
    SS = 37,
    T = 38,
    U = 39,
    WA = 40,
    WAE = 41,
    WE = 42,
    WEO = 43,
    WI = 44,
    YA = 45,
    YAE = 46,
    YE = 47,
    YEO = 48,
    YI = 49,
    YO = 50,
    YU = 51,
};

enum class Joining_Group: uint8_t
{
    African_Feh = 0,
    African_Noon = 1,
    African_Qaf = 2,
    Ain = 3,
    Alaph = 4,
    Alef = 5,
    Beh = 6,
    Beth = 7,
    Burushaski_Yeh_Barree = 8,
    Dal = 9,
    Dalath_Rish = 10,
    E = 11,
    Farsi_Yeh = 12,
    Fe = 13,
    Feh = 14,
    Final_Semkath = 15,
    Gaf = 16,
    Gamal = 17,
    Hah = 18,
    Hamza_On_Heh_Goal = 19,
    Hanifi_Rohingya_Kinna_Ya = 20,
    Hanifi_Rohingya_Pa = 21,
    He = 22,
    Heh = 23,
    Heh_Goal = 24,
    Heth = 25,
    Kaf = 26,
    Kaph = 27,
    Khaph = 28,
    Knotted_Heh = 29,
    Lam = 30,
    Lamadh = 31,
    Malayalam_Bha = 32,
    Malayalam_Ja = 33,
    Malayalam_Lla = 34,
    Malayalam_Llla = 35,
    Malayalam_Nga = 36,
    Malayalam_Nna = 37,
    Malayalam_Nnna = 38,
    Malayalam_Nya = 39,
    Malayalam_Ra = 40,
    Malayalam_Ssa = 41,
    Malayalam_Tta = 42,
    Manichaean_Aleph = 43,
    Manichaean_Ayin = 44,
    Manichaean_Beth = 45,
    Manichaean_Daleth = 46,
    Manichaean_Dhamedh = 47,
    Manichaean_Five = 48,
    Manichaean_Gimel = 49,
    Manichaean_Heth = 50,
    Manichaean_Hundred = 51,
    Manichaean_Kaph = 52,
    Manichaean_Lamedh = 53,
    Manichaean_Mem = 54,
    Manichaean_Nun = 55,
    Manichaean_One = 56,
    Manichaean_Pe = 57,
    Manichaean_Qoph = 58,
    Manichaean_Resh = 59,
    Manichaean_Sadhe = 60,
    Manichaean_Samekh = 61,
    Manichaean_Taw = 62,
    Manichaean_Ten = 63,
    Manichaean_Teth = 64,
    Manichaean_Thamedh = 65,
    Manichaean_Twenty = 66,
    Manichaean_Waw = 67,
    Manichaean_Yodh = 68,
    Manichaean_Zayin = 69,
    Meem = 70,
    Mim = 71,
    No_Joining_Group = 72,
    Noon = 73,
    Nun = 74,
    Nya = 75,
    Pe = 76,
    Qaf = 77,
    Qaph = 78,
    Reh = 79,
    Reversed_Pe = 80,
    Rohingya_Yeh = 81,
    Sad = 82,
    Sadhe = 83,
    Seen = 84,
    Semkath = 85,
    Shin = 86,
    Straight_Waw = 87,
    Swash_Kaf = 88,
    Syriac_Waw = 89,
    Tah = 90,
    Taw = 91,
    Teh_Marbuta = 92,
    Teth = 93,
    Thin_Yeh = 94,
    Vertical_Tail = 95,
    Waw = 96,
    Yeh = 97,
    Yeh_Barree = 98,
    Yeh_With_Tail = 99,
    Yudh = 100,
    Yudh_He = 101,
    Zain = 102,
    Zhain = 103,
};

enum class Joining_Type: uint8_t
{
    Dual_Joining = 0,
    Join_Causing = 1,
    Left_Joining = 2,
    Non_Joining = 3,
    Right_Joining = 4,
    Transparent = 5,
};

enum class Line_Break: uint8_t
{
    Alphabetic = 0,
    Ambiguous = 1,
    Break_After = 2,
    Break_Before = 3,
    Break_Both = 4,
    Break_Symbols = 5,
    Carriage_Return = 6,
    Close_Parenthesis = 7,
    Close_Punctuation = 8,
    Combining_Mark = 9,
    Complex_Context = 10,
    Conditional_Japanese_Starter = 11,
    Contingent_Break = 12,
    E_Base = 13,
    E_Modifier = 14,
    Exclamation = 15,
    Glue = 16,
    H2 = 17,
    H3 = 18,
    Hebrew_Letter = 19,
    Hyphen = 20,
    Ideographic = 21,
    Infix_Numeric = 22,
    Inseparable = 23,
    JL = 24,
    JT = 25,
    JV = 26,
    Line_Feed = 27,
    Mandatory_Break = 28,
    Next_Line = 29,
    Nonstarter = 30,
    Numeric = 31,
    Open_Punctuation = 32,
    Postfix_Numeric = 33,
    Prefix_Numeric = 34,
    Quotation = 35,
    Regional_Indicator = 36,
    Space = 37,
    Surrogate = 38,
    Unknown = 39,
    Word_Joiner = 40,
    ZWJ = 41,
    ZWSpace = 42,
};

enum class NFC_Quick_Check: uint8_t
{
    Maybe = 0,
    No = 1,
    Yes = 2,
};

enum class NFKC_Quick_Check: uint8_t
{
    Maybe = 0,
    No = 1,
    Yes = 2,
};

enum class Numeric_Type: uint8_t
{
    Decimal = 0,
    Digit = 1,
    None = 2,
    Numeric = 3,
};

enum class Sentence_Break: uint8_t
{
    ATerm = 0,
    CR = 1,
    Close = 2,
    Extend = 3,
    Format = 4,
    LF = 5,
    Lower = 6,
    Numeric = 7,
    OLetter = 8,
    Other = 9,
    SContinue = 10,
    STerm = 11,
    Sep = 12,
    Sp = 13,
    Upper = 14,
};

enum class Vertical_Orientation: uint8_t
{
    Rotated = 0,
    Transformed_Rotated = 1,
    Transformed_Upright = 2,
    Upright = 3,
};

enum class Word_Break: uint8_t
{
    ALetter = 0,
    CR = 1,
    Double_Quote = 2,
    E_Base = 3,
    E_Base_GAZ = 4,
    E_Modifier = 5,
    Extend = 6,
    ExtendNumLet = 7,
    Format = 8,
    Glue_After_Zwj = 9,
    Hebrew_Letter = 10,
    Katakana = 11,
    LF = 12,
    MidLetter = 13,
    MidNum = 14,
    MidNumLet = 15,
    Newline = 16,
    Numeric = 17,
    Other = 18,
    Regional_Indicator = 19,
    Single_Quote = 20,
    WSegSpace = 21,
    ZWJ = 22,
};

enum class Core_Property: uint8_t
{
    Alphabetic = 0,
    Case_Ignorable = 1,
    Cased = 2,
    Changes_When_Casefolded = 3,
    Changes_When_Casemapped = 4,
    Changes_When_Lowercased = 5,
    Changes_When_Titlecased = 6,
    Changes_When_Uppercased = 7,
    Default_Ignorable_Code_Point = 8,
    Grapheme_Base = 9,
    Grapheme_Extend = 10,
    Grapheme_Link = 11,
    ID_Continue = 12,
    ID_Start = 13,
    Lowercase = 14,
    Math = 15,
    Uppercase = 16,
    XID_Continue = 17,
    XID_Start = 18,
};

enum class General_Category: uint8_t
{
    Unspecified = 0,
    Close_Punctuation = 1,
    Connector_Punctuation = 2,
    Control = 3,
    Currency_Symbol = 4,
    Dash_Punctuation = 5,
    Decimal_Number = 6,
    Enclosing_Mark = 7,
    Final_Punctuation = 8,
    Format = 9,
    Initial_Punctuation = 10,
    Letter_Number = 11,
    Line_Separator = 12,
    Lowercase_Letter = 13,
    Math_Symbol = 14,
    Modifier_Letter = 15,
    Modifier_Symbol = 16,
    Nonspacing_Mark = 17,
    Open_Punctuation = 18,
    Other_Letter = 19,
    Other_Number = 20,
    Other_Punctuation = 21,
    Other_Symbol = 22,
    Paragraph_Separator = 23,
    Private_Use = 24,
    Space_Separator = 25,
    Spacing_Mark = 26,
    Surrogate = 27,
    Titlecase_Letter = 28,
    Unassigned = 29,
    Uppercase_Letter = 30,
};

enum class Script: uint8_t
{
    Invalid = 0,
    Unknown = 1,
    Common = 2,
    Adlam = 3,
    Ahom = 4,
    Anatolian_Hieroglyphs = 5,
    Arabic = 6,
    Armenian = 7,
    Avestan = 8,
    Balinese = 9,
    Bamum = 10,
    Bassa_Vah = 11,
    Batak = 12,
    Bengali = 13,
    Bhaiksuki = 14,
    Bopomofo = 15,
    Brahmi = 16,
    Braille = 17,
    Buginese = 18,
    Buhid = 19,
    Canadian_Aboriginal = 20,
    Carian = 21,
    Caucasian_Albanian = 22,
    Chakma = 23,
    Cham = 24,
    Cherokee = 25,
    Chorasmian = 26,
    Coptic = 27,
    Cuneiform = 28,
    Cypriot = 29,
    Cypro_Minoan = 30,
    Cyrillic = 31,
    Deseret = 32,
    Devanagari = 33,
    Dives_Akuru = 34,
    Dogra = 35,
    Duployan = 36,
    Egyptian_Hieroglyphs = 37,
    Elbasan = 38,
    Elymaic = 39,
    Ethiopic = 40,
    Georgian = 41,
    Glagolitic = 42,
    Gothic = 43,
    Grantha = 44,
    Greek = 45,
    Gujarati = 46,
    Gunjala_Gondi = 47,
    Gurmukhi = 48,
    Han = 49,
    Hangul = 50,
    Hanifi_Rohingya = 51,
    Hanunoo = 52,
    Hatran = 53,
    Hebrew = 54,
    Hiragana = 55,
    Imperial_Aramaic = 56,
    Inherited = 57,
    Inscriptional_Pahlavi = 58,
    Inscriptional_Parthian = 59,
    Javanese = 60,
    Kaithi = 61,
    Kannada = 62,
    Katakana = 63,
    Kawi = 64,
    Kayah_Li = 65,
    Kharoshthi = 66,
    Khitan_Small_Script = 67,
    Khmer = 68,
    Khojki = 69,
    Khudawadi = 70,
    Lao = 71,
    Latin = 72,
    Lepcha = 73,
    Limbu = 74,
    Linear_A = 75,
    Linear_B = 76,
    Lisu = 77,
    Lycian = 78,
    Lydian = 79,
    Mahajani = 80,
    Makasar = 81,
    Malayalam = 82,
    Mandaic = 83,
    Manichaean = 84,
    Marchen = 85,
    Masaram_Gondi = 86,
    Medefaidrin = 87,
    Meetei_Mayek = 88,
    Mende_Kikakui = 89,
    Meroitic_Cursive = 90,
    Meroitic_Hieroglyphs = 91,
    Miao = 92,
    Modi = 93,
    Mongolian = 94,
    Mro = 95,
    Multani = 96,
    Myanmar = 97,
    Nabataean = 98,
    Nag_Mundari = 99,
    Nandinagari = 100,
    New_Tai_Lue = 101,
    Newa = 102,
    Nko = 103,
    Nushu = 104,
    Nyiakeng_Puachue_Hmong = 105,
    Ogham = 106,
    Ol_Chiki = 107,
    Old_Hungarian = 108,
    Old_Italic = 109,
    Old_North_Arabian = 110,
    Old_Permic = 111,
    Old_Persian = 112,
    Old_Sogdian = 113,
    Old_South_Arabian = 114,
    Old_Turkic = 115,
    Old_Uyghur = 116,
    Oriya = 117,
    Osage = 118,
    Osmanya = 119,
    Pahawh_Hmong = 120,
    Palmyrene = 121,
    Pau_Cin_Hau = 122,
    Phags_Pa = 123,
    Phoenician = 124,
    Psalter_Pahlavi = 125,
    Rejang = 126,
    Runic = 127,
    Samaritan = 128,
    Saurashtra = 129,
    Sharada = 130,
    Shavian = 131,
    Siddham = 132,
    SignWriting = 133,
    Sinhala = 134,
    Sogdian = 135,
    Sora_Sompeng = 136,
    Soyombo = 137,
    Sundanese = 138,
    Syloti_Nagri = 139,
    Syriac = 140,
    Tagalog = 141,
    Tagbanwa = 142,
    Tai_Le = 143,
    Tai_Tham = 144,
    Tai_Viet = 145,
    Takri = 146,
    Tamil = 147,
    Tangsa = 148,
    Tangut = 149,
    Telugu = 150,
    Thaana = 151,
    Thai = 152,
    Tibetan = 153,
    Tifinagh = 154,
    Tirhuta = 155,
    Toto = 156,
    Ugaritic = 157,
    Vai = 158,
    Vithkuqi = 159,
    Wancho = 160,
    Warang_Citi = 161,
    Yezidi = 162,
    Yi = 163,
    Zanabazar_Square = 164,
};

enum class Block: uint16_t
{
    Unspecified = 0,
    Adlam = 1,
    Aegean_Numbers = 2,
    Ahom = 3,
    Alchemical_Symbols = 4,
    Alphabetic_Presentation_Forms = 5,
    Anatolian_Hieroglyphs = 6,
    Ancient_Greek_Musical_Notation = 7,
    Ancient_Greek_Numbers = 8,
    Ancient_Symbols = 9,
    Arabic = 10,
    Arabic_Extended_A = 11,
    Arabic_Extended_B = 12,
    Arabic_Extended_C = 13,
    Arabic_Mathematical_Alphabetic_Symbols = 14,
    Arabic_Presentation_Forms_A = 15,
    Arabic_Presentation_Forms_B = 16,
    Arabic_Supplement = 17,
    Armenian = 18,
    Arrows = 19,
    Avestan = 20,
    Balinese = 21,
    Bamum = 22,
    Bamum_Supplement = 23,
    Basic_Latin = 24,
    Bassa_Vah = 25,
    Batak = 26,
    Bengali = 27,
    Bhaiksuki = 28,
    Block_Elements = 29,
    Bopomofo = 30,
    Bopomofo_Extended = 31,
    Box_Drawing = 32,
    Brahmi = 33,
    Braille_Patterns = 34,
    Buginese = 35,
    Buhid = 36,
    Byzantine_Musical_Symbols = 37,
    CJK_Compatibility = 38,
    CJK_Compatibility_Forms = 39,
    CJK_Compatibility_Ideographs = 40,
    CJK_Compatibility_Ideographs_Supplement = 41,
    CJK_Radicals_Supplement = 42,
    CJK_Strokes = 43,
    CJK_Symbols_and_Punctuation = 44,
    CJK_Unified_Ideographs = 45,
    CJK_Unified_Ideographs_Extension_A = 46,
    CJK_Unified_Ideographs_Extension_B = 47,
    CJK_Unified_Ideographs_Extension_C = 48,
    CJK_Unified_Ideographs_Extension_D = 49,
    CJK_Unified_Ideographs_Extension_E = 50,
    CJK_Unified_Ideographs_Extension_F = 51,
    CJK_Unified_Ideographs_Extension_G = 52,
    CJK_Unified_Ideographs_Extension_H = 53,
    Carian = 54,
    Caucasian_Albanian = 55,
    Chakma = 56,
    Cham = 57,
    Cherokee = 58,
    Cherokee_Supplement = 59,
    Chess_Symbols = 60,
    Chorasmian = 61,
    Combining_Diacritical_Marks = 62,
    Combining_Diacritical_Marks_Extended = 63,
    Combining_Diacritical_Marks_Supplement = 64,
    Combining_Diacritical_Marks_for_Symbols = 65,
    Combining_Half_Marks = 66,
    Common_Indic_Number_Forms = 67,
    Control_Pictures = 68,
    Coptic = 69,
    Coptic_Epact_Numbers = 70,
    Counting_Rod_Numerals = 71,
    Cuneiform = 72,
    Cuneiform_Numbers_and_Punctuation = 73,
    Currency_Symbols = 74,
    Cypriot_Syllabary = 75,
    Cypro_Minoan = 76,
    Cyrillic = 77,
    Cyrillic_Extended_A = 78,
    Cyrillic_Extended_B = 79,
    Cyrillic_Extended_C = 80,
    Cyrillic_Extended_D = 81,
    Cyrillic_Supplement = 82,
    Deseret = 83,
    Devanagari = 84,
    Devanagari_Extended = 85,
    Devanagari_Extended_A = 86,
    Dingbats = 87,
    Dives_Akuru = 88,
    Dogra = 89,
    Domino_Tiles = 90,
    Duployan = 91,
    Early_Dynastic_Cuneiform = 92,
    Egyptian_Hieroglyph_Format_Controls = 93,
    Egyptian_Hieroglyphs = 94,
    Elbasan = 95,
    Elymaic = 96,
    Emoticons = 97,
    Enclosed_Alphanumeric_Supplement = 98,
    Enclosed_Alphanumerics = 99,
    Enclosed_CJK_Letters_and_Months = 100,
    Enclosed_Ideographic_Supplement = 101,
    Ethiopic = 102,
    Ethiopic_Extended = 103,
    Ethiopic_Extended_A = 104,
    Ethiopic_Extended_B = 105,
    Ethiopic_Supplement = 106,
    General_Punctuation = 107,
    Geometric_Shapes = 108,
    Geometric_Shapes_Extended = 109,
    Georgian = 110,
    Georgian_Extended = 111,
    Georgian_Supplement = 112,
    Glagolitic = 113,
    Glagolitic_Supplement = 114,
    Gothic = 115,
    Grantha = 116,
    Greek_Extended = 117,
    Greek_and_Coptic = 118,
    Gujarati = 119,
    Gunjala_Gondi = 120,
    Gurmukhi = 121,
    Halfwidth_and_Fullwidth_Forms = 122,
    Hangul_Compatibility_Jamo = 123,
    Hangul_Jamo = 124,
    Hangul_Jamo_Extended_A = 125,
    Hangul_Jamo_Extended_B = 126,
    Hangul_Syllables = 127,
    Hanifi_Rohingya = 128,
    Hanunoo = 129,
    Hatran = 130,
    Hebrew = 131,
    High_Private_Use_Surrogates = 132,
    High_Surrogates = 133,
    Hiragana = 134,
    IPA_Extensions = 135,
    Ideographic_Description_Characters = 136,
    Ideographic_Symbols_and_Punctuation = 137,
    Imperial_Aramaic = 138,
    Indic_Siyaq_Numbers = 139,
    Inscriptional_Pahlavi = 140,
    Inscriptional_Parthian = 141,
    Javanese = 142,
    Kaithi = 143,
    Kaktovik_Numerals = 144,
    Kana_Extended_A = 145,
    Kana_Extended_B = 146,
    Kana_Supplement = 147,
    Kanbun = 148,
    Kangxi_Radicals = 149,
    Kannada = 150,
    Katakana = 151,
    Katakana_Phonetic_Extensions = 152,
    Kawi = 153,
    Kayah_Li = 154,
    Kharoshthi = 155,
    Khitan_Small_Script = 156,
    Khmer = 157,
    Khmer_Symbols = 158,
    Khojki = 159,
    Khudawadi = 160,
    Lao = 161,
    Latin_Extended_Additional = 162,
    Latin_Extended_A = 163,
    Latin_Extended_B = 164,
    Latin_Extended_C = 165,
    Latin_Extended_D = 166,
    Latin_Extended_E = 167,
    Latin_Extended_F = 168,
    Latin_Extended_G = 169,
    Latin_1_Supplement = 170,
    Lepcha = 171,
    Letterlike_Symbols = 172,
    Limbu = 173,
    Linear_A = 174,
    Linear_B_Ideograms = 175,
    Linear_B_Syllabary = 176,
    Lisu = 177,
    Lisu_Supplement = 178,
    Low_Surrogates = 179,
    Lycian = 180,
    Lydian = 181,
    Mahajani = 182,
    Mahjong_Tiles = 183,
    Makasar = 184,
    Malayalam = 185,
    Mandaic = 186,
    Manichaean = 187,
    Marchen = 188,
    Masaram_Gondi = 189,
    Mathematical_Alphanumeric_Symbols = 190,
    Mathematical_Operators = 191,
    Mayan_Numerals = 192,
    Medefaidrin = 193,
    Meetei_Mayek = 194,
    Meetei_Mayek_Extensions = 195,
    Mende_Kikakui = 196,
    Meroitic_Cursive = 197,
    Meroitic_Hieroglyphs = 198,
    Miao = 199,
    Miscellaneous_Mathematical_Symbols_A = 200,
    Miscellaneous_Mathematical_Symbols_B = 201,
    Miscellaneous_Symbols = 202,
    Miscellaneous_Symbols_and_Arrows = 203,
    Miscellaneous_Symbols_and_Pictographs = 204,
    Miscellaneous_Technical = 205,
    Modi = 206,
    Modifier_Tone_Letters = 207,
    Mongolian = 208,
    Mongolian_Supplement = 209,
    Mro = 210,
    Multani = 211,
    Musical_Symbols = 212,
    Myanmar = 213,
    Myanmar_Extended_A = 214,
    Myanmar_Extended_B = 215,
    NKo = 216,
    Nabataean = 217,
    Nag_Mundari = 218,
    Nandinagari = 219,
    New_Tai_Lue = 220,
    Newa = 221,
    Number_Forms = 222,
    Nushu = 223,
    Nyiakeng_Puachue_Hmong = 224,
    Ogham = 225,
    Ol_Chiki = 226,
    Old_Hungarian = 227,
    Old_Italic = 228,
    Old_North_Arabian = 229,
    Old_Permic = 230,
    Old_Persian = 231,
    Old_Sogdian = 232,
    Old_South_Arabian = 233,
    Old_Turkic = 234,
    Old_Uyghur = 235,
    Optical_Character_Recognition = 236,
    Oriya = 237,
    Ornamental_Dingbats = 238,
    Osage = 239,
    Osmanya = 240,
    Ottoman_Siyaq_Numbers = 241,
    Pahawh_Hmong = 242,
    Palmyrene = 243,
    Pau_Cin_Hau = 244,
    Phags_pa = 245,
    Phaistos_Disc = 246,
    Phoenician = 247,
    Phonetic_Extensions = 248,
    Phonetic_Extensions_Supplement = 249,
    Playing_Cards = 250,
    Private_Use_Area = 251,
    Psalter_Pahlavi = 252,
    Rejang = 253,
    Rumi_Numeral_Symbols = 254,
    Runic = 255,
    Samaritan = 256,
    Saurashtra = 257,
    Sharada = 258,
    Shavian = 259,
    Shorthand_Format_Controls = 260,
    Siddham = 261,
    Sinhala = 262,
    Sinhala_Archaic_Numbers = 263,
    Small_Form_Variants = 264,
    Small_Kana_Extension = 265,
    Sogdian = 266,
    Sora_Sompeng = 267,
    Soyombo = 268,
    Spacing_Modifier_Letters = 269,
    Specials = 270,
    Sundanese = 271,
    Sundanese_Supplement = 272,
    Superscripts_and_Subscripts = 273,
    Supplemental_Arrows_A = 274,
    Supplemental_Arrows_B = 275,
    Supplemental_Arrows_C = 276,
    Supplemental_Mathematical_Operators = 277,
    Supplemental_Punctuation = 278,
    Supplemental_Symbols_and_Pictographs = 279,
    Supplementary_Private_Use_Area_A = 280,
    Supplementary_Private_Use_Area_B = 281,
    Sutton_SignWriting = 282,
    Syloti_Nagri = 283,
    Symbols_and_Pictographs_Extended_A = 284,
    Symbols_for_Legacy_Computing = 285,
    Syriac = 286,
    Syriac_Supplement = 287,
    Tagalog = 288,
    Tagbanwa = 289,
    Tags = 290,
    Tai_Le = 291,
    Tai_Tham = 292,
    Tai_Viet = 293,
    Tai_Xuan_Jing_Symbols = 294,
    Takri = 295,
    Tamil = 296,
    Tamil_Supplement = 297,
    Tangsa = 298,
    Tangut = 299,
    Tangut_Components = 300,
    Tangut_Supplement = 301,
    Telugu = 302,
    Thaana = 303,
    Thai = 304,
    Tibetan = 305,
    Tifinagh = 306,
    Tirhuta = 307,
    Toto = 308,
    Transport_and_Map_Symbols = 309,
    Ugaritic = 310,
    Unified_Canadian_Aboriginal_Syllabics = 311,
    Unified_Canadian_Aboriginal_Syllabics_Extended = 312,
    Unified_Canadian_Aboriginal_Syllabics_Extended_A = 313,
    Vai = 314,
    Variation_Selectors = 315,
    Variation_Selectors_Supplement = 316,
    Vedic_Extensions = 317,
    Vertical_Forms = 318,
    Vithkuqi = 319,
    Wancho = 320,
    Warang_Citi = 321,
    Yezidi = 322,
    Yi_Radicals = 323,
    Yi_Syllables = 324,
    Yijing_Hexagram_Symbols = 325,
    Zanabazar_Square = 326,
    Znamenny_Musical_Notation = 327,
};

enum class EastAsianWidth: uint8_t
{
    Ambiguous = 0,
    FullWidth = 1,
    HalfWidth = 2,
    Neutral = 3,
    Narrow = 4,
    Wide = 5,
    Unspecified = 6,
};

} // namespace unicode
