class OkResult {
    contents;
    constructor(contents) {
        this.contents = contents;
    }
    isOk() {
        return true;
    }
    isErr() {
        return false;
    }
    mapOk(mapper) {
        return new OkResult(mapper(this.contents));
    }
    mapErr() {
        return this;
    }
    unwrap() {
        return this.contents;
    }
    unwrapOrThrow() {
        return this.contents;
    }
    orElse() {
        return this.contents;
    }
}
class ErrResult {
    contents;
    constructor(contents) {
        this.contents = contents;
    }
    isOk() {
        return false;
    }
    isErr() {
        return true;
    }
    mapOk() {
        return this;
    }
    mapErr(mapper) {
        return new ErrResult(mapper(this.contents));
    }
    unwrapErr() {
        return this.contents;
    }
    unwrapOrThrow(errToThrow) {
        throw errToThrow;
    }
    orElse(t) {
        return t;
    }
}
export function resultOf(value) {
    return new OkResult(value);
}
export function resultOfErr(value) {
    return new ErrResult(value);
}
export function isOk(result) {
    return result.isOk();
}
//# sourceMappingURL=Result.js.map