async function up(knex) {
    await knex.schema.createTable("client_searchee", (table) => {
        table.string("client_host");
        table.string("info_hash").index();
        table.primary(["client_host", "info_hash"]);
        table.string("name");
        table.string("title");
        table.json("files");
        table.integer("length");
        table.string("save_path");
        table.string("category");
        table.json("tags");
        table.json("trackers");
    });
    await knex.schema.createTable("data", (table) => {
        table.string("path").primary();
        table.string("title");
    });
    await knex.schema.createTable("ensemble", (table) => {
        table.string("client_host");
        table.string("path").index();
        table.primary(["client_host", "path"]);
        table.string("info_hash").index();
        table.string("ensemble");
        table.string("element");
    });
}
async function down(knex) {
    void knex.schema.dropTable("client_searchee");
    void knex.schema.dropTable("data");
    void knex.schema.dropTable("ensemble");
}
export default { name: "09-clientAndDataSearchees", up, down };
//# sourceMappingURL=09-clientAndDataSearchees.js.map