import { readFile, rename } from "fs/promises";
import path from "path";
import { appDir, createAppDir } from "./configuration.js";
createAppDir();
export async function getCacheFileData() {
    return readFile(path.join(appDir(), "cache.json"))
        .then((data) => JSON.parse(data.toString()))
        .catch(() => undefined);
}
export async function renameCacheFile() {
    return rename(path.join(appDir(), "cache.json"), path.join(appDir(), "old-cache.bak.json"));
}
//# sourceMappingURL=cache.js.map