import { createRequire } from "module";
const require = createRequire(import.meta.url);
const packageDotJson = require("../package.json");
export const PROGRAM_NAME = packageDotJson.name;
export const PROGRAM_VERSION = packageDotJson.version;
export const USER_AGENT = `CrossSeed/${PROGRAM_VERSION}`;
export const TORRENT_TAG = "cross-seed";
export const TORRENT_CATEGORY_SUFFIX = `.cross-seed`;
export const NEWLINE_INDENT = "\n\t\t\t\t";
export const EP_REGEX = /^(?<title>.+?)[_.\s-]+(?:(?<season>S\d+)?[_.\s-]{0,3}(?!(?:19|20)\d{2})(?<episode>(?:E|(?<=S\d+[_\s-]{1,3}))\d+(?:[\s-]?(?!(?:19|20)\d{2})E?\d+)?(?![pix]))(?!\d+[pix])|(?<date>(?<year>(?:19|20)\d{2})[_.\s-](?<month>\d{2})[_.\s-](?<day>\d{2})))/i;
export const IS_MULTI_EP_REGEX = /E\d+(?:[-.]?S\d+E\d|[-.]?E\d|[-.]\d)/i;
export const SEASON_REGEX = /^(?<title>.+?)[[_.\s-]+(?<season>S(?:eason)?\s*\d+)(?=\b(?![_.\s~-]*E\d+))/i;
export const MOVIE_REGEX = /^(?<title>.+?)-?[_.\s][[(]?(?<year>(?:18|19|20)\d{2})[)\]]?(?![pix])/i;
export const ANIME_REGEX = /^(?:\[(?<group>.*?)\][_\s-]?)?(?:\[?(?<title>.+?)[_\s-]?(?:\(?(?:\d{1,2}(?:st|nd|rd|th))?\s?Season)?[_\s-]?\]?)(?:[([~/|-]\s?(?!\d{1,4})(?<altTitle>.+?)[)\]~-]?\s?)?[_\s-]?(?:[[(]?(?<year>(?:19|20)\d{2})[)\]]?)?[[_\s-](?:S\d{1,2})?[_\s-]{0,3}(?:#|EP?|(?:SP))?[_\s-]{0,3}(?!\d+[a-uw-z])(?<release>\d{1,4})(?!\.[0-46-9])/i;
export const RELEASE_GROUP_REGEX = /(?<=-)(?:\W|\b)(?!(?:\d{3,4}[ip]))(?!\d+\b)(?:\W|\b)(?<group>[\w .]+?)(?:\[.+\])?(?:\))?(?:\s\[.+\])?$/i;
export const ANIME_GROUP_REGEX = /^\s*\[(?<group>.+?)\]/i;
export const RESOLUTION_REGEX = /\b(?<res>\d{3,4}[pix](?:\d{3,4}[pi]?)?)\b/i;
export const RES_STRICT_REGEX = /(?<res>(?:2160|1080|720)[pi])/;
export const YEARS_REGEX = /(?<year>(?:19|20)\d{2})(?![pix])/gi;
export const REPACK_PROPER_REGEX = /(?:\b(?<type>(?:REPACK|PROPER|\d\v\d)\d?))\b/i;
export const ARR_PROPER_REGEX = /(?:\b(?<arrtype>(?:Proper|v\d)))\b/;
export const SCENE_TITLE_REGEX = /^(?:[a-z0-9]{0,5}-)?(?<title>.*)/;
export const ARR_DIR_REGEX = /^(?<title>(?!.*(?:(\d{3,4}[ipx])|([xh.]+26[4-6])|(dvd)|(mpeg)|(xvid)|(?:(he)|a)vc))[\p{L}\s:\w'’!();.,&–+-]+(?:\(\d{4}\))?)(?<id>\s[{[](?:tm|tv|im)db(?:id)?-\w+?[}\]])?$/iu;
export const SONARR_SUBFOLDERS_REGEX = /^(?:S(?:eason )?(?<seasonNum>\d{1,4}))$/i;
export const NON_UNICODE_ALPHANUM_REGEX = /[^\p{L}\p{N}]+/giu;
export const CALIBRE_INDEXNUM_REGEX = /\s?\(\d+\)$/;
export const SAVED_TORRENTS_INFO_REGEX = /^\[(?<mediaType>.+?)\]\[(?<tracker>.+?)\](?<name>.+?)(?:\[[^\]]*?\])?\.torrent$/i;
export const BAD_GROUP_PARSE_REGEX = /^(?<badmatch>(?:dl|DDP?|aac|eac3|atmos|dts|ma|hd|[heav.c]{3.5}|[xh.]{1,2}[2456]|[0-9]+[ip]?|dxva|full|blu|ray|s(?:eason)?\W\d+|\W){3,})$/i;
export const JSON_VALUES_REGEX = /".+?"\s*:\s*"(?<value>.+?)"\s*(?:,|})/g;
export const ABS_WIN_PATH_REGEX = /^[a-z]:|^\\/i;
// Needs to be handled through helper functions since there are variations
const SOURCE_REGEXES = {
    AMZN: /\b(amzn|amazon(hd)?)\b[ ._-]web[ ._-]?(dl|rip)?\b/i,
    DSNP: /\b(dsnp|dsny|disney)\b/i,
    NF: /\b(nf|netflix(u?hd)?)\b/i,
    HULU: /\b(hulu)\b/i,
    ATVP: /\b(atvp|aptv)\b/i,
    HBO: /\b(hbo)(?![ ._-]max)\b|\b(hmax|hbom|hbo[ ._-]max)\b/i,
    PCOK: /\b(pcok)\b/i,
    PMTP: /\b(pmtp|Paramount Plus)\b/i,
};
export function parseSource(title) {
    for (const [source, regex] of Object.entries(SOURCE_REGEXES)) {
        if (regex.test(title))
            return source;
    }
    return null;
}
export function sourceRegexRemove(title) {
    const originalLength = title.length;
    for (const regex of Object.values(SOURCE_REGEXES)) {
        const newTitle = title.replace(regex, "");
        if (newTitle.length !== originalLength)
            return newTitle;
    }
    return title;
}
export const VIDEO_EXTENSIONS = [".mkv", ".mp4", ".avi", ".ts"];
export const VIDEO_DISC_EXTENSIONS = [".m2ts", ".ifo", ".vob", ".bup"];
export const AUDIO_EXTENSIONS = [
    ".wav",
    ".aiff",
    ".alac",
    ".flac",
    ".ape",
    ".mp3",
    ".aac",
    ".m4a",
    ".m4b",
    ".m4p",
    ".ogg",
    ".wma",
    ".aa",
    ".aax",
];
export const BOOK_EXTENSIONS = [
    ".epub",
    ".mobi",
    ".azw",
    ".azw3",
    ".azw4",
    ".pdf",
    ".djvu",
    ".html",
    ".chm",
    ".cbr",
    ".cbz",
    ".cb7",
    ".cbt",
    ".cba",
];
export const ALL_EXTENSIONS = [
    ...VIDEO_EXTENSIONS,
    ...AUDIO_EXTENSIONS,
    ...BOOK_EXTENSIONS,
    ...VIDEO_DISC_EXTENSIONS,
];
export const TORRENT_CACHE_FOLDER = "torrent_cache";
export const UNKNOWN_TRACKER = "UnknownTracker";
export const LEVENSHTEIN_DIVISOR = 3;
export var MediaType;
(function (MediaType) {
    MediaType["EPISODE"] = "episode";
    MediaType["SEASON"] = "pack";
    MediaType["MOVIE"] = "movie";
    MediaType["ANIME"] = "anime";
    MediaType["VIDEO"] = "video";
    MediaType["AUDIO"] = "audio";
    MediaType["BOOK"] = "book";
    MediaType["OTHER"] = "unknown";
})(MediaType || (MediaType = {}));
export var Action;
(function (Action) {
    Action["SAVE"] = "save";
    Action["INJECT"] = "inject";
})(Action || (Action = {}));
export var InjectionResult;
(function (InjectionResult) {
    InjectionResult["SUCCESS"] = "INJECTED";
    InjectionResult["FAILURE"] = "FAILURE";
    InjectionResult["ALREADY_EXISTS"] = "ALREADY_EXISTS";
    InjectionResult["TORRENT_NOT_COMPLETE"] = "TORRENT_NOT_COMPLETE";
})(InjectionResult || (InjectionResult = {}));
export var SaveResult;
(function (SaveResult) {
    SaveResult["SAVED"] = "SAVED";
})(SaveResult || (SaveResult = {}));
export var Decision;
(function (Decision) {
    Decision["MATCH"] = "MATCH";
    Decision["MATCH_SIZE_ONLY"] = "MATCH_SIZE_ONLY";
    Decision["MATCH_PARTIAL"] = "MATCH_PARTIAL";
    Decision["FUZZY_SIZE_MISMATCH"] = "FUZZY_SIZE_MISMATCH";
    Decision["SIZE_MISMATCH"] = "SIZE_MISMATCH";
    Decision["PARTIAL_SIZE_MISMATCH"] = "PARTIAL_SIZE_MISMATCH";
    Decision["NO_DOWNLOAD_LINK"] = "NO_DOWNLOAD_LINK";
    Decision["DOWNLOAD_FAILED"] = "DOWNLOAD_FAILED";
    Decision["MAGNET_LINK"] = "MAGNET_LINK";
    Decision["RATE_LIMITED"] = "RATE_LIMITED";
    /**
     * Searchee and Candidate info hash matches. Usually happens with public
     * torrents and torrents added by radarr/sonarr before cross-seed on announces.
     * Useful for the inject job as we ignore INFO_HASH_ALREADY_EXISTS and
     * for reporting a 204 announce status code instead of 200 from exists.
     */
    Decision["SAME_INFO_HASH"] = "SAME_INFO_HASH";
    /**
     * Checked after SAME_INFO_HASH.
     */
    Decision["INFO_HASH_ALREADY_EXISTS"] = "INFO_HASH_ALREADY_EXISTS";
    Decision["FILE_TREE_MISMATCH"] = "FILE_TREE_MISMATCH";
    Decision["RELEASE_GROUP_MISMATCH"] = "RELEASE_GROUP_MISMATCH";
    Decision["BLOCKED_RELEASE"] = "BLOCKED_RELEASE";
    Decision["PROPER_REPACK_MISMATCH"] = "PROPER_REPACK_MISMATCH";
    Decision["RESOLUTION_MISMATCH"] = "RESOLUTION_MISMATCH";
    Decision["SOURCE_MISMATCH"] = "SOURCE_MISMATCH";
})(Decision || (Decision = {}));
export function isAnyMatchedDecision(decision) {
    return (decision === Decision.MATCH ||
        decision === Decision.MATCH_SIZE_ONLY ||
        decision === Decision.MATCH_PARTIAL);
}
export function isStaticDecision(decision) {
    return (decision === Decision.RELEASE_GROUP_MISMATCH ||
        decision === Decision.RESOLUTION_MISMATCH ||
        decision === Decision.SOURCE_MISMATCH ||
        decision === Decision.PROPER_REPACK_MISMATCH ||
        decision === Decision.MAGNET_LINK);
}
export var MatchMode;
(function (MatchMode) {
    MatchMode["SAFE"] = "safe";
    MatchMode["RISKY"] = "risky";
    MatchMode["PARTIAL"] = "partial";
})(MatchMode || (MatchMode = {}));
export var LinkType;
(function (LinkType) {
    LinkType["SYMLINK"] = "symlink";
    LinkType["HARDLINK"] = "hardlink";
})(LinkType || (LinkType = {}));
export var BlocklistType;
(function (BlocklistType) {
    BlocklistType["NAME"] = "name";
    BlocklistType["NAME_REGEX"] = "nameRegex";
    BlocklistType["FOLDER"] = "folder";
    BlocklistType["FOLDER_REGEX"] = "folderRegex";
    BlocklistType["CATEGORY"] = "category";
    BlocklistType["TAG"] = "tag";
    BlocklistType["TRACKER"] = "tracker";
    BlocklistType["INFOHASH"] = "infoHash";
    BlocklistType["SIZE_BELOW"] = "sizeBelow";
    BlocklistType["SIZE_ABOVE"] = "sizeAbove";
    BlocklistType["LEGACY"] = "legacy";
})(BlocklistType || (BlocklistType = {}));
const PARSE_BLOCKLIST_REGEX = /^(?<blocklistType>.+?):(?<blocklistValue>.*)$/;
export function parseBlocklistEntry(blocklistEntry) {
    const match = blocklistEntry.match(PARSE_BLOCKLIST_REGEX);
    if (match?.groups) {
        return {
            blocklistType: match.groups.blocklistType,
            blocklistValue: match.groups.blocklistValue,
        };
    }
    return {
        blocklistType: BlocklistType.LEGACY,
        blocklistValue: blocklistEntry,
    };
}
export const IGNORED_FOLDERS_SUBSTRINGS = [
    "sample",
    "proof",
    "bdmv",
    "bdrom",
    "certificate",
    "video_ts",
];
//# sourceMappingURL=constants.js.map