'use strict';

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
require("core-js/modules/es.reflect.construct.js");
require("core-js/modules/es.object.create.js");
require("core-js/modules/es.object.define-property.js");
require("core-js/modules/es.symbol.to-primitive.js");
require("core-js/modules/es.date.to-primitive.js");
require("core-js/modules/es.symbol.js");
require("core-js/modules/es.symbol.description.js");
require("core-js/modules/es.number.constructor.js");
require("core-js/modules/es.symbol.iterator.js");
require("core-js/modules/es.array.iterator.js");
require("core-js/modules/es.string.iterator.js");
require("core-js/modules/web.dom-collections.iterator.js");
require("core-js/modules/es.date.now.js");
require("core-js/modules/es.date.to-string.js");
require("core-js/modules/web.timers.js");
require("core-js/modules/es.object.to-string.js");
require("core-js/modules/es.regexp.to-string.js");
require("core-js/modules/es.array.slice.js");
require("core-js/modules/es.array.for-each.js");
require("core-js/modules/web.dom-collections.for-each.js");
require("core-js/modules/es.object.set-prototype-of.js");
require("core-js/modules/es.function.bind.js");
require("core-js/modules/es.object.get-prototype-of.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var _ = {
  pull: require('lodash/pull')
};
var EventEmitter = require('eventemitter3');
var ircLineParser = require('./irclineparser');
module.exports = /*#__PURE__*/function (_EventEmitter) {
  _inherits(Connection, _EventEmitter);
  var _super = _createSuper(Connection);
  function Connection(options) {
    var _this;
    _classCallCheck(this, Connection);
    _this = _super.call(this);
    _this.options = options || {};
    _this.connected = false;
    _this.requested_disconnect = false;
    _this.reconnect_attempts = 0;

    // When an IRC connection was successfully registered.
    _this.registered = false;
    _this.transport = null;
    _this._timers = [];
    return _this;
  }
  _createClass(Connection, [{
    key: "debugOut",
    value: function debugOut(out) {
      this.emit('debug', out);
    }
  }, {
    key: "registeredSuccessfully",
    value: function registeredSuccessfully() {
      this.registered = Date.now();
    }
  }, {
    key: "connect",
    value: function connect(options) {
      var that = this;
      if (options) {
        this.options = options;
      }
      options = this.options;
      this.auto_reconnect = options.auto_reconnect || false;
      this.auto_reconnect_max_retries = options.auto_reconnect_max_retries || 3;
      this.auto_reconnect_max_wait = options.auto_reconnect_max_wait || 300000;
      if (this.transport) {
        this.clearTimers();
        this.transport.removeAllListeners();
        this.transport.disposeSocket();
      }
      this.transport = new options.transport(options);
      if (!options.encoding || !this.setEncoding(options.encoding)) {
        this.setEncoding('utf8');
      }
      bindTransportEvents(this.transport);
      this.registered = false;
      this.requested_disconnect = false;
      this.emit('connecting');
      this.transport.connect();
      function bindTransportEvents(transport) {
        transport.on('open', socketOpen);
        transport.on('line', socketLine);
        transport.on('close', socketClose);
        transport.on('debug', transportDebug);
        transport.on('extra', transportExtra);
      }
      function transportDebug(out) {
        that.debugOut(out);
      }
      function transportExtra() {
        // Some transports may emit extra events
        that.emit.apply(that, arguments);
      }

      // Called when the socket is connected and ready to start sending/receiving data.
      function socketOpen() {
        that.debugOut('Socket fully connected');
        that.reconnect_attempts = 0;
        that.connected = true;
        that.emit('socket connected');
      }
      function socketLine(line) {
        that.addReadBuffer(line);
      }
      function socketClose(err) {
        var was_connected = that.connected;
        var should_reconnect = false;
        var safely_registered = false;
        var registered_ms_ago = Date.now() - that.registered;

        // Some networks use aKills which kill a user after succesfully
        // registering instead of a ban, so we must wait some time after
        // being registered to be sure that we are connected properly.
        safely_registered = that.registered !== false && registered_ms_ago > 5000;
        that.debugOut('Socket closed. was_connected=' + was_connected + ' safely_registered=' + safely_registered + ' requested_disconnect=' + that.requested_disconnect);
        that.connected = false;
        that.clearTimers();
        that.emit('socket close', err);
        if (that.requested_disconnect || !that.auto_reconnect) {
          should_reconnect = false;

          // If trying to reconnect, continue with it
        } else if (that.reconnect_attempts && that.reconnect_attempts < that.auto_reconnect_max_retries) {
          should_reconnect = true;

          // If we were originally connected OK, reconnect
        } else if (was_connected && safely_registered) {
          should_reconnect = true;
        } else {
          should_reconnect = false;
        }
        if (should_reconnect) {
          var reconnect_wait = that.calculateExponentialBackoff();
          that.reconnect_attempts++;
          that.emit('reconnecting', {
            attempt: that.reconnect_attempts,
            max_retries: that.auto_reconnect_max_retries,
            wait: reconnect_wait
          });
          that.debugOut('Scheduling reconnect. Attempt: ' + that.reconnect_attempts + '/' + that.auto_reconnect_max_retries + ' Wait: ' + reconnect_wait + 'ms');
          that.setTimeout(function () {
            return that.connect();
          }, reconnect_wait);
        } else {
          that.transport.removeAllListeners();
          that.emit('close', !!err);
          that.reconnect_attempts = 0;
        }
      }
    }
  }, {
    key: "calculateExponentialBackoff",
    value: function calculateExponentialBackoff() {
      var jitter = 1000 + Math.floor(Math.random() * 5000);
      var attempts = Math.min(this.reconnect_attempts, 30);
      var time = 1000 * Math.pow(2, attempts);
      return Math.min(time, this.auto_reconnect_max_wait) + jitter;
    }
  }, {
    key: "addReadBuffer",
    value: function addReadBuffer(line) {
      if (!line) {
        // Empty line
        return;
      }
      this.emit('raw', {
        line: line,
        from_server: true
      });
      var message = ircLineParser(line);
      if (!message) {
        // A malformed IRC line
        return;
      }
      this.emit('message', message, line);
    }
  }, {
    key: "write",
    value: function write(data, callback) {
      if (!this.connected || this.requested_disconnect) {
        this.debugOut('write() called when not connected');
        if (callback) {
          setTimeout(callback, 0); // fire in next tick
        }

        return false;
      }
      this.emit('raw', {
        line: data,
        from_server: false
      });
      return this.transport.writeLine(data, callback);
    }

    /**
     * Create and keep track of all timers so they can be easily removed
     */
  }, {
    key: "setTimeout",
    value: function (_setTimeout) {
      function setTimeout() {
        return _setTimeout.apply(this, arguments);
      }
      setTimeout.toString = function () {
        return _setTimeout.toString();
      };
      return setTimeout;
    }(function /* fn, length, argN */
    () {
      var that = this;
      var tmr = null;
      var args = Array.prototype.slice.call(arguments, 0);
      var callback = args[0];
      args[0] = function () {
        _.pull(that._timers, tmr);
        callback.apply(null, args);
      };
      tmr = setTimeout.apply(null, args);
      this._timers.push(tmr);
      return tmr;
    })
  }, {
    key: "clearTimeout",
    value: function (_clearTimeout) {
      function clearTimeout(_x) {
        return _clearTimeout.apply(this, arguments);
      }
      clearTimeout.toString = function () {
        return _clearTimeout.toString();
      };
      return clearTimeout;
    }(function (tmr) {
      clearTimeout(tmr);
      _.pull(this._timers, tmr);
    })
  }, {
    key: "clearTimers",
    value: function clearTimers() {
      this._timers.forEach(function (tmr) {
        clearTimeout(tmr);
      });
      this._timers = [];
    }

    /**
     * Close the connection to the IRCd after forcing one last line
     */
  }, {
    key: "end",
    value: function end(data, had_error) {
      var that = this;
      this.debugOut('Connection.end() connected=' + this.connected + ' with data=' + !!data + ' had_error=' + !!had_error);
      if (this.connected && data) {
        // Once the last bit of data has been sent, then re-run this function to close the socket
        this.write(data, function () {
          that.end(null, had_error);
        });
        return;
      }

      // Shutdowns of the connection may be caused by errors like ping timeouts, which
      // are not requested by the user so we leave requested_disconnect as false to make sure any
      // reconnects happen.
      if (!had_error) {
        this.requested_disconnect = true;
        this.clearTimers();
      }
      if (this.transport) {
        this.transport.close(!!had_error);
      }
    }
  }, {
    key: "setEncoding",
    value: function setEncoding(encoding) {
      this.debugOut('Connection.setEncoding() encoding=' + encoding);
      if (this.transport) {
        return this.transport.setEncoding(encoding);
      }
    }
  }]);
  return Connection;
}(EventEmitter);