'use strict';

/**
 * Websocket transport
 */
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
require("core-js/modules/es.reflect.construct.js");
require("core-js/modules/es.object.create.js");
require("core-js/modules/es.object.define-property.js");
require("core-js/modules/es.symbol.to-primitive.js");
require("core-js/modules/es.date.to-primitive.js");
require("core-js/modules/es.symbol.js");
require("core-js/modules/es.symbol.description.js");
require("core-js/modules/es.number.constructor.js");
require("core-js/modules/es.symbol.iterator.js");
require("core-js/modules/es.array.iterator.js");
require("core-js/modules/es.string.iterator.js");
require("core-js/modules/web.dom-collections.iterator.js");
require("core-js/modules/web.timers.js");
require("core-js/modules/es.array.for-each.js");
require("core-js/modules/es.object.to-string.js");
require("core-js/modules/web.dom-collections.for-each.js");
require("core-js/modules/es.object.set-prototype-of.js");
require("core-js/modules/es.function.bind.js");
require("core-js/modules/es.object.get-prototype-of.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var EventEmitter = require('eventemitter3');
module.exports = /*#__PURE__*/function (_EventEmitter) {
  _inherits(Connection, _EventEmitter);
  var _super = _createSuper(Connection);
  function Connection(options) {
    var _this;
    _classCallCheck(this, Connection);
    _this = _super.call(this);
    _this.options = options || {};
    _this.socket = null;
    _this.connected = false;
    _this.last_socket_error = null;
    _this.encoding = 'utf8';
    _this.incoming_buffer = '';
    _this.protocol_fallback = false;

    // JSON does not allow undefined and websocket protocol does not allow falsy
    // if the protocol is falsy then the user intends no protocol, so set to undefined
    _this.protocol = options.websocket_protocol ? options.websocket_protocol : undefined;
    return _this;
  }
  _createClass(Connection, [{
    key: "isConnected",
    value: function isConnected() {
      return this.connected;
    }
  }, {
    key: "writeLine",
    value: function writeLine(line, cb) {
      this.debugOut('writeLine() socket=' + (this.socket ? 'yes' : 'no') + ' connected=' + this.connected);
      if (this.socket && this.connected) {
        this.socket.send(line);
      }

      // Websocket.send() does not support callbacks
      // call the callback in the next tick instead
      if (cb) {
        setTimeout(cb, 0);
      }
    }
  }, {
    key: "debugOut",
    value: function debugOut(out) {
      this.emit('debug', out);
    }
  }, {
    key: "connect",
    value: function connect() {
      var that = this;
      var options = this.options;
      var socket = null;
      var ws_addr = '';
      this.debugOut('Connection.connect()');
      this.disposeSocket();
      this.requested_disconnect = false;

      // Build the websocket address. eg. ws://ws.rizon.net:8080
      ws_addr += options.tls || options.ssl ? 'wss://' : 'ws://';
      ws_addr += options.host;
      ws_addr += options.port ? ':' + options.port : '';
      ws_addr += options.path ? options.path : '';
      socket = this.socket = new WebSocket(ws_addr, this.protocol);
      socket.onopen = function () {
        that.onSocketFullyConnected();
      };
      socket.onclose = function (event) {
        that.onSocketClose(event);
      };
      socket.onmessage = function (event) {
        that.onSocketMessage(event.data);
      };
      socket.onerror = function (err) {
        that.debugOut('socketError() ' + err.message);
        that.last_socket_error = err;
      };
    }

    // Called when the socket is connected and ready to start sending/receiving data.
  }, {
    key: "onSocketFullyConnected",
    value: function onSocketFullyConnected() {
      this.debugOut('socketFullyConnected()');
      this.last_socket_error = null;
      this.connected = true;
      this.emit('open');
    }
  }, {
    key: "onSocketClose",
    value: function onSocketClose(event) {
      var possible_protocol_error = !this.connected && event.code === 1006;
      if (possible_protocol_error && !this.protocol_fallback && this.protocol !== undefined) {
        // First connection attempt failed possibly due to mismatched protocol,
        //  retry the connection with undefined protocol
        // After this attempt, normal reconnect functions apply which will
        //  reconstruct this websocket, resetting these variables
        this.debugOut('socketClose() possible protocol error, retrying with no protocol');
        this.protocol_fallback = true;
        this.protocol = undefined;
        this.connect();
        return;
      }
      this.debugOut('socketClose()');
      this.connected = false;
      this.emit('close', this.last_socket_error ? this.last_socket_error : false);
    }
  }, {
    key: "onSocketMessage",
    value: function onSocketMessage(data) {
      if (typeof data !== 'string') {
        this.last_socket_error = new Error('Websocket received unexpected binary data, closing the connection');
        this.debugOut('socketData() ' + this.last_socket_error.message);
        this.close();
        return;
      }
      this.debugOut('socketData() ' + JSON.stringify(data));
      var that = this;
      var lines = null;
      this.incoming_buffer += data + '\n';
      lines = this.incoming_buffer.split('\n');
      if (lines[lines.length - 1] !== '') {
        this.incoming_buffer = lines.pop();
      } else {
        lines.pop();
        this.incoming_buffer = '';
      }
      lines.forEach(function (line) {
        that.emit('line', line);
      });
    }
  }, {
    key: "disposeSocket",
    value: function disposeSocket() {
      this.debugOut('Connection.disposeSocket() connected=' + this.connected);
      if (this.socket && this.connected) {
        this.socket.close();
      }
      if (this.socket) {
        this.socket.onopen = null;
        this.socket.onclose = null;
        this.socket.onmessage = null;
        this.socket.onerror = null;
        this.socket = null;
      }
    }
  }, {
    key: "close",
    value: function close() {
      if (this.socket && this.connected) {
        this.socket.close();
      }
    }
  }, {
    key: "setEncoding",
    value: function setEncoding(encoding) {}
  }]);
  return Connection;
}(EventEmitter);